	;; 
		org	0x100	

	;; (C) Copyright ct, Peter Siering, Hannover

	;; Version 1.0, vom 26.1.1999 (dritte Januarwoche ;-))

	;; Man moege den etwas kneifzangenmaessigen Programmierstil
	;; verzeihen, aber erstens sollte dieses Programm vor dem Jahr
	;; 2000 fertig werden, zweitens wurde der Autor durch mehrere
	;; Jahre MASM-Praxis (es leben die Phase-Errors!) konditioniert
	;; und drittens waere ein anderer Assembler als as86 sicher keine
	;; schlechte Wahl gewesen.

	;; Version 1.1, 1.2 nie veroeffentlicht, intern
	;; - lesende CMOS/RTC-Zugriffe via cli/sti geschuetzt
	;; - CR/LF-Ausgleich (falsche Reihenfolge ;-))

	;; Version 1.3 vom 30. Juli 1999 (...)
	;; - Differenzieren des BIOS-Korrekturcodes (permanente
	;;   Ueberwachung in IRQ8-ISR
	;; - Fehlende Fehlermeldung ergaenzt, falls BIOS Datumsaenderungen
	;;   nicht nimmt (bios_error_msg statt bios_error (label))
	;; - Variablen-Init bei mehrfacher Verwendung der Diskette (lief
	;;   das Programm auf einem System mit ungewoehnlichem CMOS-Byte,
	;;   dann ging es nicht in Grundeinstellung zurueck und hat den
	;;   Jahrhundert-Byte-Test unterschlagen).

entrypoint:	jmp	start
	
	;; Variablen (teils persistent fuer Reboot-Tests)

		.ascii	"NODOS"
no_dos:		.byte	0
verbose_mode:	.byte	0
cur_time:	.word	0, 0
cur_date:	.word	0, 0
skip_v86:	.byte	0
run_count:	.byte	0
force_post:	.byte	0
check_century:	.byte	1
cmos_century:	.byte	0x32
has_hyper_rtc:	.byte	0
has_cheat_rtc:	.byte	0
no_century_fix:	.byte	0
null_idt:	.word	0, 0, 0, 0
reset_msg:	.word	0
data_length	equ	( buffer_end- cur_time)
data_sectors	equ	( data_length/ 512)+ 1
code_length	equ	( standalone_ends- 0x100)
code_sectors	equ	( code_length/ 512)+ 1
image_mode:	.byte	0

	;; Hier wird ein kurzes Testfazit gesammalt, um es 
	;; am Ende auszugeben.
	
buffer_ends:	.word	buffer
final_msg:	.byte	13,10
		.ascii	"Zusammenfassung:"
		.byte	13,10
buffer:		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
		.ascii	"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
buffer_end:		
buffer_len	equ	( buffer_end- buffer)
	
	;; fuer Korrektur der RTC nach Testende
	
mins_runtime:	.word	0
month_info:	.byte	31,28,31,30,31,30,31,31,30,31,30,31
	
	;; Beim Programmstart wird Sprungtabelle bemueht
	
entry_tab:	.word	bios_test, post_test, fix_test
	
	;; Augaberoutine mit zwei Eintrittspunkten
	;; printstr gibt aus und schreibt in Ausgabepuffer (fuer spaetere Ausgabe)
	;; printstrv gibt nur aus, puffert aber nichts
	;; $ bedeutet Ende; automatische Wahl der Funktion (DOS/BIOS)
	
printstr:	push	ax
		push	si
		push	di
		push	es

		push	ds
		pop	es
		cld
		
		mov	si, dx
		mov	di, word ptr [buffer_ends]

save_loop:	lodsb
		cmp	al, #0x24
		je	save_end
		stosb
		cmp	di, #buffer_end
		jb	save_loop
	
	;; Pufferueberlauf !!!
	
		int	3
		
save_end:	mov	word ptr [buffer_ends], di
		pop	es
		pop	di
		pop	si
		pop	ax

printstrv:	push	ax
		cmp	byte ptr [no_dos], #1
		jne	dos_print

		push	bx
		push	cx
		mov	bx, dx

bios_print:	mov	al, byte ptr [bx]
		cmp	al, #0x24 ; $ - Endemarke
		je	print_done
		mov	ah, #0xe
		int	0x10
		inc	bx
		jmp	bios_print
	
print_done:	pop	cx
		pop	bx
		pop	ax
		ret

	;; Je nach Ausgangslage in DOS-Funktion weitervermitteln oder
	;; den/die ersten Programmsektoren auf der Floppy beschreiben.
	
write_data:	cmp	byte ptr no_dos, #1
		jne	write_file

	;; obligatorischer Reset
	
		xor	ax, ax
		mov	dl, #0
		int	0x13
		mov	al, ah
		jc	write_done 

		mov	bx, #5
write_sector:	push	bx
		mov	ax, ds
		mov	es, ax
		mov	bx, #0x100
		mov	ah, #3
		mov	al, #data_sectors
		xor	dx, dx
		mov	cx, #0x2
		int	0x13
		pop	bx
		jnc	write_done
		dec	bx
		jnz	write_sector
		stc
		mov	al, ah
		
write_done:	ret

reset_buffer:	mov	al, #0x24 
		mov	di, #buffer
		push	ds
		pop	es
		mov	cx, #buffer_len
		cld
		rep
		stosb
		mov	ax, #buffer
		mov	word ptr buffer_ends, ax
		ret

	;; *** Setzt Test-Datensatz in Ausgangszustand zurueck
	
reset_data:	cmp	byte ptr no_dos, #1
		jne	delete_file

		xor	al, al
		mov	byte ptr run_count, al
		mov	byte ptr has_hyper_rtc, al
		mov	byte ptr has_cheat_rtc, al
		mov	byte ptr no_century_fix, al
		mov	byte ptr cmos_century, #0x32
		
		mov	ax, #buffer
		mov	word ptr buffer_ends, ax

	;; Puffer fuer Zusammenfassung zuruecksetzen

		call	reset_buffer	
		mov	bx, #5	
		jmp	write_sector
		
	;; *** Gibt das Datum laut BIOS aus (CX=Jahr, DX=Monat+Tag)
	
dot:		.ascii	".$"
	
print_rtc:	cmp	byte ptr [verbose_mode], #1
		jne	print_rtc_done

		push	cx
		push	dx
		mov	al, dl
		call	print_bcd
		push	dx
		mov	dx, #dot
		call	printstrv
		pop	dx
		mov	al, dh
		call	print_bcd
		mov	dx, #dot
		call	printstrv
		mov	al, ch
		call	print_bcd
		mov	al, cl
		call	print_bcd
		mov	dx, #space
		call	printstrv
		pop	dx
		pop	cx
		
print_rtc_done:	ret

out_area:	.ascii	"00$"
	
print_bcd:	push	bx
		push	dx
		mov	bx, #0x3030
		mov	word ptr out_area, bx
		mov	bx, #out_area+ 1
next_bcd_digit:	push	ax
		and	al, #0xf
		add	al, #48
		mov	byte ptr [bx], al
		pop	ax
		dec	bx
		shr	al, #4
		jnz	next_bcd_digit
		mov	dx, #out_area
		call	printstrv	
print_bcd_done:	pop	dx
		pop	bx
		ret
		
	;; Umwandeln BCD-Byte in AL auf binaer
	
bcd_to_bin:	push	cx
		push	dx
		mov	dh, ah	; sichern ah
		mov	dl, al	; 1er Stellen sichern
		and	dl, #0xf
		shr	al, #4	; 10er in einer umwandeln
		mov	cl, #10 
		mul	al, cl
		add	al, dl
		mov	ah, dh	; wiederherstellen ah
		pop	dx
		pop	cx
		ret

	;; Umwandeln binaer in AL auf BCD

bin_to_bcd:
		push	dx
		mov	dh, ah	; AH sichern
		mov	dl, #10	; Teiler
		xor	ah, ah
		div	al, dl
		shl	al, #4
		or	al, ah
		mov	ah, dh	; AH wiederherstellen
		pop	dx
		ret		
	
	;; Umrechnen der BCD-Zeit in CX in Minuten (=> AX)

make_mins:	push	bx
		push	dx
		mov	al, cl
		call	bcd_to_bin
		xor	ah, ah
		mov	bx, ax
		mov	al, ch
		call	bcd_to_bin
		xor	ah, ah
		mov	dx, #60
		mul	ax, dx
		add	ax, bx
		pop	dx
		pop	bx
		ret

	;; Umrechnen der Minutenzahl in AX in BCD-Zeit (=>CX)

make_abs_time:	push	cx
		push	dx
		xor	dx, dx
		mov	cx, #60
		div	cx
		xchg	al, ah
		mov	al, dl
		call	bin_to_bcd
		xchg	ah, al
		call	bin_to_bcd
		xchg	al, ah
		pop	dx
		pop	cx
		ret

	;; setzt via BIOS das gemaess Konvention angebene Datum
	;; und ueberprueft, ob das BIOS dieses auch setzt!
	
save_set_date:	push	cx
		push	dx
		mov	ah, #5
		int	0x1a

		mov	ah, #4
		int	0x1a
		pop	ax
		cmp	ax, dx
		pop	ax
		jne	bad_bios
		cmp	ax, cx
		jne	bad_bios

save_set_datee:	ret

bad_bios:	call	print_rtc
		mov	dx, #bios_error_msg
		call	printstrv
		call	restore_rtc
		jmp	error_exit

	;; Wenn das Jahrhundertbyte geaendert waere, ist ein PC von
	;; der Hardware-Seite her Jahr-2000-kompatibel

	;; Fehlermeldungen in Abhaegigkeit von run_count
	
check_cmos_century:	

		cmp	byte ptr check_century, #1
		jne	century_check_end
	
		mov	byte ptr no_century_fix, #0
	
		mov	al, byte ptr cmos_century
		pushf
		cli
		out	0x70, al
		in	al, 0x71
		popf

		cmp	al, #0x20
		je	y2k_rtc

		mov	dx, #rtc_not_ready
		call	printstrv
		mov	byte ptr no_century_fix, #1
		jmp	century_check_end

y2k_rtc:	cmp	byte ptr [run_count], #0
		je	hyper_rtc_found

		cmp	byte ptr [run_count], #8
		je	cheat_rtc_found

		cmp	byte ptr [run_count], #9
		jne	no_silence
		mov	byte ptr no_century_fix, #0
		je	century_check_end
	
no_silence:	mov	dx, #rtc_ready
		call	printstrv
		jmp	century_check_end
	
cheat_rtc_found:
		mov	byte ptr [has_cheat_rtc], #1
		mov	dx, #cheat_rtc
		call	printstrv
		jmp	century_check_end

hyper_rtc_found:
		mov	byte ptr [has_hyper_rtc], #1
		mov	dx, #hyper_rtc
		call	printstrv

century_check_end:
		ret

	;; Stellt RTC-Einstellungen aus gesicherten Daten wieder her
	;; und korrigiert dabei das Datum anhand der vergangenen Zeit
	;; verliert einige Sekunden (nur Minutenbasis ...)

restore_rtc:	mov	ah, #2	; aktuelle Zeit holen
		int	0x1a
		call	make_mins ; umrechnen in Minuten
		mov	word ptr mins_runtime, ax
		mov	cx, cur_time ; Startzeit holen
		call	make_mins ; ebenfalls umrechnen
		add	ax, mins_runtime ; addieren
		cmp	ax, #3600 ; Tagesueberlauf?
		jb	no_day_wrap

		sub	ax, #3600
		mov	word ptr mins_runtime, ax ; speichern
		mov	ax, cur_date+ 2 ; Monat/Tag holen
		xor	bh, bh
		mov	bl, ah
		add	bx, #month_info- 1
		cmp	byte ptr [bx], al
		je	no_month_wrap

	;; Monatsaenderung
	
		xchg	ah, al
		add	al, #1	; Monatsaenderung
		daa
		xchg	al, ah
		mov	al, #1
		mov	cur_date+ 2, ax
		mov	ax, word ptr mins_runtime
		jmp	no_day_wrap
	
	;; Tagesaenderung

no_month_wrap:	mov	ax, cur_date+ 2
		add	al, #1
		daa
		mov	cur_date+ 2, ax
		mov	ax, word ptr mins_runtime		

	;; simple Korrektur ohne Tagesueberlauf
	
no_day_wrap:	call	make_abs_time ; Wandeln in BCD		
		mov	word ptr cur_time, ax

	;; das ist ziemlich uebel, macht aber kein Problem:
	;; Sprung aus Unterprogramm ohne ret via jne ...
	
		cmp	byte ptr no_dos, #1
		jne	fix_by_dos
	
		mov	cx, cur_date
		mov	dx, cur_date+ 2
		mov	ah, #5
		int	0x1a

		mov	cx, word ptr cur_time
		xor	dx, dx
		mov	ah, #3
		int	0x1a
		ret

	;; Allgemeiner Teil, 
	
start:		push	cs
		pop	ds

		mov	dx, #hallo
		call	printstrv
	
		cmp	byte ptr no_dos, #1
		je	skip_dos_init

	;; DOS-Version braucht spezielles Init

		call	dos_init

skip_dos_init:	mov	bl, byte ptr run_count
		xor	bh, bh
		shl	bl, #1
		add	bx, #entry_tab
		jmp	word ptr [bx]

	;; Aufschlagpunkt fuer ersten Test (BIOS)
	
bios_test:

	;; Art des Systems: AT oder PS/2 fuer Zugriff auf Jahrhundert-Byte

		mov	al, #0x32 ; von AT ausgehen
	
		mov	ax, #0xf000
		mov	es, ax
		eseg
		mov	al, byte ptr 0xfffe
		cmp	al, #0xfc
		je	at_modell
		cmp	al, #0xf8
		je	ps2_modell

	;; Der Test kann nur auf AT und PS/2 funktionieren
	
		mov	dx, #unknown_pc	
		call	printstr
		jmp	error_exit	
	
	;; PS/2 bewahrt Jahrhundert woanders auf als AT
	
ps2_modell:	mov	al, #0x37
		mov	byte ptr cmos_century, al

at_modell:	
	;; Zunaechst aktuelles Datum und Zeit sichern
		
		mov	ah, #4 ; Datum
		int	0x1a
		mov	cur_date, cx
		mov	cur_date+ 2, dx

	;; Korrekturcode fuer Datum/Zeit funktionieren nur 1999, deshalb:
	
time_check:	cmp	cx, #0x1999
		jne	reset_clock

		cmp	dx, #0x3112
		jne	continue
	
reset_clock:	mov	dx, #nonsense
		call	printstrv
		jmp	error_exit

continue:
	;; Plausibilitaetspruefung Jahrhundert-Byte im CMOS
	;; ggf. wird der Jahrhundertbyte-Test abgeschaltet

		mov	byte ptr check_century, #1 ; default
		mov	al, byte ptr cmos_century
		cli
		out	0x70, al
		in	al, 0x71
		sti
		cmp	al, #0x19
		je	century_byte_ok
		mov	byte ptr check_century, #0

		mov	dx, #century_not_found
		call	printstrv

century_byte_ok:		
	
		mov	dx, #rollover_test
		call	printstrv

	 ;; Sichern der Systemzeit fuer spaetere Wiederherstellung
	
		mov	ah, #2 ; Zeit
		int	0x1a
		mov	cur_time, cx
		mov	cur_time+ 2, dx
	
change_date:

	;; Ab 1.3 geaenderte Strategie: bei via PIC ausmaskierten
	;; Timer- und RTC-Interrupts die RTC lesen (frueher via BIOS)
	;; bis einige Sekunden ins Land gegangen sind.

	;; Timer und RTC Interrupts am PIC abklemmen

		cli
		in	al, 0x21
		or	al, #1
		out	0x21, al

		in	al, 0xa1
		or	al, #1
		out	0xa1, al
	
	;; Datum vorstellen

		mov	cx, #0x1999
		mov	dh, #0x12
		mov	dl, #0x31
		call	save_set_date

	;; BIOS Tickcount geeignet anpassen (DOS tut das
	;; beim Setzen der Zeit -

		mov	cx, #0x18
		mov	dx, #0x8c
		mov	ah, #1
		int	0x1a
	
	;; Zeit auf kurz vor Mitternacht stellen
	
		cli
		mov	ch, #0x23
		mov	cl, #0x59 
		mov	dh, #0x59
		xor	dl, dl
		mov	ah, #3
		int	0x1a

	
first_wait:			
		mov	al, #10	; Update in progress
		cli
		out	0x70, al
		in	al, 0x71
		and	al, #0x80
		jnz	first_wait
	
		xor	al, al
		out	0x70, al
		in	al, 0x71

		cmp	al, #1
		jne	first_wait

	;; Testen, ob CMOS-Jahrhundertbyte korrigiert. Das
	;; ist bei Systemen der Fall, die ueber einen modernen
	;; RTC-Chip verfuegen (Dallas DS12C887), z.B. Asus P2B
	;; Aufruf setzt ggf. has_hyper_rtc

		call	check_cmos_century
	
	;; Testen, ob BIOS bei getdate korrigiert
	
check_bios:	mov	ah, #4
		int	0x1a

		sti		; erst jetzt Stoerungen erlaubt
		in	al, 0x21
		and	al, #0xfe
		out	0x21, al

		in	al, 0xa1
		and	al, #0xfe
		out	0xa1, al

		call	print_rtc

		cmp	cx, #0x2000
		je	y2k_ready ;  Jahrhundert korrigiert

		mov	dx, #bios_not_ready
		call	printstr ; Jahhundert nicht korrigiert

	;; 5 Sekunden extra, um eventueller Korrektur durch
	;; Ueberwachungsroutine via Timer- oder RTC-Interrrupt
	;; Gelegenheit zu geben.
	
		mov	dx, #cheat_tst_msg
		call	printstrv
		xor	bl, bl

cheat_wait:	mov	al, #10	; Update in Progress
		cli
		out	0x70, al
		in	al, 0x71
		sti
		and	al, #0x80
		jnz	cheat_wait
	
		xor	al, al
		cli
		out	0x70, al
		in	al, 0x71
		sti
		cmp	bl, al
		je	cheat_end_test

		dec	byte ptr [cheat_count]

		mov	dx, #cheat_tst_msg
		call	printstrv
		mov	bl, al

	;; BIOS Korrekturcode 5 Sekunden Zeit geben
	
cheat_end_test:	cmp	al, #6	; 5te Sekunde nach Testende
		jbe	cheat_wait
	
	;; run_count signalisiert Routine, welches Teststadium
	
		mov	byte ptr run_count, #8
		call	check_cmos_century
		mov	byte ptr run_count, #0

		cmp	byte ptr has_cheat_rtc, #1
		je	cheat_warning

		mov	dx, #no_cheat_code
		call	printstrv
	
		jmp	start_post

	;; Bei Verdacht auf Softwarekorrektur des Jahrhundertbyte
	;; Post-Test anschieben (Datum und Uhrzeit auf Ende 1999 
	;; wie beim ersten Anlauf). Reset nach abgelaufener Wartezeit.

cheat_warning:	mov	dx, #cheat_msg
		call	printstr

		jmp	check_forced_post

y2k_ready:	cmp	byte ptr has_hyper_rtc, #1
		je	y2k_ready_rtc

	;; Testen, ob BIOS das Jahrhundertbyte angepasst hat

		mov	byte ptr run_count, #9
		call	check_cmos_century
		mov	byte ptr run_count, #0

		cmp	byte ptr no_century_fix, #0
		je	bios_changed_century
	
	;; BIOS liefert zwar korrektes Datum, hat aber
	;; die Umstellung des Jahrhundertbyte versauemt
	
		mov	dx, #no_century_fix_msg
		call	printstr
		jmp	do_forced_post

bios_changed_century:	

	;; RTC hat Umstellung nicht besorgt, sondern BIOS
	;; inklusive Umstellung das Jahrundertbyte
	;; letzters wird erst anschliessend angezeigt

		mov	dx, #bios_ready
		call	printstr
		mov	dx, #rtc_ready
		call	printstrv
		jmp	check_forced_post

y2k_ready_rtc:	
	;; RTC kann Umstellung alleine
	
		mov	dx, #hyper_finish
		call	printstr
		jmp	check_forced_post
	
check_forced_post:	
		cmp	byte ptr force_post, #1
		jne	restore
	
do_forced_post:	mov	dx, #forced_post
		call	printstr
	
	;; POST-Test einleiten
	
start_post:	

	;; Alle PCs, deren BIOS-Datumsfunktionen das Jahrhundert nicht
	;; selbstaendig korrigieren, muessen daraufhin geprueft werden, ob
	;; beim Einschalten der Selbsttestcode diese Korrektur vornimmt.

		inc	byte ptr run_count
		call	write_data
		jc	file_error

normal_post:	mov	word ptr reset_msg, #start_reset1
		jmp	do_reset

	;; Aufschlagpunkt nach restart fuer zweiten Test (POST)
	
post_test:
	;; CMOS-Jahrhundertbyte abfragen
		call	check_cmos_century
	
	;; BIOS auslesen

		mov	ah, #4
		int	0x1a
		call	print_rtc
	
	;; RTC steht auf 00, Jahrhundertbyte unveraendert (19)
	
		cmp	cx, #0x1900 
		je	y2k_post_bad

	;; Ist Jahrhundertbyte im POST wirklich angepasst worden?

		cmp	byte ptr no_century_fix, #1
		jne	check_bios_century

		mov	dx, #bad_century_post_msg
		call	printstr

		jmp	fix_entry
	
check_bios_century:

	;; Jahrhundertbyte dank POST angepasst, was sagt BIOS
	
		cmp	cx, #0x2000
		je	y2k_post_ok

	;; Steht Datum evtl. wieder auf Startdatum (Netware-Client)?

		cmp	cx, word ptr [cur_date]
		jne	y2k_post_bad
		cmp	dx, word ptr [cur_date+ 2]
		jne	y2k_post_bad

		mov	dx, #time_thief
		call	printstr
		jmp	restore_reset

	;; Weder 1900 noch 2000, zweiter Reset-Test liefert Aufschluss,
	;; ob sich ein PC dauerhaft umstellen laesst.
	
y2k_post_bad:	mov	dx, #post_not_ready
		call	printstr

fix_entry:	mov	dx, #start_fix_msg
		call	printstrv
		jmp	start_fix
		
	;; Hat geklappt, damit ist es erledigt
	
y2k_post_ok:	mov	dx, #post_ready
		call	printstr
		jmp	restore_reset

start_fix:
		inc	byte ptr run_count
		call	write_data
		jc	file_error

		mov	cx, #0x2000 ; spezielles Datum manuell einstellen
		mov	dx, #0x0325 ; fuer zweiten Boot-Test
		call	save_set_date
	
		mov	word ptr reset_msg, #start_reset2
		mov	al, #0x39
		mov	byte ptr count_down, al
		jmp	do_reset

	;; Aufschlagpunkt fuer dritten Test (Fix)
	
fix_test:
	;; Erst im CMOS nachschauen
		call	check_cmos_century 

	;; Jetzt BIOS fragen
	
		mov	ah, #4
		int	0x1a
		call	print_rtc
		cmp	cx, #0x1900
		je	y2k_fix_bad
		cmp	cx, #0x2000
		jne	y2k_fix_bad
		cmp	dx, #0x0325
		jne	y2k_fix_bad

		mov	dx, #fix_ready
		call	printstr
		jmp	restore_reset

y2k_fix_bad:	mov	dx, #fix_not_ready
		call	printstr
		jmp	restore_reset

	;; Eigtl. Reset-Mimik mit Animation
	
do_reset:	xor	bl, bl

	;; Ein bisschen was fuers Auge, 9/2 Sekunden delay vor Reset

reset_delay:	mov	ah, #2
		int	0x1a
		cmp	bl, dh
		mov	bl, dh
		je	reset_delay
		
		mov	dx, #start_reset1
		call	printstrv
		dec	byte ptr count_down
		cmp	byte ptr count_down, #0x30
		jne	reset_delay

strobe_reset:
	;; geordnete Zustaende vor Reset
	
		xor	ax, ax
		mov	es, ax
		eseg
		mov	word ptr 0x72, #0 ; BIOS-Flag
		mov	al, #0xf ; Shutdown-Byte
		cli
		out	0x70, al
		mov	al, #0
		out	0x71, al
		sti

	;; Reset-Impuls via Tastatur-Controller ausgeben
	
		mov	al, #0xfe
		out	#0x64, al

		jmp	$

	;; Programm/Daten/RTC in Ausgangszustand versetzen
	
restore_reset:			; call	reset_data
restore:	
	;; Datum&Uhrzeit auf Ausgangszeit + Delta 
	
		call	restore_rtc
	
plainexit:	mov	dx, #final_msg
		call	printstrv
	
error_exit:	call	reset_data
		cmp	byte ptr no_dos, #1
		jne	dos_exit

		mov	dx, #finished
		call	printstrv
		xor	ah, ah
		int	0x16
		call	reset_delay
		jmp	strobe_reset
		
file_error:	call	print_bcd
		mov	dx, #fileio_error
		call	printstr
		call	restore_rtc
		jmp	error_exit

bios_error:	mov	dx, #bios_call_fail
		call	printstr
		jmp	error_exit
						
stern:		.ascii	"*$"
space:		.ascii	" $"
hallo:		.ascii	"cty2ktst 1.3, (C) c't/ps"
		.byte	13,10
		.ascii	"Programm zum Testen der Jahr-2000-Vertraeglichkeit der PC-Hardware"
		.byte	13,10
crlf:		.byte	13,10
		.ascii	"$"
unknown_pc:	.ascii	"Das Programm laeuft nur auf ATs und PS/2"
 		.byte	13,10
		.ascii	"$"
finished:	.ascii	"Diskette entnehmen. Tests sind abgeschlossen."
		.byte	13,10
		.ascii	"Auf Tastendruck erfolgt Reboot$"
century_not_found:	
		.ascii	"CMOS-Jahrhundertbyte nicht an ueblicher Stelle; Test wird uebersprungen"
		.byte	13,10
		.ascii	"$"
nonsense:	.ascii	"Programm laeuft nur vom 1.1.99 bis 30.12.1999. Stellen sie ggf. das Datum um"
		.byte	13,10
		.ascii	"$"
rollover_test:	.ascii	"Test, wie RTC/BIOS den Uebergang von 1999 auf 2000 meistern"
		.byte 13,10
		.ascii "$"
stage2_test:	.ascii	"Pruefe, ob Zweitlauf nach Reset/Abschalten"
		.byte	13
		.ascii	"$"
forced_post:	.ascii	"Erzwungener Test des BIOS-Verhaltens beim Selbsttest (POST)"
		.byte	13,10
		.ascii	"$"	
hyper_rtc:	.ascii	"RTC super-modern: CMOS-Jahrhundertbyte ohne BIOS-Aufruf korrigiert"
		.byte	13,10
		.ascii	"$"
hyper_finish:	.ascii	"Dank RTC ist dieses System ohne Softwarehilfe Jahr-2000-fest"
		.byte	13,10
		.ascii	"$"
cheat_rtc:	.ascii	"CMOS-Jahrhundertbyte erst nachtraeglich vom BIOS manipuliert (=20)"
		.byte	7,13,10
		.ascii	"$"
cheat_tst_msg:	.ascii	"Pruefe auf Softwarekorrektur des Jahrhundertbyte, noch "
cheat_count:	.ascii	"6"
		.ascii	" Sekunden"
		.byte	13
		.ascii	"$"
no_cheat_code:	.ascii	"Keine Softwarekorrektur festgestellt, die Jahrhundertbyte aendert"
		.byte	13,10
		.ascii	"$"
cheat_msg:	.ascii	"BIOS korrigiert Jahrhundert verpaetet. System ist bedingt Jahr-2000-fest"
		.byte	13,10
		.ascii	"$"
no_century_fix_msg:	.ascii "BIOS-Datum ist richtig, aber korrigiert Jahrhundertbyte nicht"
		.byte	13,10
		.ascii	"$" 
bad_century_post_msg:	.ascii "BIOS-Datum ist richtig. POST korrigiert Jahrundertbyte aber nicht"
		.byte	13,10
		.ascii	"$"
rtc_ready:	.ascii	"RTC-klassisch, CMOS-Jahrhundertbyte vom BIOS korrigiert (=20)"
		.byte	13,10
		.ascii	"$"
rtc_not_ready:	.ascii	"RTC-klassisch, CMOS-Jahrhundertbyte nicht korrigiert (=19)        "
		.byte	13,10
		.ascii	"$"
bios_ready:	.ascii	"BIOS korrigiert Jahrhundert - System ist Jahr-2000-fest"
		.byte	13,10
		.ascii	"$"
bios_not_ready:	.ascii	"BIOS korrigiert Jahrhundert nicht im ersten Durchlauf"
		.byte	13,10
		.ascii	"$"
bios_error_msg:	.ascii	"BIOS akzeptiert keine Datumsaenderung auf das Jahr 2000."
		.byte	13,10
		.ascii	"Eine manuelle Umstellung ist eventuell nicht moeglich"
		.byte	7,13,10
		.ascii	"$"
time_thief:	.ascii	"Irgendwer pfuscht in den Test: Jetziges Datum = Startdatum"
		.byte	13,10
		.ascii	"Weitere Versuche sinnlos, Test wird abgebrochen."
		.byte	13,10
		.ascii	"$"
post_ready:	.ascii	"BIOS korrigiert Jahrhundert im POST - System ist Jahr-2000-fest"
		.byte	13,10
		.ascii	"$"
post_not_ready:	.ascii	"BIOS korrigiert Jahrhundert auch nicht im POST"
		.byte	13,10
		.ascii	"$"
start_fix_msg:	.ascii	"Pruefe, ob BIOS das Jahr 2000 haelt (Award-Test)"
		.byte	13,10
		.ascii	"$"
fix_ready:	.ascii	"BIOS erlaubt und behaelt einmalige manuelle Korrektur"
		.byte	13,10
		.ascii	"$"
fix_not_ready:	.ascii	"BIOS erlaubt keine manuelle Korrektur (Award-Bug)!"
		.byte	7,13,10
		.ascii	"$"
start_reset2:	.ascii	"Erneuter "
start_reset1:	.ascii	"Reset-/Abschalt-Test erforderlich ... noch "
count_down:	.ascii	"9 Sekunden"
		.byte	13
		.ascii	"$"
fileio_error:	.ascii	" Fehler beim Schreiben der Laufzeitdaten/Testdatei ... "
		.byte	7,13,10
		.ascii	"$"
bios_call_fail:	.ascii	"Fehler beim Setzen des Datums via BIOS ... "
		.byte	7,13,10
		.ascii	"Bitte ueberpruefen Sie Datum und Uhrzeit"
		.byte	13,10
		.ascii	"$"

standalone_ends:	

	;; Diese Meldungen sind nur fuer die Version, die unter DOS laeuft.
	;; Die Standaloneversion kann darauf verzichten
	
help_screen:	.ascii	"cty2ktst fuehlt der PC-Hardware auf den Zahn, ob sie den Uebergang ins Jahr"
 		.byte	13,10
		.ascii	"2000 allein oder nur mit Hilfe meistern kann. Das Programm laeuft unter jeder"
 		.byte	13,10
		.ascii	"gaengigen DOS-Version, nicht jedoch in der DOS-Box von Windows & Co."
 		.byte	13,10
		.byte	13,10
		.ascii	"Das Programm kennt folgende Optionen:"
 		.byte	13,10
		.ascii	" /i erzeugt direkt bootbare Test-Diskette (muss formatiert sein)"
 		.byte	13,10
		.ascii	" /s zeigt das aktuelle Datum laut RTC/BIOS an (fuer manuelle Tests)"
 		.byte	13,10
		.ascii	" /e ignoriert EMM386 und andere Speichermanager, falls installiert"
 		.byte	13,10
		.ascii	" /p erzwingt den Test des POST-BIOS-Code (erfordert Reset)"
 		.byte	13,10
		.ascii	" /v zeigt waehrend des Testens das RTC/BIOS-Datum (Plausibilitaet)"
 		.byte	13,10
		.byte	13,10
		.ascii	"(die Optionen /pv wirken auch auf eine via /i erzeugte Diskette;"
 		.byte	13,10
		.ascii	" sie brauchen nur beim Erstaufruf unter DOS angegeben werden)"
		.byte	13,10
		.ascii	"$"
dau_catch:	.ascii	"Der Einsatz mit Speichermanagern oder DOS-Emulationen macht keinen Sinn."
		.byte	13,10
		.ascii	"$"
windows_nono:	.ascii	"Der Einsatz unter Windows ergibt keinen Sinn"
		.byte	13,10
		.ascii	"$"
dos_to_old:	.ascii	"Programm laeuft nur mit DOS neuer oder gleich 3.3"
		.byte 13,10
		.ascii "$"
warning1:	.ascii	"Formatierte Diskette in Laufwerk A: einlegen und Taste druecken"
		.byte 13,10
		.ascii "$"
warning2:	.ascii	"Alle Daten darauf gehen verloren. Wirklich weitermachen (jJ)?$"
warning3:	.ascii	"Diskette bitte entnehmen, dann Taste druecken.$"
floppy_made:	.byte	13,10
		.ascii	"Boot-Version des Programms erstellt."
		.byte	13,10
		.ascii "$"
floppy_failure:	.byte	13,10
		.ascii	"Fehler beim Erstellen der Boot-Version."
		.byte 13,10
		.ascii "$"
writing_flop:	.byte 13,10
		.ascii	"Boot-Version wird auf Diskette ueberspielt ..."
		.ascii "$"
beep:		.byte 7
		.ascii "$"
dos_warning:	.ascii	"Das verwendete DOS verfaelscht u.U. die Testergebnisse."
		.byte 13,10
		.ascii "$"
print_date:	.ascii	"Das aktuelle Datum laut BIOS ist: $"
cty2ktstfile:	.ascii	"cty2ktst.dta"
		.byte	0

	;; DOS-basierte/relevante Unterprogramme

getkey:		xor	ah, ah
		int	0x16
		ret
	
	;; Abschliessende Zeitreparatur via DOS, sonst sind RTC
	;; und DOS Datums-/Zeitwerte inkonsistent
	
fix_by_dos:	mov	ax, cur_date
		call	bcd_to_binw
		mov	cx, ax
		mov	ax, cur_date+ 2
		call	bcd_to_bin
		xchg	al, ah
		call	bcd_to_bin
		xchg	al, ah
		mov	dx, ax
		mov	ah, #0x2b
		int	0x21

		mov	ax, cur_time
		call	bcd_to_bin
		xchg	ah, al
		call	bcd_to_bin
		xchg	ah, al
		mov	cx, ax
		xor	dx, dx
		mov	ah, #0x2d
		int	0x21

		jmp	plainexit

	;; Wandelt BCD-AX in binaer (wird nur von DOS-Exit benoetigt)
	
bcd_to_binw:	push	bx
		push	cx
		push	dx
	
		mov	cx, ax
		xor	bx, bx
		mov	ax, #1
	
bcd_to_binwl:	push	cx
		and	cx, #0xf
		
		push	ax
		mul	cx
		add	bx ,ax
		pop	ax
		mov	cx, #0xa
		mul	cx
		
		pop	cx
		shr	cx, #4
		or	cx, cx
		jnz	bcd_to_binwl

		mov	ax, bx
		pop	dx
		pop	cx
		pop	bx
		ret

	;; DOS basierte Ausgabefunktion (aufruf via call print_str)
	
dos_print:	mov	ah, #9
		int	0x21
		pop	ax
		ret
		
	;; Ordentlich den Rueckzug antreten (direkt angesprungen)
	
dos_exit:	mov	ax, #0x4c00
		int	0x21

	;; Prueft wesentliche Startparameter unter DOS
	
dos_init:	
	;; DOS-Version feststellen, ggf. warnen 

check_dos:	mov	ax, #0x3001
		int	0x21
		cmp	al, #3
		jb	old_dos
		ja	new_dos_chk
		cmp	ah, #3
		jb	old_dos

new_dos_chk:	cmp	al, #7
		jne	dos_check_done
		cmp	ah, #0xa
		jne	dos_check_done
	
		cmp	byte ptr [run_count], #0 ; Meldung nur einmal
		jne	dos_check_done
		mov	dx, #dos_warning
		call	printstr
		jmp	dos_check_done

old_dos:	mov	dx, #dos_to_old
		call	printstrv
		jmp	dos_exit			
	
dos_check_done:	
	
	;; rudimentaere Auswertung von Optionen
	
get_paras:	mov	si, #0x81
	
check_paras:	lodsb
		cmp	al, #0x40
		jb	para_lc
		or	al, #0x20
para_lc:	cmp	al, #0xd
		je	check_image
		cmp	al, #0x3f ; ? - Hilfe
		je	give_help
		cmp	al, #0x69 ; i - Disketten-Image erstellen
		je	make_image
		cmp	al, #0x65 ; e - emm386/DOS-Box-Test ueberspringen
		je	set_skip_v86
		cmp	al, #0x76 ; v - Geschwaetzigkeit erhoehen
		je	set_verbose
		cmp	al, #0x70 ; p - POST-Test erzwingen
		je	set_force_post
		cmp	al, #0x73 ; s - BIOS-Datum anzeigen
		je	show_bios_date
		cmp	al, #0x2d ; - ueberlesen
		je	check_paras
		cmp	al, #0x2f
		je	check_paras
		cmp	al, #0x20 ; / ueberlesen
		je	check_paras

	;; alle anderen: Hilfstext

give_help:	mov	dx, #help_screen
		call	printstrv
		jmp	dos_exit

set_force_post:	mov	byte ptr force_post, #1
		jmp	check_paras

set_skip_v86:	mov	byte ptr skip_v86, #1
		jmp	check_paras

set_verbose:	mov	byte ptr verbose_mode, #1
		jmp	check_paras
	
make_image:	mov	byte ptr image_mode, #1
		jmp	check_paras

show_bios_date:	mov	dx, #print_date
		call	printstrv
		mov	ah, #4
		int	0x1a
		mov	byte ptr verbose_mode, #1
		call	print_rtc
		mov	byte ptr verbose_mode, #0
		mov	dx, #crlf
		call	printstrv
		call	dos_exit

	;; Wenn alle Parameter gelesen sind, dann erst pruefen, ob
	;; vielleicht eine Boot-Floppy zu erstellen ist. Falls ja,
	;; erfolgt kein Test. Die Floppy erbt die gesetzten Optionen.
	
check_image:	cmp	byte ptr image_mode, #1
		je	make_bootdisk

	;; Teatdaten eines letzten Laufes einlesen
	;; darf erst hier passieren, sonst erbt Image Parameter

		mov	dx, #stage2_test
		call	printstrv
		call	read_file
	
	;; Windows-Check laut Microsoft

		mov	ax, #0x1600
		int	0x2f
		test	al, #0x7f
		jz	no_windows

		mov	dx, #windows_nono
		call	printstrv
		jmp	dos_exit
	
no_windows:		

	;; sicherstellen, dass niemand das Programm in der DOS-Box
	;; oder unter EMM und Co benutzt (funktioniert zumindest mit
	;; einigen EMM-Versionen, deshalb ueberschreibbar via Parameter

		cmp	byte ptr skip_v86, #1
		je	v86_check_ok
		smsw	ax
		test	ax, #1
		jz	v86_check_ok

		mov	dx, #dau_catch
		call	printstrv
		jmp	dos_exit

v86_check_ok:	
		ret		; zurueck in eigtl. Startcode

	;; Eigenstaendig (ohne Betriebssystem) lauffaehige Bootdisk
	;; erstellen (Laufwerk A: hartkodert; Typ egal)
	
make_bootdisk:	
	;; Variable vorbesetzen, damit der Code weiss, was er zu tun hat

		mov	byte ptr no_dos, #1
		call	reset_buffer

	;; Die vorformatierte Diskette wird mit int26 beschrieben.
	;; Das funktioniert unter diversen Betriebssystemen 

		mov	dx, #warning1
		call	printstrv
		call	getkey

		mov	dx, #warning2
		call	printstrv
		call	getkey
	
		cmp	al, #0x6a ; j
		je	write_floppy
		cmp	al, #0x4a ; J
		je	write_floppy

		mov	dx, #beep
		call	printstrv
		mov	dx, #crlf
		call	printstrv
		mov	byte ptr no_dos, #0
		jmp	error_exit

write_floppy:	mov	dx, #writing_flop
		call	printstrv
	
		mov	bx, #bootstrap
		mov	cx, #1
		xor	dx, dx
		xor	al, al
		int	0x26
		jc	floppy_fail
		popf
	
		mov	bx, #entrypoint
		mov	cx, #code_sectors
		mov	dx, #1
		xor	al, al
		int	0x26
		jc	floppy_fail
		popf

		mov	dx, #floppy_made
		call	printstrv
		jmp	floppy_done

floppy_fail:	popf
		mov	dx, #floppy_failure
		call	printstrv
	
	;; Variable ruecksetzen fuer normalen Ausstieg ohne reset
floppy_done:	mov	byte ptr no_dos, #0
		mov	dx, #warning3
		call	printstrv
		call	getkey
		mov	dx, #crlf
		call	printstrv
		jmp	dos_exit

	;; schreibt aktuelles Datum und aktuelle Zeit in Datei
	
write_file:
	;; fuer gepipete Ausgabe flush von stdout via dup-handle

		mov	bx, #1
		mov	ah, #0x45
		int	0x21
		jc	dup_stdout_fail
		mov	bx, ax
		mov	ah, #0x3e
		int	0x21

dup_stdout_fail:
	
		mov	dx, #cty2ktstfile ; Datei zum Merken des Datums
		xor	cx, cx
		mov	ah, #0x3c
		int	0x21
		jc	write_ret

		push	ax	; Handle sichern
		pop	bx
		push	bx	; und gesichert lassen
	
		mov	cx, #data_length	; Block in Datei schreiben
		mov	dx, #cur_time
		mov	ah, #0x40
		int	0x21
		pop	bx
		jc	write_ret
		
		mov	ah, #0x3e ; Datei schliessen
		int	0x21

write_ret:	ret

	;; liest aktuelles Datum und aktuelle Zeit aus Datei
	
read_file:	mov	dx, #cty2ktstfile
		xor	al, al
		mov	ah, #0x3d
		int	0x21
		jc	read_ret ; Datei existiert nicht oder Fehler

		push	ax	; Aktuelles Datum und Zeit einlesen
		mov	bx, ax
		mov	ah, #0x3f
		mov	cx, #data_length
		mov	dx, #cur_time
		int	0x21
		pop	bx	; Handle restaurieren
		jc	read_ret

		mov	ah, #0x3e ; Datei schliessen
		int	0x21

read_ret:	ret
				
delete_file:	mov	dx, #cty2ktstfile ; Datei loeschen
		mov	ah, #0x41
		int	0x21
		ret

	;; Boot-Sektor-Code. Wird von der image-Option als Boot-Sektor
	;; auf eine Diskette geschrieben. Der Code liest die folgenden
	;; Sektoren in den Speicher und fuehrt sie gnadenlos aus.

	;; Wichtig: Dieser Code darf keine absolute Adressierung nutzen,
	;; weil er nicht an der hier vom Assembler verwendeten Adresse
	;; laeuft.

		.ascii	"BOOT"
	
boot_entry:	jmp	bootstrap

bootstrap:	cli
		mov	ax, #0x9000
		mov	ss, ax
		mov	sp, #0x100
		mov	es, ax
		sti
		xor	ax, ax
		xor	dl, dl
		int	0x13
		jc	boot_error

	;; Die naechten n Sektoren lesen. Sie enthalten das
	;; eigentliche Testprogramm.

		mov	ax, #5
re_read:	push	ax
		mov	ah, #02
		mov	al, #code_sectors
		mov	bx, #0x100
		mov	cx, #0x0002
		xor	dx, dx
		int	0x13
		pop	ax
		jnc	code_loaded
		dec	ax
		jnz	re_read
	
	;; "Fehlerbehandlung"
	
boot_error:	hlt

code_loaded:	mov	bx, #0x100
		int	3
		jmp	0x9000:0x100

	