{              (c) 2000 by Alexander Knauer           }
{                        Germany                      }
{                contact: defragfree@gmx.net          }
{           This program may be used freely in        }
{           non-commercial environments only!!        }
{                                                     }
{             V1.0 last changes: 17/02/2000           } 

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs, StdCtrls,
  Registry, FileCtrl, ExtCtrls;

type
  TMainFrm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    CleanBtn: TButton;
    ExitBtn: TButton;
    AboutBtn: TButton;
    RestoreBtn: TButton;
    BackupCheck: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure CleanBtnClick(Sender: TObject);
    procedure RestoreBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure CompShutdown;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  MainFrm: TMainFrm;

implementation

uses About;

{$R *.DFM}

const sysfiles : array[0..4] of string = ('dfrgfat.exe','dfrgntfs.exe','dfrgres.dll','dfrgsnap.dll','dfrgui.dll');

var sysdir : array[0..MAX_PATH] of char;
    sysdirstr : string;
    i : byte;
    reg : TRegistry;
    cpsrc,cpdest : array[0..MAX_PATH] of char;

procedure TMainFrm.CompShutdown;
var prochandle : longint;
    tokenhandle : THandle;
    tmpLuid : TLargeInteger;
    tkp,tkpnew : TTokenPrivileges;
    luidattrib : TLuidAndAttributes;
    lBuffer : dword;
begin
  Label5.Caption := 'system-shutdown...';
  prochandle := GetCurrentProcess();
  OpenProcessToken(prochandle,(TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY),tokenhandle);
  LookupPrivilegeValue('','SeShutDownPrivilege',tmpLuid);
  luidattrib.Luid := tmpLuid;
  luidattrib.Attributes := SE_PRIVILEGE_ENABLED;
  tkp.PrivilegeCount := 1;
  tkp.Privileges[0] := luidattrib;
  AdjustTokenPrivileges(tokenhandle,False,tkp,SizeOf(tkpNew),tkpNew,lBuffer);
  ExitWindowsEx(EWX_SHUTDOWN+EWX_REBOOT+EWX_FORCE,$FFFF)
end;

procedure TMainFrm.FormCreate(Sender: TObject);
begin
  GetSystemDirectory(sysdir,MAX_PATH+1);
  sysdirstr := sysdir;
  sysdirstr := sysdirstr+'\'
end;

procedure TMainFrm.ExitBtnClick(Sender: TObject);
begin
  Application.Terminate
end;

procedure TMainFrm.AboutBtnClick(Sender: TObject);
begin
  AboutFrm.ShowModal
end;

procedure TMainFrm.CleanBtnClick(Sender: TObject);
begin
  if MessageDlg('Your system will be shutdown'+#13+'immediately after uninstall! Proceed?',mtWarning,[mbYes,mbNo],0) = mrYes then begin

    if BackupCheck.Checked then begin
      Label1.Caption := 'backup files...';
{$I-}
      MkDir(sysdirstr+'DfrgUninst.sav');
{$I+}
      for i := 0 to 4 do begin
        StrPCopy(cpsrc,sysdirstr+sysfiles[i]);
        StrPCopy(cpdest,sysdirstr+'DfrgUninst.sav\'+sysfiles[i]);
        CopyFile(cpsrc,cpdest,False)
      end
    end;

    if BackupCheck.Checked then begin
      StrPCopy(cpsrc,sysdirstr+'compmgmt.msc');
      StrPCopy(cpdest,sysdirstr+'DfrgUninst.sav\compmgmt.ori');
      CopyFile(cpsrc,cpdest,True)
    end;

    Label2.Caption := 'replacing computer-management snapin...';
    StrPCopy(cpsrc,ExtractFilePath(Application.ExeName)+'compmgmt.msc');
    StrPCopy(cpdest,sysdirstr+'compmgmt.msc');
    CopyFile(cpsrc,cpdest,False);

    Label3.Caption := 'changing registry...';
    reg := TRegistry.Create;
    if reg <> nil then begin
      reg.Rootkey := HKEY_LOCAL_MACHINE;
      reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\MyComputer',False);
      if (BackupCheck.Checked) and (reg.KeyExists('DefragPathSave')=False) then reg.MoveKey('DefragPath','DefragPathSave',False);
      reg.DeleteKey('DefragPath');
      reg.CreateKey('DefragPath')
    end;
    reg.Free;

    Label4.Caption := 'deleting defrag-files...';
    for i := 0 to 4 do DeleteFile(sysdirstr+'dllcache\'+sysfiles[i]);
    for i := 0 to 4 do DeleteFile(sysdirstr+sysfiles[i]);

    CompShutdown
  end
end;

procedure TMainFrm.RestoreBtnClick(Sender: TObject);
begin
  if DirectoryExists(sysdirstr+'DfrgUninst.sav') then begin

    reg := TRegistry.Create;
    if reg <> nil then begin
      reg.Rootkey := HKEY_LOCAL_MACHINE;
      reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\MyComputer',False);
      reg.DeleteKey('DefragPath');
      reg.MoveKey('DefragPathSave','DefragPath',False);
      Label1.Caption := 'registry restored...'
    end;
    reg.Free;

    for i := 0 to 4 do begin
      StrPCopy(cpsrc,sysdirstr+'DfrgUninst.sav\'+sysfiles[i]);
      StrPCopy(cpdest,sysdirstr+sysfiles[i]);
      CopyFile(cpsrc,cpdest,False)
    end;
    Label2.Caption := 'defrag-files restored...';

    StrPCopy(cpsrc,sysdirstr+'DfrgUninst.sav\compmgmt.ori');
    StrPCopy(cpdest,sysdirstr+'compmgmt.msc');
    CopyFile(cpsrc,cpdest,False);
    Label3.Caption := 'computer-management snapin restored...';

    Label4.Caption := '';
    Label5.Caption := ''
  end else MessageDlg('No Backup found!',mtInformation,[mbOk],0)
end;

end.
