/********************************/
/* CT-API Grundgerst           */
/* Kai-Uwe Mrkor, 2000          */
/* fr c't 08/00                */
/********************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ctapi.h"

int main( void)
{
 unsigned char      sad, dad;       /* Quell- und Zieladresse */
 unsigned char      command[30];    /* Kommando-String */
 unsigned char      response[100];  /* Antwort-Speicher */
 unsigned short int cnr,            /* KartenTerminal-Nummer */
                    lenr,           /* Grenangabe Antwortpuffer */
                    lenc;           /* Grenangabe Kommando */
 char               ret;            /* Rckgabewert der Funktion */

 unsigned short int sw1sw2;         /* Hilfsvariable */

 /*                            CLA   INS   P1    P2    LEN */
 unsigned char REQUEST_ICC[]= {0x20, 0x12, 0x01, 0x00, 0};

 /* Initialisierung */
 cnr=0;                 /* TerminalNummer=0 */
 ret=CT_init(cnr,1);    /* Verbindung mit COM1 herstellen */
 if (ret != OK)
 {
     printf("Kartenterminal konnte nicht initialisiert werden\n");
     exit(1);
 }

 /* Anforderung der Chipkarte */
 sad=2;                     /* Quelle = Host */
 dad=1;                     /* Ziel = Kartenterminal */
 lenc=sizeof(REQUEST_ICC);  /* Gre des Kommandopuffers ermitteln */
 lenr=sizeof(response);     /* Gre des Antwortpuffers ermitteln  */
 memcpy(command, REQUEST_ICC, lenc);
 ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);
 if (ret != OK)
 {
     printf("CT_data() fehlgeschlagen!\n");
     exit(1);
 }

 sw1sw2=(response[0]<<8) + response[1];

 printf("Trailer der Antwort-APDU: %4xh\n",sw1sw2);
 printf("Groesse der Antwort-APDU: %d\n", lenr);
 printf("sad: %xh\ndad: %xh\n\n",sad,dad);

 switch(sw1sw2)
 {
    case 0x9000:    printf("Speicherkarte erkannt!\n");
                    break;
    case 0x9001:    printf("Prozessorkarte erkannt!\n");
                    break;
    case 0x6200:    printf("Keine Karte im Terminal!\n");
                    break;
    case 0x6201:    printf("Karte schon in Benutzung!\n");
                    break;
    case 0x6400:    printf("Reset ohne Erfolg!\n");
                    break;
    case 0x6401:    printf("Prozess abgebrochen!\n");
                    break;
    case 0x6900:    printf("Timer-Kommando nicht unterstuetzt!\n");
                    break;

    default:        printf("Unbekannter Fehler!\n");
 }


 /* Freigabe */
 ret=CT_close(cnr);

 return 0;
}
