/********************************/
/* Kais KartenAdmin             */
/* Kai-Uwe Mrkor, 2000          */
/* fr c't 09/00                */
/********************************/

#include <windows.h>
#include "resource_adm.h"
#include "ctapi.h"

#define TERMINAL_NR       0 /* Kartenterminal 0 */
#define COM               1 /* COM1 */
#define MAXSIZE         128 /* Datensatzgre */

/* Tags */
#define VORNAME         0x80
#define NACHNAME        0x81
#define MITGLIEDS_NR    0x82
#define MITGLIEDS_ART   0x83
#define GUELTIGKEIT     0x84

/* APDUs */
unsigned char           /*   CLA   INS   P1    P2    Le */
    RESET_TERMINAL[] =      {0x20, 0x11, 0x00, 0x00, 0},
    ANFORDERUNG_KARTE[] =   {0x20, 0x12, 0x01, 0x00, 0},
    DEAKTIVIERE_KARTE[] =   {0x20, 0x15, 0x01, 0x03},
    READ_BINARY[] =         {0x00, 0xB0, 0x00, 0x00, MAXSIZE},
    WRITE_BINARY[] =        {0x00, 0xD0, 0x00, 0x00, MAXSIZE};

unsigned char speicher[MAXSIZE+2];  /* 2 Byte fr SW1/SW2 */

/************************************************/
/* sucht einen Tag im abgelegten Speicherabbild */
/************************************************/

void suche_tag(unsigned char tag, char *string)
{
 int i;

 for (i=4; i<MAXSIZE-1; )
 {
  if (speicher[i] != tag)
    i += speicher[i+1] + 2;     /* i := i + Laenge + 2 fr T&L */
  else
  {
    memcpy(string,&speicher[i+2],speicher[i+1]);
    string[speicher[i+1]] = 0;  /* Nullterminierung */
    break;
  }
 }
}

/************************************************/
/* erzeugt eine XOR-Prsumme ber speicher[]    */
/************************************************/

unsigned char pruefsumme(void)
{
    unsigned char   i, pruef;

    for (i=0, pruef=0; i<MAXSIZE-1; i++)
        pruef ^= speicher[i];

    return pruef;
}

/************************************************/
/* liest die Klubkarte                          */
/************************************************/

void lese_clubkarte(HWND hDlg)
{
 unsigned char      sad, dad;       /* Quell- und Zieladresse */
 unsigned char      kommando[30];   /* Kommandofeld */
 unsigned char      antwort[30];    /* Antwortfeld */
 unsigned short int lenr;           /* Lngenangabe */
 unsigned char      ret;            /* Rckgabewert */
 char               text[100];      /* Puffer */

 /* Terminal-Initialisierung */
 ret = CT_init(TERMINAL_NR,COM);    /* Verbindung herstellen */
 if (ret != OK)
 {
    MessageBox(hDlg,"Kartenterminal-Initialisierg. fehlgeschlagen!",
               "kritischer Fehler",MB_ICONEXCLAMATION);
    return;
 }

 /* Rcksetzen des Terminals */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 300;    /* Puffergre */
 memcpy(kommando, RESET_TERMINAL, sizeof(RESET_TERMINAL));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(RESET_TERMINAL),
               kommando, &lenr, antwort);

 /* Anforderung der Chipkarte */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 300;    /* Puffergre */
 memcpy(kommando, ANFORDERUNG_KARTE, sizeof(ANFORDERUNG_KARTE));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(ANFORDERUNG_KARTE), 
               kommando, &lenr, antwort);

 /* Speicherkarte erkannt? */
 if (!(antwort[0] == 0x90 && antwort[1] == 0x00)  &&
     !(antwort[0] == 0x62 && antwort[1] == 0x01))
     MessageBox(hDlg,"Es wurde keine Speicherkarte gefunden!",
                "kritischer Fehler",MB_ICONEXCLAMATION);
 else
 {
    sad  = 0;           /* Quelle = Chipkarte */
    dad  = 2;           /* Ziel = Host */
    lenr = MAXSIZE + 2;
    memcpy(kommando, READ_BINARY, sizeof(READ_BINARY));
    ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(READ_BINARY), 
                  kommando, &lenr, speicher);

    /* Karten-ID korrekt? */
    ret = memcmp("3004",speicher,4);
    if (ret != 0)
        MessageBox(hDlg,"Es wurde keine Mitgliedskarte gefunden!",
                   "kritischer Fehler",MB_ICONEXCLAMATION);
    else
    {   /* Prsumme korrekt? */
        if (speicher[MAXSIZE-1] != pruefsumme())
            MessageBox(hDlg,"Prfsumme fehlerhaft!",
                   "kritischer Fehler",MB_ICONEXCLAMATION);

        suche_tag(VORNAME, text);
        SetDlgItemText(hDlg, IDC_Vorname,text);
        suche_tag(NACHNAME, text);
        SetDlgItemText(hDlg, IDC_Nachname,text);
        suche_tag(MITGLIEDS_NR, text);
        SetDlgItemText(hDlg, IDC_Mitgliedsnummer,text);
        suche_tag(MITGLIEDS_ART, text);
        switch(text[0])
        {
          case 'K': CheckRadioButton(hDlg, IDC_RADIO_Voll, 
                    IDC_RADIO_Sauna, IDC_RADIO_Voll);
                    break;
          case 'V': CheckRadioButton(hDlg, IDC_RADIO_Voll, 
                    IDC_RADIO_Sauna, IDC_RADIO_Vormittags);
                    break;
          default:  CheckRadioButton(hDlg, IDC_RADIO_Voll, 
                    IDC_RADIO_Sauna, IDC_RADIO_Sauna);
                    break;
        }
        suche_tag(GUELTIGKEIT, text);
        SetDlgItemText(hDlg, IDC_Gueltigkeit,text);
    }

 }
 /* Freigabe der Chipkarte */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 300;    /* Puffergre */
 memcpy(kommando, DEAKTIVIERE_KARTE, sizeof(DEAKTIVIERE_KARTE));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(DEAKTIVIERE_KARTE),
               kommando, &lenr, antwort);

 /* Terminal-Freigabe */
 ret=CT_close(TERMINAL_NR);
}

/************************************************/
/* beschreibt die Klubkarte                     */
/************************************************/

void schreibe_clubkarte(HWND hDlg)
{
 unsigned char      sad, dad;       /* Quell- und Zieladresse */
 unsigned char      kommando[150];  /* Kommandofeld */
 unsigned char      antwort[30];    /* Antwortfeld */
 unsigned short int lenr, position; /* Lngenangabe */
 unsigned char      ret, laenge;    /* diverses */
 char               eingabe[40];    /* Eingabefeld */

 /* Terminal-Initialisierung */
 ret=CT_init(TERMINAL_NR,COM);      /* Verbindung herstellen */
 if (ret != OK)
 {
     MessageBox(hDlg,"Kartenterminal-Initialisierg. fehlgeschlagen!",
                "kritischer Fehler",MB_ICONEXCLAMATION);
     return;
 }

 /* Rcksetzen des Terminals */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 30;     /* Puffergre */
 memcpy(kommando, RESET_TERMINAL, sizeof(RESET_TERMINAL));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(RESET_TERMINAL), 
               kommando, &lenr, antwort);

 /* Anforderung der Chipkarte */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 30;     /* Puffergre */
 memcpy(kommando, ANFORDERUNG_KARTE, sizeof(ANFORDERUNG_KARTE));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(ANFORDERUNG_KARTE), 
               kommando, &lenr, antwort);

 /* Speicherkarte erkannt? */
 if (!(antwort[0] == 0x90 && antwort[1] == 0x00)  &&
     !(antwort[0] == 0x62 && antwort[1] == 0x01))
     MessageBox(hDlg,"Es wurde keine Speicherkarte gefunden!",
                "kritischer Fehler",MB_ICONEXCLAMATION);
 else
 {
    memcpy(speicher,"3004",4);      /* Karten-ID eintragen */
    position = 4;

    GetDlgItemText(hDlg, IDC_Vorname,eingabe,100);
    speicher[position] = VORNAME;
    laenge = strlen(eingabe);
    speicher[position+1] = laenge;
    memcpy(&speicher[position+2],eingabe,laenge);
    position += 2 + laenge;

    GetDlgItemText(hDlg, IDC_Nachname,eingabe,100);
    speicher[position] = NACHNAME;
    laenge = strlen(eingabe);
    speicher[position+1] = laenge;
    memcpy(&speicher[position+2],eingabe,laenge);
    position += 2 + laenge;

    GetDlgItemText(hDlg, IDC_Mitgliedsnummer,eingabe,100);
    speicher[position] = MITGLIEDS_NR;
    laenge = strlen(eingabe);
    speicher[position+1] = laenge;
    memcpy(&speicher[position+2],eingabe,laenge);
    position += 2 + laenge;

    if (IsDlgButtonChecked(hDlg, IDC_RADIO_Voll) == BST_CHECKED)
        strcpy(eingabe,"K");
    else
        if (IsDlgButtonChecked(hDlg, IDC_RADIO_Vormittags)
             == BST_CHECKED)
            strcpy(eingabe,"V");
        else
            strcpy(eingabe,"S");
    speicher[position] = MITGLIEDS_ART;
    laenge = strlen(eingabe);
    speicher[position+1] = laenge;
    memcpy(&speicher[position+2],eingabe,laenge);
    position += 2 + laenge;

    GetDlgItemText(hDlg, IDC_Gueltigkeit,eingabe,100);
    speicher[position] = GUELTIGKEIT;
    laenge = strlen(eingabe);
    speicher[position+1] = laenge;
    memcpy(&speicher[position+2],eingabe,laenge);
    position += 2 + laenge;

    speicher[MAXSIZE-1] = pruefsumme(); /* XOR-Prfsumme setzen */

    /* Beschreiben der Speicherkarte */
    sad  = 0;       /* Quelle = Kartenterminal */
    dad  = 2;       /* Ziel = Host */
    lenr = 30;      /* Puffergre */
    memcpy(kommando, WRITE_BINARY, sizeof(WRITE_BINARY));
    memcpy(&kommando[5], speicher, MAXSIZE);
    ret = CT_data(TERMINAL_NR, &sad, &dad, 5 + MAXSIZE, 
                  kommando, &lenr, antwort);
    if (ret != 0)
        MessageBox(hDlg,"Fehler beim Schreiben der Daten!",
                    "kritischer Fehler",MB_ICONEXCLAMATION);
 }

 /* Freigeben der Chipkarte */
 sad  = 1;      /* Quelle = Kartenterminal */
 dad  = 2;      /* Ziel = Host */
 lenr = 300;    /* Puffergre */
 memcpy(kommando, DEAKTIVIERE_KARTE, sizeof(DEAKTIVIERE_KARTE));
 ret = CT_data(TERMINAL_NR, &sad, &dad, sizeof(DEAKTIVIERE_KARTE),
               kommando, &lenr, antwort);

 /* Terminal-Freigabe */
 ret = CT_close(TERMINAL_NR);
}


/********************/
/*    DialogProc    */
/********************/

LRESULT CALLBACK DialogProc(HWND hDlg,UINT uMsg,
                            WPARAM wParam,LPARAM lParam)
{
 switch (uMsg)
 {
    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
            case IDC_Lesen: lese_clubkarte(hDlg);
                        break;
            case IDC_Schreiben: schreibe_clubkarte(hDlg);
                        break;
            default:    break;
        }
        return 0;

    case WM_DESTROY:
        PostQuitMessage(0);
        return 0;
 }
 return DefWindowProc(hDlg, uMsg, wParam, lParam);
}

/********************/
/*      WinMain     */
/********************/

int WINAPI WinMain(HINSTANCE hInstance,
           HINSTANCE hPrevInstance,
           LPSTR lpCmdLine,int nCmdShow)
{
 MSG        msg;        /* Nachrichten-Struktur */
 HWND       hwDialog;   /* Handle auf das Fenster */
 WNDCLASS   wnd;        /* Fensterklassen-Struktur */

 static TCHAR   szAppName[] = TEXT("KARTENADMIN");

 /* Fensterklasse registrieren */
 wnd.style = CS_HREDRAW | CS_VREDRAW;
 wnd.lpfnWndProc = DialogProc;
 wnd.cbClsExtra = 0;
 wnd.cbWndExtra = DLGWINDOWEXTRA;
 wnd.hInstance = hInstance;
 wnd.hIcon = LoadIcon(hInstance, "ICON_KARTENADMIN");
 wnd.hCursor = LoadCursor(NULL,IDC_ARROW);
 wnd.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);
 wnd.lpszMenuName = NULL;
 wnd.lpszClassName = szAppName; 
    /* Dialog und Dialog-Klasse mssen gleich heien */
 RegisterClass(&wnd);

 /* Dialogfenster erzeugen und anzeigen */
 hwDialog = CreateDialog(hInstance, szAppName, 0, 0);
 ShowWindow(hwDialog, nCmdShow);

 /* Ereignisschleife */
 while (GetMessage(&msg, NULL,0,0))
 {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
 }

 return msg.wParam;
}