//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.model;

import javax.swing.table.* ;
import javax.swing.event.* ;
import java.util.*;
import java.text.DateFormat;
import javax.mail.*;
import javax.mail.internet.*;

/**
  * Die Klasse HeaderTableModel implementiert das Model
  * fr die Header-Tabelle in der Klasse ReceiveFrame.
  */
public class HeaderTableModel extends AbstractTableModel
																	implements Observer {

	private MailReceiver	mailReceiver;
	private Message[] messages ;

	/**
	  * Konstruktor
	  */
	public HeaderTableModel(MailReceiver mr) {
		super();
		mailReceiver = mr;
		mailReceiver.addObserver(this);
	}
	
	/**
	  * Liefert die Anzahl der Zeilen zurck.
	  */
	public int getRowCount() {
		if (messages != null)
			return messages.length;
		else
			return 0;
	}

	/**
	  * Liefert die Anzahl der Spalten zurck.
	  */
	public int getColumnCount() {
		return 4 ;
	}

	/**
	  * Liefert den Namen der jeweiligen Spalte zurck.
	  */
	public String getColumnName(int columnIndex) {
		switch(columnIndex) {
			case 0:  return "Anhnge";
			case 1:  return "von";
			case 2:  return "Betreff";
			case 3:  return "Eingang" ;
			default: return "";
		}
	}

  /**
    * Liefert abhngig von der Zeile und Spalte den
    * zugehrigen Wert zurck.
    */
	public Object getValueAt(int rowIndex, int columnIndex) {
		Message message = (Message)messages[rowIndex];
		try {
			switch(columnIndex) {
				case 0:
					// Anzahl der Anhnge zurckliefern
					Object o = message.getContent();
					if (o instanceof Multipart)
						return "ja ("+(((Multipart)o).getCount()-1) +")";
					return "nein";
				case 1:
					// Absenderadresse zurckliefern
					InternetAddress[] absender =
                          (InternetAddress[])message.getFrom();
					return absender[0].getAddress();
				case 2:
					// Betreff zurckliefern
					return message.getSubject();
				case 3:
					// Absendedatum zurckliefern
					DateFormat dateFormatter = DateFormat.getDateInstance(
					DateFormat.DEFAULT, new Locale("de", "DE"));
					return dateFormatter.format(message.getSentDate());
				default:
					// Fehler, so weit sollte es nicht kommen
					return "" ;
			}
		} catch (javax.mail.MessagingException e) {
			System.out.println("Fehler in Methode getValueAt(...):" +
                                                e.getMessage());
			e.printStackTrace();
		} catch (java.io.IOException e) {
			System.out.println("Fehler in Methode getValueAt(...):" +
                                                e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

  /**
    * Wird aufgerufen, nachdem Mails von dem Mailserver
    * abgerufen wurden.
    */
	public void update(Observable o, Object arg) {
		// holt Mails von dem MailReceiver-Objekt
		messages = mailReceiver.getMessages();
		// Tabelle aktualisieren
		fireTableDataChanged();
	}
}