#include "Buchung.h"

int main(int argc,char *argv[])
{
  FILE *fKonto=NULL;
  double Betrag, Saldo=0.0;
  long Nummer;
  int PosHaben, SoHa, wirklich=0;
  char Grundbuch[16], Waehrung[16], Konto[16], Kontoer[16];

  if (argc<2)
    {
      fprintf(stderr,
              "Starte mich z.B. so: %s wirklich < grundbuch.gb\n", 
              argv[0]);
      fprintf(stderr, "            oder so: %s probe < grundbuch.gb\n",
              argv[0]);
      return(1);
    }
  if (strcmp(argv[1], "wirklich") == 0)
    wirklich=1;
  /*Kopf der Grundbuch-Datei lesen und Position des Wortes "Haben"
    bestimmen*/
  if (!(PosHaben=Kopf(stdin, Grundbuch, &Nummer)))
    return(3);
  /*Eine Buchungszeile nach der anderen lesen*/
  while ((SoHa=Buchung(stdin,PosHaben,&Betrag,Waehrung,Konto,&Nummer)))
    { /*Zum Konto-Namen gehoerige Hauptbuch-Datei oeffnen; DOS-Macke!*/
      Konto[8]='\0';
      strcpy(Kontoer, Konto);
      strcat(Kontoer, ".hb");
      if ((fKonto=fopen(Kontoer, "r")) == NULL)
        {
          fprintf(stderr,"Konto %s existiert nicht. Lege es an!\n",Konto);
          return (1);
	}
      fclose(fKonto);
      /*Betrag, Waehrung, Herkunftsdatei und Beleg-Nummer in die
        Hauptbuch-Datei uebertragen*/
      if (wirklich)
          {
            fKonto=fopen(Kontoer, "a");
            if (SoHa == HABEN)
              fprintf(fKonto, "               ");
            fprintf(fKonto, "      %10.2f %s", Betrag, Waehrung); 
            if (SoHa == SOLL) 
              fprintf(fKonto, "               "); 
            fprintf(fKonto, "  %-8s  %6ld\n", Grundbuch, Nummer);
            fclose(fKonto);
          }
        if (fabs(Saldo-SoHa*Betrag) > 0.004)
          Saldo += SoHa*Betrag;
        else
          Saldo=0.0;
    }
  /*In einer Grundbuch-Datei muessen Soll und Haben uebereinstimmen*/
  if (fabs(Saldo)>0.004)
    {
      fprintf(stderr,"Im Grundbuch stimmen Soll und Haben nicht");
      return(4);
    }
  return(0);
}

