#include "Buchung.h"

int main(void)
{
  FILE *fBil=NULL, *fGuV=NULL, *fKonto=NULL;
  char Grundbuch[16], Konto[16], Kontoer[16], Waehrung[16];
  double Betrag, Saldo, BilG=0.0, GuVG=0.0;
  long Beleg, Nummer;
  int PosHaben, SoHa;
  /*Bilanz und GuV als Dateien eroeffnen*/
  fBil=fopen("Bilanz","w");
  fprintf(fBil, "        Bilanz\n\n");
  fprintf(fBil,
          "        _______Aktiva  ______Passiva  Konto___  Nummer\n\n");
  fGuV=fopen("GuV", "w");
  fprintf(fGuV, "        GuV\n\n");
  fprintf(fGuV,
          "        _________Soll  ________Haben  Konto___  Nummer\n\n"); 
  /* Namen und Nummer der Hauptbuch-Konten aus dem Standard-Input
    einlesen, erweitern und die zugehoerigen Dateien oeffnen*/
  while (gets(zeile) != NULL)
    {
      sscanf(zeile, "%s %s", Konto, &Nummer);
      strcpy(Kontoer, Konto); 
      strcat(Kontoer, ".hb");
      if ((fKonto=fopen(Kontoer, "r")) == NULL)
        {
          fprintf(stderr, "Konto %s fehlt. Kann keinen Saldo bilden\n",
                  Kontoer);
          fclose(fKonto);
          continue;
	}
      if (!(PosHaben=Kopf(fKonto, Konto, &Nummer))) 
        return (3);
      /*Buchungszeilen einlesen und den Betrag zum Saldo addieren*/
      Saldo=0.0;
      while ((SoHa=Buchung(fKonto, PosHaben, &Betrag, Waehrung, 
                           Grundbuch, &Beleg)))
        Saldo += SoHa*Betrag;
      fclose(fKonto);
      if (fabs(Saldo) < 0.005) 
        Saldo=0.0;
      if (Saldo != 0.0)
	{
          if (Nummer<4000L || (Nummer>=9000L && Nummer<9100L))
            {
              BilG+=Saldo; 
              fKonto=fBil;
            }
          else if (Nummer>=4000L && Nummer<8000L)
            {
              GuVG+=Saldo; 
              fKonto=fGuV;
            }
          else 
            fprintf(stderr, "Saldo %.2f %s auf falschem Konto %ld\n", 
                    Saldo, Waehrung, Nummer);
          /*Saldo in Bilanz oder GuV eintragen*/
          if (Saldo*HABEN>0.0) 
            fprintf(fKonto, "               ");
          fprintf(fKonto, "        %10.2f %s", fabs(Saldo), Waehrung);
          if (Saldo*SOLL > 0.0) 
            fprintf(fKonto, "               "); 
          fprintf(fKonto,"  %-8s  %6ld\n", Konto, Nummer);
        } /* if */
    } /* while */
  printf("Gewinn %10.2f DM\n", GuVG);
  /*GuV und Bilanz muessen bis aufs Vorzeichen denselben Gewinn ergeben*/
  if (fabs(GuVG+BilG) > 0.004)
    {
      fprintf(stderr, "Fehler in Bilanz oder GuV:\n"); 
      fprintf(stderr, "Bilanzgewinn %10.2f DM  GuVGewinn %10.2f DM\n",
              -BilG, GuVG);
    }
  return (0);
}

