#include <jni.h>
#include <stdio.h>
#include "classthree.h"

JNIEXPORT jobject JNICALL Java_classthree_dem2euro(JNIEnv *env, 
                                               jclass in_cls, 
                                               jobject in_request) 
   {
   double dem_rate_c = 1.95583;

   double exchange_rate_c = 0.0;
   long whrg_betrag_c = 0;
   const char *whrg_kuerzel_c;
   double euro_betrag_c = 0.0;
   int calc_erfolgreich_c = 0;
   char whrg_langbezeichnung_c[30];
   jclass jcls;
   jfieldID jfid;
   jmethodID jmid;
   jobject jobj;

   /*  Die Klasse des bergebenen Objektes bestimmen: */
   jcls = (*env)->GetObjectClass(env,in_request); 

   /* Die Adresse des Feldes "whrg_betrag" in dem bergebenen 
      Objektes ermitteln: */
   jfid = (*env)->GetFieldID(env, jcls, "whrg_betrag", "J");
   /* Den Wert des Feldes "whrg_betrag" auslesen: */
   whrg_betrag_c = (*env)->GetLongField(env, in_request, jfid);

   jfid = (*env)->GetFieldID(env, jcls, "whrg_kuerzel", 
                             "Ljava/lang/String;");
   whrg_kuerzel_c = (*env)->GetStringUTFChars(env, 
     (jstring)((*env)->GetObjectField(env,in_request, jfid)),NULL);

   /* Nur Konvertieren wenn DEM Betrag */
   if (!strcmp(whrg_kuerzel_c,"DEM"))
      {
      euro_betrag_c = whrg_betrag_c / dem_rate_c;
      calc_erfolgreich_c = 1;
      strcpy(whrg_langbezeichnung_c,"Deutsche Mark");  
      }

   /* Klassendefinition fr Klasse "Response" suchen: */
   jcls = (*env)->FindClass(env, "Response");
   if (jcls == NULL) 
      {
      printf("Error FindClass\n");  
      return NULL; 
      }

   /* Adresse des Konstruktors der Klasse "Response" ermitteln: */
   jmid = (*env)->GetMethodID(env, jcls, "<init>","()V");
   if (jmid == NULL)
      {
      printf("Error GetMethodID\n");
      return NULL; 
      } 

   /* Neues Objekt der Klasse "Response" erzeuegen und 
      initialisieren: */
   jobj = (*env)->NewObject(env, jcls, jmid);
   if (jobj == NULL)
      {
      printf("Error NewObject\n");
      return NULL;  
      } 

   /* Adresse des Feldes "euro_betrag" in dem neuen Objekt 
      ermitteln: */
   jfid = (*env)->GetFieldID(env, jcls, "euro_betrag", "D");
   /* Wert des Feldes "euro_betrag" in dem neuen Objekt fllen: */
   (*env)->SetDoubleField(env, jobj, jfid, euro_betrag_c);

   jfid = (*env)->GetFieldID(env, jcls, "calc_erfolgreich", "Z");
   (*env)->SetBooleanField(env, jobj, jfid, calc_erfolgreich_c);

   jfid = (*env)->GetFieldID(env, jcls, "whrg_langbezeichnung", 
                             "Ljava/lang/String;");
   (*env)->SetObjectField(env, jobj, jfid, 
                (*env)->NewStringUTF(env, whrg_langbezeichnung_c));

   /* Neues Objekt zurckgeben: */
   return jobj;  
   }

