#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

# package zur verwaltung der Signatur

package M_signature;

use DBI;


##################################################
#
#     DataBase: ZWap-Email
#
#
#
#           table  Signature
#   ------------------------------------------
#   ZWAPuser,   signature
#
#
##################################################




##################################################
sub connectDB {
##################################################
  my (
      $DB_DSN, 
      $DB_USER, 
      $DB_PASSWD
     ) = @_;

  #-- Datenbank-Verbindung herstellen  
  my $dbh = DBI->connect($DB_DSN, $DB_USER, $DB_PASSWD) or $dbh = undef;
 
  return $dbh;
}

##################################################
sub disconnectDB {
##################################################
  my ($dbh) = @_;

  #-- Datenbank-Verbindung schliessen
  $dbh->disconnect();  # Datenbankverbindung lsen.
}

##################################################
sub sig_exists {
##################################################
  my (
      $dbh, 
      $user,
      $alias
     ) = @_;

  my $sql = qq[SELECT alias FROM Signature WHERE ZWAPuser = ? AND alias = ?];

  my $sth = $dbh->prepare( $sql) or return(0);
  $sth->execute( $user, $alias) or return(0);

  ($ali) =  (@row = $sth->fetchrow_array);
  if( !defined $ali) { $ali = "";}
  
  if ( $ali eq $alias) {
    return(1);
  } else {
    return(0);
  }
}

##################################################
sub insert_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias,
     $signature
    ) = @_;
  
  if( sig_exists( $dbh, $user, $alias)) {
    return(0);
  }

  my $sql = qq[
	       INSERT INTO Signature
	       (ZWAPuser,alias,signature)
	       VALUES ('$user', '$alias', '$signature')
	      ];

  $dbh->do($sql) or die "Insert failed ($sql)";

  return(1);
}

##################################################
sub update_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias,
     $signature
    ) = @_;

  my $sql = qq[
	       UPDATE Signature SET
	       signature='$signature'
	       WHERE (ZWAPuser = '$user' AND alias = '$alias')
	      ];

  $dbh->do($sql) or die "Update failed ($sql)";

  return(1);
}

##################################################
sub delete_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias
    ) = @_;

  my $sql = qq[
               DELETE FROM Signature
               WHERE (ZWAPuser = '$user' AND alias = '$alias') 
              ];

  $dbh->do($sql) or return(0);

  return(1);
}

#################################################
#-- alle Signaturen holen
#################################################
sub getSignatures {
  my (
      $dbh, 
      $user, 
      $signatures
     ) = @_;

  my $sth = $dbh->prepare(
			  "SELECT alias, signature FROM Signature WHERE (ZWAPuser = ?)"
			 );
  $sth->execute( $user);
  
  while( (@row = $sth->fetchrow_array) ) {
    ($alias,$text) =  (@row);
    $ {$signatures}{$alias} = ${text};
  }
}

#################################################
#-- einen Signature-Text holen
#################################################
sub getSignature {
  my (
      $dbh, 
      $user,
      $alias
     ) = @_;

  my $sth = $dbh->prepare(
			  "SELECT signature FROM Signature WHERE (ZWAPuser = ? AND alias = ?)"
			 );
  $sth->execute( $user,$alias);

  my ($t) = (@row = $sth->fetchrow_array);
  return($t);
}


#---------------------------------------------------------------------

1;     # rueckmeldung

#---------------------------------------------------------------------
