#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


package M_Wmessages;



#------------------------------------------------------------------------------------
#
#  Types:    T_*               Card Title
#            C_*               Card Content
#            N_*               Navigation (Options)
#            NL_*              Navigation by Links
#
#
#  language: EN  - englisch
#            DE  - deutsch
#
#        messages{language}{messNo}

my %messages = (
		
		EN => {  # english
		       T_MESSAGE               => "zWAP-message",
		       T_FAILED                => "zWAP-failed",
		       T_CLOSED                => "zWAP-closed",
		       T_LOGOFF                => "zWAP-logoff",
		       T_AUTOLOGOUT            => " auto-logoff ",
		       T_BUSY                  => "zWAP-busy",
		       T_CONNECT               => " connecting ... ",
		       T_WRITEMAIL             => "To:",     #"mail to:",
		       T_INP_ADDR              => "mail addr.",
		       T_SEL_TEXT              => "InstantText",
		       T_EDITMAIL              => "edit mail",
		       T_CFGFILTER             => "conf. filter",
		 
		       C_NO_MSGID              => "no mailID selected.",
		       C_NO_ACTION             => "no action selected.",
		       C_NO_PWFOUND            => "no password found for \$ID</br>session closed.",
		       C_NO_POPSERVER          => "no POP-server found for \$ID.",
		       C_NO_SESSION            => "there's no session for \$ID.",
		       C_NO_SESSIONDB_CONNECT  => "no connection to session-database.",
		       C_NO_USERDB_CONNECT     => "no connection to user-database.",
		       C_NO_USERNAME           => "no name set.",
		       C_NO_MAILSERVER_CONNECT => "no connection to mail-server.",
		       C_SESSION_CLOSED        => "session for \$ID already closed.",
		       C_SESSION_KILLED        => "session for \$ID killed.",
		       C_SESSION_RUNNING       => "session for \$ID already running.",
		       C_WRONG_NAMEPW          => "name or password mismatch.",
		       C_WRONG_NAMEPW_ZWAP     => "name or ZWAP-password mismatch!",
		       C_NOMAIL                => "<br/>no mail!",
		       C_MAILEMPTY             => "<br/>no content in mail :(",
		       C_MAILSENT              => "mail successfully sent",
		       C_NO_MAILSENT           => "recipient set?",
		       C_SUBJECT               => "Subject:",
		       C_MAILTEXT              => "Text:",
		       C_TO                    => "To:",
		       C_SELECTFILTER          => "filter type:",
		       C_FILTER_NONE           => "none",
		       C_FILTER_EXCL           => "reject",
		       C_FILTER_INCL           => "accept",
		       
		       ErrUnknown              => "unknown error",

		       N_next                  => "z: next mails",
		       N_nextlines             => "z: next lines",
		       N_logoff                => "z: logoff",
		       N_content               => "z: mail index",
		       N_editmail              => "z: write mail",
		       N_sendmail              => "z: send mail",
		       N_replymail             => "z: reply to",
		       N_cfgfiltermail         => "z: conf. filter",

		       NL_NEXT                 => "next",
		       NL_GETINPUT             => "get input",

		      },

		DE => {  # deutsch
		       T_MESSAGE               => "zWAP-Meldung",
		       T_FAILED                => "zWAP-Fehler",
		       T_CLOSED                => "zWAP-beendet",
		       T_LOGOFF                => "zWAP-verlassen",
		       T_AUTOLOGOUT            => " auto-verlassen ",
		       T_BUSY                  => "zWAP-besetzt",
		       T_CONNECT               => " verbinde zu ",
		       T_WRITEMAIL             => "To:",   #"mail an:",
		       T_INP_ADDR              => "mail Adresse",
		       T_SEL_TEXT              => "InstantText",
		       T_EDITMAIL              => "ediere mail",
		       T_CFGFILTER             => "konf. filter",
		       
		       C_NO_MSGID              => "Keine MailID angegeben.",
		       C_NO_ACTION             => "Keine Aktion angegeben.",
		       C_NO_PWFOUND            => "Kein Passwort fuer \$ID gefunden.<br/>Ihre session wurde jetzt beendet.",
		       C_NO_POPSERVER          => "Kein POP-Server fuer \$ID.",
		       C_NO_SESSION            => "Keine Session fuer \$ID.",
		       C_NO_SESSIONDB_CONNECT  => "Keine Verbindung zur Session-Datenbank.",
		       C_NO_USERDB_CONNECT     => "Keine Verbindung zur User-Datenbank.",
		       C_NO_USERNAME           => "Kein Name angegeben.",
		       C_NO_MAILSERVER_CONNECT => "Keine Verbindung zum Mail-Server.",
		       C_SESSION_CLOSED        => "Session fuer \$ID ist bereits beendet.",
		       C_SESSION_KILLED        => "Session fuer \$ID wurde abgebrochen.",
		       C_SESSION_RUNNING       => "Session fuer \$ID besteht bereits.",
		       C_WRONG_NAMEPW          => "Name oder Passwort falsch.",
		       C_WRONG_NAMEPW_ZWAP     => "Name oder ZWAP-Passwort falsch!",
		       C_NOMAIL                => "<br/>keine Mail!",
		       C_MAILEMPTY             => "<br/>Mail ist leer :(",
		       C_MAILSENT              => "Mail ist gesendet.",
		       C_NO_MAILSENT           => "Empfaenger angegeben?",
		       C_SUBJECT               => "Betreff:",
		       C_MAILTEXT              => "Text:",
		       C_TO                    => "An:",
		       C_SELECTFILTER          => "Filter Typ:",
		       C_FILTER_NONE           => "keiner",
		       C_FILTER_EXCL           => "abweisen",
		       C_FILTER_INCL           => "annehmen",
		       
		       ErrUnknown              => "unbekannter Fehler",
		       
		       N_next                  => "z: weitere Mails",
		       N_nextlines             => "z: weitere Zeilen",
		       N_logoff                => "z: abmelden",
		       N_content               => "z: Mail Liste",
		       N_editmail              => "z: Mail schreiben",
		       N_sendmail              => "z: Mail absenden",
		       N_replymail             => "z: antworten",
		       N_cfgfiltermail         => "z: konf. Filter",

		       NL_NEXT                 => "weiter",
		       NL_GETINPUT             => "freie Eingabe",
		      },
		
	       );


#------------------------------------------------------------------------------------
sub getText {
  my ($language,$messNo) = @_;

  return( $messages{$language}{$messNo} );
}

#------------------------------------------------------------------------------------

1;   #-- zum returnen

#------------------------------------------------------------------------------------
