#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

package WML_header;


require "M_wmessages.pm";


sub encode2wml {
  my ($str) = @_;

  $str =~ s/\"//g;
  $str =~ s/&/\&amp;/;
  $str =~ s/</\&lt;/;
  $str =~ s/>/\&gt;/;
  $str =~ s/\'/\&quot;/;
  $str =~ s/\`/\&apos;/;

  return( $str );
}

sub printContentType {
  print "Content-Type: text/vnd.wap.wml\n";
  print "Cache-Control: no-cache\n";
  print "Expires: Thu, 01 Dec 1994 16:00:00 GMT\n\n";
}

sub printDocType {

  print "<?xml version=\"1.0\"?>\n"
      . "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n";
}

sub printWmlBegin {
  print "<wml>\n";
}

sub printWmlEnd {
  print "</wml>\n";
}

sub printTemplate {
  print "<template>\n"
      . "<do type=\"prev\" label=\"Back\">\n"
      . "<prev/>\n"
      . "</do>\n"
      . "</template>\n";	
	
}

sub printErrorCard {
  my ($template,$cname,$ctitle,$message) = @_;

  if ( $template == 1 ) { printTemplate(); }
  printCardBegin( $cname, $ctitle);
  print "$message \n";
  printCardEnd();
}

sub printCardBegin {
  my ($id,$title) = @_;
  print "<card id=\"$id\" title=\" ${title} \" ><p>\n";
}

sub printCardBeginNewContext {
  # newcontext == 1 causes browser to reset all variables and history
  my ($id,$title) = @_;
  print "<card id=\"$id\" title=\"${title}\"";
  print " newcontext=\"true\" "; 
  print "><p>\n";
}

sub printCardEnd {
  print "</p>\n</card>\n";
}

sub nextButton {
  my ($link,$sessID,$ID,
      $start,$lang) = @_;

  #- next-button
  print "<do type=\"accept\" label=\"" 
        . M_Wmessages::getText( $lang,"N_next") 
        . "\">"
        . "<go href=\"$link/$sessID/$ID\" method=\"get\">"
        . "<postfield name=\"action\" value=\"content\"/>"
        . "<postfield name=\"start\" value=\"$start\"/>"
        . "</go></do>\n";
}

sub logoffButton {
  my ($link,$sessID,$ID,$lang) = @_;
  
  #- logoff-button
  print "<do type=\"reset\" label=\"" 
        . M_Wmessages::getText( $lang,"N_logoff") 
        . "\">"
        . "<go href=\"$link/$ID\" method=\"post\">"
        . "<postfield name=\"action\" value=\"logoff\"/>"
        . "<postfield name=\"session\" value=\"$sessID\"/>"
        . "</go></do>\n";
}

sub nextLinesButton {
  my ($link,$sessID,$ID,
      $start,$end,$msgID,$lang) = @_;

  #- nextLines-button
  print "<do type=\"accept\" label=\"" 
      . M_Wmessages::getText( $lang,"N_nextlines") 
      . "\">"
      . "<go href=\"$link/$sessID/$ID\" method=\"get\">"
      . "<postfield name=\"action\" value=\"showmail\"/>"
      . "<postfield name=\"start\" value=\"$start\"/>"
      . "<postfield name=\"end\" value=\"$end\"/>"
      . "<postfield name=\"msgID\" value=\"$msgID\"/>"
      . "</go></do>\n";
}

sub contentButton {
  my ($link,$sessID,$ID,$start,$end,$lang) = @_;

  #- Inhalt-button
  print "<do type=\"accept\" label=\"" 
      . M_Wmessages::getText( $lang,"N_content") 
      . "\">"
      . "<go href=\"$link/$sessID/$ID\" method=\"get\">"
      . "<postfield name=\"action\" value=\"content\"/>"
      . "<postfield name=\"start\" value=\"$start\"/>"
      . "<postfield name=\"end\" value=\"$end\"/>"
      . "</go></do>\n";
}

sub backButton {
  my ($lang) = @_;

  print "<do type=\"prev\" label=\"Back\"><prev/></do>\n";
}

sub writemailButton {
  my ($link,$sessID,$ID,$lang) = @_;

  #- edit-button
  print "<do type=\"accept\" label=\"" 
        . M_Wmessages::getText( $lang,"N_editmail") 
        . "\">"
        . "<go href=\"$link/$sessID/$ID\" method=\"get\">"
        . "<postfield name=\"action\" value=\"writemail\"/>"
        . "</go></do>\n";
}


sub replyButton {
   my ($link, $sessID, $ID, $lang, 
       $to, $subj) = @_;

   my $cache_fooling = time;

    print "<do type=\"accept\" label=\"" 
        . M_Wmessages::getText( $lang,"N_replymail") 
	. "\">"
#        . "<go href=\"$link/$sessID/$ID\" method=\"post\">"
        . "<go href=\"$link/$sessID/$ID/${cache_fooling}\" method=\"post\">"
        . "<postfield name=\"action\" value=\"replymail\"/>"
        . "<postfield name=\"to\" value=\"${to}\"/>"
        . "<postfield name=\"subj\" value=\"Re: ${subj}\"/>"
# teile der mail einfuegen ??       . "<postfield name=\"cont\" value=\"\"/>"
        . "</go></do>\n";     
  }
#--------------------------------------



#sub sendmailButton {
#  my ($link,$sessID,$ID,$lang,$from) = @_;
#
#  #- send-button
#  print "<do type=\"accept\" label=\"" . M_Wmessages::getText( $lang,"N_sendmail") . "\">"
#        . "<go href=\"$link/$sessID/$ID\" method=\"post\">"
#        . "<postfield name=\"action\" value=\"sendmail\"/>"
#        . "<postfield name=\"from\" value=\"$from\"/>"
#        . "<postfield name=\"tn\" value=\"\$(tn)\"/>"
#        . "<postfield name=\"cont\" value=\"\$(cont)\"/>"
#        . "<postfield name=\"s\" value=\"\$(subj)\"/>"
#        . "<postfield name=\"to\" value=\"\$(to)\"/>"
#        . "</go></do>\n";
#}

sub sendmailButton2 {
  my ($link,$sessID,$ID,$lang,
      $from,$to,$toNo) = @_;

  #- send-button
  print "<do type=\"accept\" label=\"" 
        . M_Wmessages::getText( $lang,"N_sendmail") 
        . "\">"
        . "<go href=\"$link/$sessID/$ID\" method=\"post\">"
        . "<postfield name=\"action\" value=\"sendmail\"/>"
        . "<postfield name=\"from\" value=\"$from\"/>"
        . "<postfield name=\"to\" value=\"$to\"/>"
        . "<postfield name=\"tn\" value=\"$toNo\"/>"
        . "<postfield name=\"cont\" value=\"\$(cont)\"/>"
        . "<postfield name=\"s\" value=\"\$(subj)\"/>"
        . "</go></do>\n";
}


#--------------------------
sub cfgfilterButton {
  my ($link,$sessID,$ID,$lang) = @_;

  #- edit-button
  print "<do type=\"accept\" label=\"" 
        . M_Wmessages::getText( $lang,"N_cfgfiltermail") 
        . "\">"
        . "<go href=\"$link/$sessID/$ID\" method=\"get\">"
        . "<postfield name=\"action\" value=\"cfgfilter\"/>"
        . "</go></do>\n";
}


#--------------------------------------------------------

1;    #-- rueckgabe

#---------------------------------------------------------
