// OneMethod.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//      To merge the proxy/stub code into the object DLL, add the file 
//      dlldatax.c to the project.  Make sure precompiled headers 
//      are turned off for this file, and add _MERGE_PROXYSTUB to the 
//      defines for the project.  
//
//      If you are not running WinNT4.0 or Win95 with DCOM, then you
//      need to remove the following define from dlldatax.c
//      #define _WIN32_WINNT 0x0400
//
//      Further, if you are running MIDL without /Oicf switch, you also 
//      need to remove the following define from dlldatax.c.
//      #define USE_STUBLESS_PROXY
//
//      Modify the custom build rule for OneMethod.idl by adding the following 
//      files to the Outputs.
//          OneMethod_p.c
//          dlldata.c
//      To build a separate proxy/stub DLL, 
//      run nmake -f OneMethodps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "OneMethod.h"
#include "dlldatax.h"

#include "OneMethod_i.c"
#include "Method.h"

#ifdef _MERGE_PROXYSTUB
extern "C" HINSTANCE hProxyDll;
#endif

CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_Method, CMethod)
END_OBJECT_MAP()

class COneMethodApp : public CWinApp
{
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COneMethodApp)
	public:
    virtual BOOL InitInstance();
    virtual int ExitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(COneMethodApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

BEGIN_MESSAGE_MAP(COneMethodApp, CWinApp)
	//{{AFX_MSG_MAP(COneMethodApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

COneMethodApp theApp;

BOOL COneMethodApp::InitInstance()
{
#ifdef _MERGE_PROXYSTUB
    hProxyDll = m_hInstance;
#endif
    _Module.Init(ObjectMap, m_hInstance, &LIBID_ONEMETHODLib);
    return CWinApp::InitInstance();
}

int COneMethodApp::ExitInstance()
{
    _Module.Term();
    return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
#ifdef _MERGE_PROXYSTUB
    if (PrxDllCanUnloadNow() != S_OK)
        return S_FALSE;
#endif
    AFX_MANAGE_STATE(AfxGetStaticModuleState());
    return (AfxDllCanUnloadNow()==S_OK && _Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
#ifdef _MERGE_PROXYSTUB
    if (PrxDllGetClassObject(rclsid, riid, ppv) == S_OK)
        return S_OK;
#endif
    return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
#ifdef _MERGE_PROXYSTUB
    HRESULT hRes = PrxDllRegisterServer();
    if (FAILED(hRes))
        return hRes;
#endif
    // registers object, typelib and all interfaces in typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
#ifdef _MERGE_PROXYSTUB
    PrxDllUnregisterServer();
#endif
    return _Module.UnregisterServer(TRUE);
}

STDMETHODIMP CMethod::One(/*[in]*/ long in, /*[out,retval]*/ long* pResult) 
{
	HRESULT hr;

	CDispPtr Application;
	hr = theDocument.GetDispPropertyByName(L"Application",LOCALE_NEUTRAL,Application);
	if ( FAILED(hr) )
		return S_OK;

	CDispPtr ActiveSheet;
	hr = theDocument.GetDispPropertyByName(L"ActiveSheet",LOCALE_NEUTRAL,ActiveSheet);
	if ( FAILED(hr) )
		return S_OK;

	CDispPtr Cells;
	hr = ActiveSheet.GetDispPropertyByName(L"Cells",LOCALE_NEUTRAL,Cells);
	if ( FAILED(hr) )
		return S_OK;

	CComDispParams theParams(2);
	CDispPtr Range;
	CComVariant First, Second;
	First.vt = Second.vt = VT_I4;
	First.lVal = 15;
	Second.lVal = 16;
	CComVariant Wert, Cell1, Cell2;
	Wert.vt = VT_I4;
	for(long i = 1;i <= 10;i++) {
		for(long k = 1;k <= 10;k++) {
			theParams.SetParam(0,i,VT_I4);
			theParams.SetParam(1,k,VT_I4);
			Cell1.Clear();
			Cells.GetIndexedPropertyByName(L"Item",LOCALE_NEUTRAL,&theParams,&Cell1,NULL);
			Range = Cell1.pdispVal;

			CDispPtr Interior;
			Range.GetDispPropertyByName(L"Interior",LOCALE_NEUTRAL,Interior);
			if ( ( i % 2 == 1 ) ^ ( k % 2 == 1 ) )
				Interior.PutPropertyByName(L"ColorIndex",LOCALE_NEUTRAL,&First);
			else
				Interior.PutPropertyByName(L"ColorIndex",LOCALE_NEUTRAL,&Second);
			Wert.lVal = k * i * in;
			Range.PutPropertyByName(L"Value",LOCALE_NEUTRAL,&Wert);
		}
	}

	CDispPtr Cell1Ptr,Cell2Ptr;
	CComVariant RowValue,ColumnValue;

	long RowSum, ColumnSum;
	for(i = 1;i <= 10;i++) {
		RowSum = ColumnSum = 0;
		for(long k = 1;k <= 10;k++) {
			theParams.SetParam(0,k,VT_I4);
			theParams.SetParam(1,i,VT_I4);
			Cell1.Clear();
			Cells.GetIndexedPropertyByName(L"Item",LOCALE_NEUTRAL,&theParams,&Cell1,NULL);
			Cell1Ptr = Cell1.pdispVal;
			theParams.SetParam(0,i,VT_I4);
			theParams.SetParam(1,k,VT_I4);
			Cell2.Clear();
			Cells.GetIndexedPropertyByName(L"Item",LOCALE_NEUTRAL,&theParams,&Cell2,NULL);
			Cell2Ptr = Cell2.pdispVal;
			Cell1Ptr.GetPropertyByName(L"Value",LOCALE_NEUTRAL,&RowValue);
			Cell2Ptr.GetPropertyByName(L"Value",LOCALE_NEUTRAL,&ColumnValue);
			RowValue.ChangeType(VT_I4);
			ColumnValue.ChangeType(VT_I4);
			RowSum += RowValue.lVal;
			ColumnSum += ColumnValue.lVal;
		}
		theParams.SetParam(0,12,VT_I4);
		theParams.SetParam(1,i,VT_I4);
		Cell1.Clear();
		Cells.GetIndexedPropertyByName(L"Item",LOCALE_NEUTRAL,&theParams,&Cell1,NULL);
		Cell1Ptr = Cell1.pdispVal;
		RowValue.vt = VT_I4;
		RowValue.lVal = RowSum;
		Cell1Ptr.PutPropertyByName(L"Value",LOCALE_NEUTRAL,&RowValue);

		theParams.SetParam(0,i,VT_I4);
		theParams.SetParam(1,12,VT_I4);
		Cell2.Clear();
		Cells.GetIndexedPropertyByName(L"Item",LOCALE_NEUTRAL,&theParams,&Cell2,NULL);
		Cell2Ptr = Cell2.pdispVal;
		ColumnValue.vt = VT_I4;
		ColumnValue.lVal = ColumnSum;
		Cell2Ptr.PutPropertyByName(L"Value",LOCALE_NEUTRAL,&ColumnValue);
	}

	return S_OK;
}

STDMETHODIMP CMethod::put_Doc(IDispatch* Doc)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	if ( Doc != NULL )
		theDocument = Doc;
	return S_OK;
}