// SortDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sort.h"
#include "SortDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DIMOF(x) (sizeof(x)/sizeof(*x))
#define MAX_ENTRIES 10

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSortDlg dialog

CSortDlg::CSortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSortDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSortDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSortDlg, CDialog)
	//{{AFX_MSG_MAP(CSortDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//----------------------------------------------------------------------------
// struct SORTSTRING
//----------------------------------------------------------------------------
typedef struct
{
    LPCTSTR DisplayString;
    TCHAR   SortString[256];
} SORTSTRING;

//****************************************************************************
// CompareWithStrcpy()
//
// Sortiert Texte nach Codepoints. Zum Beispiel Umlaute werden falsch
// sortiert
//
// IN:  elem1 - Text1
//      elem2 - Text2
// OUT: < 0 wenn Text1 < Text2, 0 wenn Text1 == Text2, > 0 wenn Text1 > text2
//****************************************************************************
int CompareWithStrcpy( const void *elem1, const void *elem2)
{
    return _tcscmp( *(LPTSTR *) elem1, *(LPTSTR *) elem2);
}

//****************************************************************************
// CompareWithCompareString()
//
// Sortiert Texte nach den Konvetionen des Locales, das in den System-
// einstellungen eingestellt ist.
//
// IN:  elem1 - Text1
//      elem2 - Text2
// OUT: < 0 wenn Text1 < Text2, 0 wenn Text1 == Text2, > 0 wenn Text1 > text2
//****************************************************************************
int CompareWithCompareString( const void *elem1, const void *elem2)
{
    return CompareString(LOCALE_SYSTEM_DEFAULT, 
                         NORM_IGNORESYMBOLS | SORT_STRINGSORT,
                         *(LPCTSTR *) elem1, -1,
                         *(LPCTSTR *) elem2, -1) - CSTR_EQUAL;
}

//****************************************************************************
// CompareWithStrcpyStruct()
//
// Sortiert Texte lexikalisch korrekt auch mit _tcscmp. Der Sortiertext
// ist aber nicht der Anzeigetext!
//
// IN:  elem1 - Text1
//      elem2 - Text2
// OUT: < 0 wenn Text1 < Text2, 0 wenn Text1 == Text2, > 0 wenn Text1 > text2
//****************************************************************************
int CompareWithStrcpyStruct( const void *elem1, const void *elem2)
{
    return _tcscmp( ((SORTSTRING *) elem1)->SortString, 
                    ((SORTSTRING *) elem2)->SortString);
}

//****************************************************************************
// CSortDlg::FillListBoxes()
//
// Listenboxen mit sortierten Texten fllen
//
// IN:
// OUT:
//****************************************************************************
void CSortDlg::FillListBoxes()
{
    LPCTSTR data[] =
    { 
        _T("Mller"),
        _T("Code-Page"),
        _T("Ahle"),
        _T("Codei"),
        _T("Musste"),
        _T("hnlich"),
        _T("Mute"),
        _T("CodePage"),
        _T("Mueller")
    };

    SORTSTRING sd[MAX_ENTRIES];
    int   i;

    // So nicht!
    qsort(data, DIMOF(data), sizeof(*data), CompareWithStrcpy);
    for (i = 0; i < DIMOF(data) && i < MAX_ENTRIES; i++)
        LBStrcpy.AddString(data[i]);

    // Statt _tcscmp CompareString verwenden. Sortierung stimmt
    qsort(data, DIMOF(data), sizeof(*data), CompareWithCompareString);
    for (i = 0; i < DIMOF(data) && i < MAX_ENTRIES; i++)
        LBCompareString.AddString(data[i]);

    // Aus Texten Sortierstrings erzeugen ...
    for (i = 0; i < DIMOF(data) && i < MAX_ENTRIES; i++)
    {
        sd[i].DisplayString = data[i];

        LCMapString( LOCALE_SYSTEM_DEFAULT, 
                     LCMAP_SORTKEY, 
                     data[i], -1, 
                     sd[i].SortString, 256);
    }

    // ... die liefern auch mit _tcscmp eine lexikalische Sortierung
    qsort(sd, DIMOF(data), sizeof(SORTSTRING), CompareWithStrcpyStruct);

    for (i = 0; i < DIMOF(data) && i < MAX_ENTRIES; i++)
        LBSortString.AddString(sd[i].DisplayString);
}


/////////////////////////////////////////////////////////////////////////////
// CSortDlg message handlers

BOOL CSortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

    LBStrcpy.SubclassDlgItem(IDC_LIST1, this);
    LBCompareString.SubclassDlgItem(IDC_LIST2, this);
    LBSortString.SubclassDlgItem(IDC_LIST3, this);
    	
    FillListBoxes();
    	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSortDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSortDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSortDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
