/* Grafische Komponentenentwicklung
   (C) 2000 by Johannes Leckebusch
   Datum: 20. 8. 2000 */
//---------------------------------------------------------------------------

#include <vcl.h>
#include <Filectrl.hpp>
#pragma hdrstop

#include "MCISoundForm.h"
#include "FormDlg.h"
#pragma package(smart_init)
#pragma resource "mcisoundform.dcr"
//---------------------------------------------------------------------------
// ValidCtrCheck wird benutzt, um sicherzustellen, da die erzeugten Komponenten
// keine rein virtuellen Funktionen besitzen.
//

static inline void ValidCtrCheck(TMCISoundForm *)
{
        new TMCISoundForm(NULL);
}
//---------------------------------------------------------------------------
__fastcall TMCISoundForm::TMCISoundForm(TComponent* Owner)
        : TComponent(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundForm::SetInitialDir (AnsiString value)
{
  if (DirectoryExists (value))
    FSoundDir = value;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TMCISoundForm::GetInitialDir()
{
  return FSoundDir;
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundForm::Execute(AnsiString LoadFile, bool PlayFile)
{
  if (!FormSoundDlg)
    FormSoundDlg = new TFormSoundDlg (Application); // Dialogfeld erzeugen
  try
  {
    FormSoundDlg->MCISoundFrameKomp1->OnEndRecord = OnEndRecord;
    if (FSoundDir != "")
     FormSoundDlg->MCISoundFrameKomp1->StartDir = FSoundDir;

    if (LoadFile != "")
      FormSoundDlg->MCISoundFrameKomp1->LoadSoundFile (LoadFile);

    if (PlayFile)
      FormSoundDlg->MCISoundFrameKomp1->PlaySoundFile();

    FormSoundDlg->Show();
    FormSoundDlg->ModalResult = mrOk;
  }
  catch (EInvalidOperation&)
  {
  }

}
//---------------------------------------------------------------------------
void __fastcall TMCISoundForm::SetEndRecordEvent (TEndRecordEvent EndREvent)
{
//  FormSoundDlg->MCISoundFrameKomp1->OnEndRecord = EndREvent;
  FEndRecordEvent = EndREvent;
}
//---------------------------------------------------------------------------
TEndRecordEvent __fastcall TMCISoundForm::GetEndRecordEvent ()
{
//  return FormSoundDlg->MCISoundFrameKomp1->OnEndRecord;
  return FEndRecordEvent;
}
//---------------------------------------------------------------------------
namespace Mcisoundform
{
        void __fastcall PACKAGE Register()
        {
                 TComponentClass classes[1] = {__classid(TMCISoundForm)};
                 RegisterComponents("Sound", classes, 0);
        }
}
//---------------------------------------------------------------------------

bool __fastcall TMCISoundForm::Play()
{
        //TODO: Hier Ihren Quelltext einfgen
  if (!FormSoundDlg)
   return false;
  else
    return FormSoundDlg->MCISoundFrameKomp1->PlaySoundFile();
}
//---------------------------------------------------------------------------

bool __fastcall TMCISoundForm::Stop()
{
        //TODO: Hier Ihren Quelltext einfgen
  if (!FormSoundDlg)
   return false;
  else {
    FormSoundDlg->MCISoundFrameKomp1->StopSound();
    return true;
  }
}
//---------------------------------------------------------------------------

bool __fastcall TMCISoundForm::Record()
{
        //TODO: Hier Ihren Quelltext einfgen
  if (!FormSoundDlg)
   return false;
  else
    return FormSoundDlg->MCISoundFrameKomp1->RecordSoundFile();
}
//---------------------------------------------------------------------------
bool __fastcall TMCISoundForm::Load(AnsiString LoadFile)
{
        //TODO: Hier Ihren Quelltext einfgen
  if (!FormSoundDlg)
   return false;
  else
    return FormSoundDlg->MCISoundFrameKomp1->LoadSoundFile(LoadFile);
}

