#!/usr/bin/perl -w
# resend.pl  by hwb/ju, Heise Verlag
#
# read mail from stdin, extract delivery date from subject
# deliver at given time.
#
# Copyright: GPL 

use strict;
use Mail::Internet;
# use MIME::Words qw(:all);    # activate to use MIME-decoding

use vars qw ($message $to $from $subject $replyto $prec $atdate
	     $fromaddress $myaddress $mailerdaemon $sendmail
	     $sendmail_cmd $at_cmd $head $mdir $now $fname);


######### Configure those #########
$fromaddress  = "postmaster\@MYDOMAIN.de";  # change to own domain
die "Configure mail adress first";          # comment this line
$myaddress    = "resend\@";
$mailerdaemon = "MAILER-DAEMON\@";
$sendmail     = "/usr/lib/sendmail";
$at_cmd       = "/usr/bin/at";

$mdir         = "/home/resend/mdir";
$now          = time;
$fname        = "$mdir/$now-$$";             # unique filename

$sendmail_cmd = "(/bin/cat $fname | $sendmail -t -oi -f$fromaddress)".
                " && /bin/rm $fname";

####################################


umask 077;  # restricted file permissions (better set in .profile) 

$message = new Mail::Internet \*STDIN, MailFrom => "IGNORE" ;
$message->escape_from();

$head    = $message->head;

$from    = $head->get("From");
$to      = $head->get("To");
$subject = $head->get("Subject");      
# activate the following line to do MIME-decoding
# $subject = decode_mimewords( $head->get("Subject") );
$replyto = $head->get("Reply-To");
$prec    = $head->get("Precedence");

if ($replyto) { $from = $replyto; }

# don't process mail from myself - avoid loops !
if (( $from =~ /$myaddress/ ) or ( $from =~ /$mailerdaemon/ ))
{
    # FIXME: forward to postmaster
    if (open FOO, ">$fname") 
    {
	$message->print_header ( \*FOO );
	print FOO "\n";
	$message->print_body ( \*FOO );
	close FOO;
    } 
    else
    {
	die "can't open $fname for writing";
    }
    die "ignoring Mail $fname from: $from  Subject: $subject";
}

$atdate = &at_date_from_sub($subject);
 
# remove some headers we don't want in an autoreply
my $unwanted;
foreach $unwanted ('Received', 'Resent-From', 'Resent-Sender',
		   'Resent-Date', 'Resent-To', 'Resent-cc', 
		   'Resent-bcc',
		   'Return-path', 'Message-Id', 'Date',
		   'From', 'To', 'Sender', 'Reply-To',
		   'Cc', 'Bcc', 'Precedence',
		   # remove old references, too
		   'References', 'In-Reply-To', 'X-Original-From')
                {
                    $head->delete($unwanted);
                }
$head->add('X-Original-From', $from);
$head->add('X-Resend-Date', $atdate);
$head->add('From', $fromaddress);
$head->add('To', $from);

if (open FOO, ">$fname") 
{
    print "Mailing $fname at: $atdate to: ", $head->get('To');
    $message->print_header ( \*FOO );
    print FOO "\n";
    $message->print_body ( \*FOO );
    close FOO;
} 
else
{
    die "can't open $fname for writing";
}

if (open AT, "|$at_cmd $atdate")
{
    print AT "$sendmail_cmd";
    close AT;
    if ($?)
    {
        my $err=$?;
        die "at failed with errror code $err, not sending $fname!\n";
    }
}
else 
{
    die "at-error! Not sending $fname";
}

exit 0; 


# try to parse the beginning of a string as a date dd.mm.yy[yy],
# optionally followed by a time hh:mm. Alternatively, try to parse the
# first word of the string as a time relative to the second argument
# $msgtime using interval2seconds. If successful, return 
# date in at compatible format, on error "now"
sub at_date_from_sub
{
    my $subject = shift;
    
    my $result = "now";

    if ($subject =~ s/^(\d\d?)\.(\d\d?)\.(\d{1,4})($|\D)//)
    {
        my $day = $1;
        my $month = $2;
        my $year = $3;
        my ($hour, $min) = (0, 0);
        if ($subject =~ /^(\d\d?):(\d\d)($|\D)/)
        {
            $hour = $1;
            $min = $2;
        }
        
        if ($year >= 2000)
        {
            $year -= 2000;
        }
        
        $result = &date2atstr($min, $hour, $day, $month, $year);
    }

    elsif ($subject =~ /^\+?(\w+)/)
    {
        my $interval = &interval2seconds($1);
        if (defined($interval))
        {
	    my ($sec,$min,$hour,$day,$month,$year,$wday,$yday,$isdst) = 
		localtime(time+$interval);

	    $year -= 100;  # years count from 1900
	    $month++;      # months 0..11
	    $result = &date2atstr($min, $hour, $day, $month, $year);
        }
    }
    return $result;
} # at_date_from_sub

# create an at compatible string from paramters
sub date2atstr
{
    my $min = shift;
    my $hour = shift;
    my $day = shift;
    my $month = shift;
    my $year = shift;
    my $result = "now";
    # FIXME: return "now" in case of undefined elements
    $result = sprintf( "%02d:%02d %02d.%02d.%02d", 
		       $hour, $min, $day, $month, $year);
    return $result;
} # date2str


# convert a string describing an interval of time to a number of
# seconds. Syntax: see code. Example 2w (2 weeks), 1d (1 day), 1.5h
# (1.5 hours), 1h30m (same)...
sub interval2seconds
{
    my $arg=shift;

    my $seconds=0;
    while ($arg =~ s/^(\d+\.?\d*|\d*\.\d+)([wdhms])//)
    {
        $seconds += $1 *
        { 's' => 1,
          'm' => 60,
          'h' => 3600,
          'd' => 24*3600,
          'w' => 7*24*3600 } -> {$2}
    }
    if ($arg ne "")
    {
        return undef;
    }
    else
    {
        return $seconds;
    }
} # interval2seconds()

