#include "vc.h"

#include "convstr.h"

/*
helper class to auto-converts MBCS/SBCS and DBCS(Unicode)-Strings
*/

clsCharsetConversionString::clsCharsetConversionString(LPCWSTR pszwText)
{
	_pszwText = new WCHAR[wcslen(pszwText)+1];
	wcscpy(_pszwText,pszwText);
	_pszText = NULL;
}

clsCharsetConversionString::clsCharsetConversionString(LPWSTR pszwText)
{
	_pszwText = new WCHAR[wcslen(pszwText)+1];
	wcscpy(_pszwText,pszwText);
	_pszText = NULL;
}

clsCharsetConversionString::clsCharsetConversionString(LPCSTR pszText)
{
	_pszText = new CHAR[strlen(pszText)+1];
	strcpy(_pszText,pszText);
	_pszwText = NULL;
}

clsCharsetConversionString::clsCharsetConversionString(LPSTR pszText)
{
	_pszText = new CHAR[strlen(pszText)+1];
	strcpy(_pszText,pszText);
	_pszwText = NULL;
}

clsCharsetConversionString::~clsCharsetConversionString(void)
{
	Clear();
}

void	clsCharsetConversionString::Clear(void)
{
	delete[] _pszwText;
	_pszwText = NULL;
	delete[] _pszText;
	_pszText = NULL;
}

clsCharsetConversionString::operator LPCWSTR()
{
	if (_pszwText)
		return(_pszwText);
	INT		nOrgLen = strlen(_pszText);
	
	UINT	nLen = MultiByteToWideChar(
		CP_ACP,
		MB_PRECOMPOSED,
		_pszText,
		nOrgLen,
		NULL,
		0);
	_pszwText = new WCHAR[nLen+1];
	MultiByteToWideChar(
		CP_ACP,
		MB_PRECOMPOSED,
		_pszText,
		nOrgLen+1,
		_pszwText,
		nLen+1);
	return(_pszwText);		
}

clsCharsetConversionString::operator LPCSTR()
{
	if (_pszText)
		return(_pszText);
	INT		nOrgLen = wcslen(_pszwText);

	UINT	nLen = WideCharToMultiByte(
		CP_ACP,
		0,
		_pszwText,
		nOrgLen,
		NULL,
		0,
		NULL,
		NULL);
	_pszText = new CHAR[nLen+1];
	WideCharToMultiByte(
		CP_ACP,
		0,
		_pszwText,
		nOrgLen+1,
		_pszText,
		nLen+1,
		NULL,
		NULL);
	return(_pszText);		
}



