#include "vc.h"

/////////////////////////////////////////////////////////////////////////////
// debugging output, sent to combit's DEBWIN2.EXE
// you can modify the code to use a remote debugger or DBWIN.EXE et al.
void		HookDebug(LPCSTR pszFormat, ...)
{
#if DEBUG
	clsThreadProtection	ThreadProtection(__ThreadSyncObject);

	static	HWND	__hWndDebug = NULL;

	#define DEBWIN16CLS             TEXT("ChkClsDebwin16")
	#define ATTACH_DEBWIN16(hwnd)   hwnd = FindWindow(DEBWIN16CLS,NULL)
  	#define SEND_DEBWIN(hwndTo,hwndFrom,s)  SendMessageA(hwndTo,WM_COPYDATA,(WPARAM)hwndFrom,(LPARAM)&s)
	#define DEB_PUTLINE             0       // lpData = line
	
	if (__hWndDebug == NULL)
		{
		ATTACH_DEBWIN16(__hWndDebug);
		}

	static CHAR szText[1024+1];
    va_list 	args;

    va_start(args,pszFormat);
	#if defined(__WATCOMC__)
	    _vbprintf(szText,sizeof(szText),pszFormat,args);
	  #else
	    _vsnprintf(szText,sizeof(szText),pszFormat,args);
	#endif
    va_end(args);
	
    COPYDATASTRUCT CDS;
	BOOL		bUnfinished = FALSE;
	static		CHAR	sLine[256+1];
	CHAR*		pszLine = sLine;
	INT			nLinePos = 0;
	CHAR*		pszText = szText;

    CDS.dwData = DEB_PUTLINE;

	while (*pszText == 0x0d || *pszText == 0x0a)
		++pszText;

	while (*pszText)
		{
		if (pszLine == sLine)
			{
            strcpy(sLine,NAME);
            strcat(sLine,":");

			nLinePos = strlen(sLine);
			pszLine = sLine + nLinePos;
			bUnfinished = FALSE;	
			}
		switch (*pszText)
			{
			case 0x07:
				MessageBeep(0);
				break;
			case 0x0d:
			case 0x0a:
				*pszLine = 0;
                CDS.lpData = sLine;
                CDS.cbData = (pszLine - sLine)+1;
                SEND_DEBWIN(__hWndDebug,0,CDS);
				pszLine = sLine;
				nLinePos = 0;
				if (*(pszText+1) == 0x0d ||
					*(pszText+1) == 0x0a)
					++pszText;
				bUnfinished = FALSE;	
				break;
			default:
				*pszLine++ = *pszText;
				++nLinePos;
				bUnfinished = TRUE;
				break;
			}
		if (nLinePos > 256)
			{
			*pszLine = 0;
            CDS.lpData = sLine;
            CDS.cbData = (pszLine - sLine)+1;
            SEND_DEBWIN(__hWndDebug,0,CDS);
			pszLine = sLine;
			nLinePos = 0;
			bUnfinished = FALSE;
			}
		++pszText;
		}
	if (bUnfinished)
		{
		*pszLine = 0;
        CDS.lpData = sLine;
        CDS.cbData = (pszLine - sLine)+1;
        SEND_DEBWIN(__hWndDebug,0,CDS);
		}
#else
	pszFormat = pszFormat;
#endif		
}

