#include "vc.h"

/////////////////////////////////////////////////////////////////////////////
// global variables

scProcessInfo 	__Process;
HANDLE      	__hMutexForGlobalData = NULL;
HANDLE			__hMutexForAPI = NULL;
HINSTANCE   	__hInstance = NULL;
HANDLE      	__hGlobalData = NULL;
scGlobalData *	__pData = NULL;
BOOL            __bStartingProcess = FALSE;
OSVERSIONINFO	__OSVersionInfo;
BOOL            __bWinNT = TRUE;
UINT32			__nUserParam = 0;
clsThreadSync	__ThreadSyncObject;

/////////////////////////////////////////////////////////////////////////////

BOOL    ProcessAttach(HINSTANCE hInstance)
{
	TCHAR			szModuleNameFromAttach[MAX_PATH];
	TCHAR			szModulePathFromAttach[MAX_PATH];

	__hInstance = hInstance;

	__OSVersionInfo.dwOSVersionInfoSize = sizeof(__OSVersionInfo);
	GetVersionEx(&__OSVersionInfo);
	
	__bWinNT = (__OSVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT);
	
    __hMutexForGlobalData = CreateMutex(NULL,FALSE,TEXT("ChkVc32GSync_") TEXT(NAME));
	__hMutexForAPI = CreateMutex(NULL,FALSE,TEXT("ChkVc32API_") TEXT(NAME));

	__Process._nscProcessInfoVersion = 1;
 
	//  get module name (with and without path!)
	szModulePathFromAttach[0] = 0;
	if (GetModuleFileName(NULL,szModuleNameFromAttach,sizeofTSTR(szModuleNameFromAttach)))
		{
		LPTSTR	pszBS = _tcsrchr(szModuleNameFromAttach,'\\');
		if (pszBS)
			{
			*pszBS = 0;
			_tcscpy(szModulePathFromAttach,szModuleNameFromAttach);
			_tcscpy(szModuleNameFromAttach,pszBS+1);
			}
		}
	  else	
		_tcscpy(szModuleNameFromAttach,TEXT("unknown module"));
	
	CharUpper(szModuleNameFromAttach);

	// use clsCharsetConversionString to make sure it's in the right style (non-unicode
	// even if this DLL is compiled using the UNICODE flag)
	strcpy(__Process._szModule,clsCharsetConversionString(szModuleNameFromAttach));
	strcpy(__Process._szPath,clsCharsetConversionString(szModulePathFromAttach));
	__Process._nThreadID = GetCurrentThreadId();	

	// could have been done using a shared segment 
	// 
	//	#pragma data_seg(".shared")
	//	scGlobalData	GlobalData; 
	//	#pragma data_seg() 
	// and telling the linker that ".shared" is a shared section by adding
	//	SECTIONS 
	//		.shared READ WRITE SHARED
	// to the DEF file, but this is compiler/linker dependent, 
	// so we use the "traditional" memory mapped file

	__hGlobalData = CreateFileMapping((HANDLE)0xffffffff,
        NULL,
        PAGE_READWRITE,
        0,
        sizeof(scGlobalData),
        TEXT("ChkVc32GlobalData") TEXT(NAME));
	__bStartingProcess = (__hGlobalData != NULL) && (GetLastError() != ERROR_ALREADY_EXISTS);

    __pData = (scGlobalData*)MapViewOfFile(__hGlobalData,
        FILE_MAP_WRITE,
        0,
        0,
        sizeof(scGlobalData));

    if (__bStartingProcess)                                           // is first attachment (global!)
        {
		clsVcGlobalMutex	mtx;
		
		if (!mtx.Ok())
			return(0);
			
		__pData->Clear();
						
		mtx.Release();
		
		#if LOCAL_HOOKING_ONLY
		InterceptFunctionsInTask(TRUE);
		#endif
        }
	  else
	  	{
		if (!AskManager(VC_QUEST_CHECKPROCESS,"",""))
			return(FALSE);
		if (!InterceptFunctionsInTask(TRUE))
			return(FALSE);
		}

	return(TRUE);
}


BOOL    ProcessDetach(void)
{
	InterceptFunctionsInTask(FALSE);

    if (__pData &&
		__hMutexForGlobalData &&
		WaitForSingleObject(__hMutexForGlobalData,30000) == WAIT_OBJECT_0) // Make sure nobody accesses the data!
		{
	    UnmapViewOfFile(__pData);
		__pData = NULL;
		}
	if (__hGlobalData)	
	    CloseHandle(__hGlobalData);
	if (__hMutexForGlobalData)
		{
		ReleaseMutex(__hMutexForGlobalData);
	    CloseHandle(__hMutexForGlobalData);
		}
	if (__hMutexForAPI)	
		CloseHandle(__hMutexForAPI);
	
	return(TRUE);
}

/////////////////////////////////////////////////////////////////////////////

/*
EXPLORER.EXE seems to have a bug! When our app terminates, the DLL that is loaded into EXPLORER 
does not get a PROCESS_DETACH although it is being released!

So for initialization/termination we cannot rely on PROCESS_ATTACH/PROCESS_DETACH of LibMain()!
I do this in a global object's constructor and terminator. AND IT WORKS! Strange...
*/
	
class clsInstance
{
public:
	clsInstance(void) 
		{
		ProcessAttach(GetModuleHandle(TEXT(NAME) TEXT(".DLL")));
		};
	~clsInstance(void) 
		{ 
		ProcessDetach();
		}
};

clsInstance	Instance;

long PASCAL LibMain(HINSTANCE /* hInst */, DWORD /* nReason */, LPVOID /*pReserved*/)
{
	return(1);
}

