#define	WINVER			0x400

/////////////////////////////////////////////////////////////////////////////
//--- include Windows declarations
#define WIN32_LEAN_AND_MEAN
#define NOATOM
#define NOGDICAPMASKS
#define NOMETAFILE
#define NOMINMAX
#define NOOPENFILE
#define NORASTEROPS
#define NOSCROLL
#define NOSOUND
#define NOSYSMETRICS
#define NOTEXTMETRIC
#define NOCOMM
#define NOKANJI
#define NOCRYPT
#define NOMCX

#if !defined(NAME)	// defined in the MAKEFILE, for example....
  #define NAME "VC1"
#endif


#include <windows.h>
#include <ole2.h>
#include <shellapi.h>

#ifndef sizeofSTR
  #define	sizeofTSTR(s)		(sizeof(s)/sizeof(TCHAR))
  #define	sizeofSTR(s)		(sizeof(s)/sizeof(CHAR))
  #define	sizeofWSTR(s)		(sizeof(s)/sizeof(WCHAR))
#endif

/////////////////////////////////////////////////////////////////////////////
//--- C RTL
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <process.h>
#include <tchar.h>

/////////////////////////////////////////////////////////////////////////////
//--- C++ RTL and macros to be independent on the explicit list management classes
#if USE_STL
	#if __WATCOMC__
		// disable STL warnings
		#pragma warning 604 10 // must look ahead to determine whether construct is a declaration/type or an expression
		#pragma warning 594 10 // construct resolved as declaration/type
		#pragma warning 433 10 // mangled name for ... has been truncated
	#endif
	#if defined(_MSC_VER)
	  	#include <map>
		#if _MSC_VER > 1020
			using namespace std;
		#endif
	  #else
	  	#include <hash_map>
	#endif
	#define LIST_EMPTY(i_list)		((i_list).empty())
	#define LIST_CONTAINS(i_list,k)	((i_list).count((k)) > 0)
	#define	LIST_FIND(i_list,k,v) 	((v) = (LIST_CONTAINS((i_list),(k)) ? (i_list)[k] : NULL))
	#define	LIST_FORALL(i_list,i_itertype,i_iter) 	\
		i_itertype i_iter; \
		for (i_iter = (i_list).begin(); i_iter != (i_list).end(); ++i_iter)
	#define	ITER_KEY(i_iter)		((*(i_iter)).first)
	#define	ITER_VALUE(i_iter)		((*(i_iter)).second)
	#define LIST_INSERT(i_list,k,v)	(i_list)[(k)] = (v);
	#define LIST_CLEAR(i_list)		(i_list).clear();
	#define LIST_REMOVE(i_list,k)	(i_list).erase(k);
  #else
  	#include <wcskip.h>
  	#include <wcskipit.h>
	#define LIST_EMPTY(i_list)		((i_list).isEmpty())
	#define LIST_CONTAINS(i_list,k)	((i_list).contains((k)))
	#define	LIST_FIND(i_list,k,v)	((v) = ((i_list).find((k),(v)) ? (v) : NULL))
	#define	LIST_FORALL(i_list,i_itertype,i_iter) 	\
		i_itertype i_iter(i_list); \
		while (++i_iter)
	#define	ITER_KEY(i_iter)	 	((i_iter).key())
	#define	ITER_VALUE(i_iter)		((i_iter).value())
	#define LIST_INSERT(i_list,k,v)	(i_list)[(k)] = (v);
	#define LIST_CLEAR(i_list)		(i_list).clear();
	#define LIST_REMOVE(i_list,k)	(i_list).remove(k);
#endif

/////////////////////////////////////////////////////////////////////////////
//--- local declaration files
#include "vc1.h" 

#include "convstr.h"
#include "version.h"

/////////////////////////////////////////////////////////////////////////////

// cbthook.c
LRESULT CALLBACK Hook(INT nCode, WPARAM wParam, LPARAM lParam);

// debug.c
void		HookDebug(LPCSTR pszFormat, ...);

// intercept.c
BOOL 		InterceptFunctionsInTask(BOOL bHook);
FARPROC		InterceptProc(FARPROC pfnProc);

// managerconnection.c
BOOL 		AskManager(INT nEvent, LPCSTR pszDLL, LPCSTR pszParam);

/////////////////////////////////////////////////////////////////////////////
// global data (in memory mapped file)
struct scGlobalData
    {
	public:
		HHOOK			_hHook;
		INT            	_bDisabled;
		HWND			_hWndManager;
		UINT32          _nUserParam;
		
		void			Clear(void) { memset(this,0,sizeof(*this)); }
    };
	
/////////////////////////////////////////////////////////////////////////////
// objects for thread synchronization
class clsThreadSync
	{
	private:
				CRITICAL_SECTION _Crit;
	public:
							clsThreadSync(void)				
								{ 
								InitializeCriticalSection(&_Crit); 
								}
							~clsThreadSync(void)				
								{ 
								DeleteCriticalSection(&_Crit); 
								}

				void		Enter(void)					
								{ 
								EnterCriticalSection(&_Crit);
								}
				void		Leave(void)			   		
								{
								LeaveCriticalSection(&_Crit);
								}
	};

class 	clsThreadProtection
	{
	private:
				clsThreadSync* _pCrit;
	public:
							clsThreadProtection(clsThreadSync& Sync) 	
								{ 
								(_pCrit = &Sync)->Enter(); 
								}
							~clsThreadProtection(void)		  	
								{ 
								_pCrit->Leave(); 
								}
	};
	
/////////////////////////////////////////////////////////////////////////////
// at least the following is LOCAL again....

extern  HANDLE      	__hMutexForGlobalData;
extern  HANDLE      	__hMutexForAPI;
extern  HINSTANCE   	__hInstance;
extern  HANDLE      	__hGlobalData;
extern  scGlobalData *	__pData;
extern  BOOL            __bStartingProcess;
extern	OSVERSIONINFO	__OSVersionInfo;
extern  BOOL            __bWinNT;
extern  scProcessInfo 	__Process;
extern	clsThreadSync	__ThreadSyncObject;

/////////////////////////////////////////////////////////////////////////////
//--- mutex for accessing global data

class clsVcGlobalMutex
	{
	private:
				BOOL            _bOk;
	public:
							clsVcGlobalMutex(void)
								{
								_bOk = FALSE;
								}
							~clsVcGlobalMutex(void)
								{
								if (_bOk)
									ReleaseMutex(__hMutexForGlobalData);
								}

				BOOL            Ok(void)
								{
								if (_bOk)
									return(TRUE);
                                _bOk = WaitForSingleObject(__hMutexForGlobalData,1000) != WAIT_TIMEOUT;
								return(_bOk);
								}
				void			Release(void)
								{
								if (_bOk)
									{
									ReleaseMutex(__hMutexForGlobalData);
									_bOk = FALSE;
									}
								}
	};
	
/////////////////////////////////////////////////////////////////////////////

enum 	enCharset
	{
	CS_NONE,
	CS_SBCS,
	CS_UNI
	};

enum	enFunction
	{
	FCT_END,
	FCT_LOADLIBRARY,
	FCT_LOADLIBRARYEX,
	FCT_GETPROCADDRESS,
	FCT_SHELLEXECUTE,
	FCT_SHELLEXECUTEEX,
	FCT_SHELLLOADINPROC,
	FCT_WINEXEC,
	FCT_CREATEPROCESS,
	FCT_CREATEPROCESSASUSER,
	FCT_COCREATEINSTANCE,
	FCT_COCREATEINSTANCEEX,
	FCT_COGETINSTANCEFROMFILE,
	FCT_COGETINSTANCEFROMISTORAGE,
	FCT_COGETCLASSOBJECT,
	FCT_OLECREATE,
	FCT_OLECREATEEX,
	FCT_OLECREATEFROMFILE,
	FCT_OLECREATEFROMFILEEX,
	FCT_CREATEFILE,
	FCT_COPYFILE,
	FCT_COPYFILEEX,
	FCT_MOVEFILE,
	FCT_MOVEFILEEX,
	FCT_DELETEFILE,
	FCT_REGCREATEKEY,
	FCT_REGCREATEKEYEX,
	FCT_REGOPENKEY,
	FCT_REGOPENKEYEX,
	FCT_REGCLOSEKEY,
	FCT_REGDELETEKEY,
	FCT_REGSETVALUE,
	FCT_REGSETVALUEEX,
	FCT_REGQUERYVALUE,
	FCT_REGQUERYVALUEEX,
	};

struct 	scFunction
	{
	enFunction	_nFunction;
	LPCTSTR		_pszModule;
	LPCSTR		_pszName;
	enCharset	_nCharset;
	UINT		_nParams;
	void*		_pfnOrgAddress;
	};
	
/////////////////////////////////////////////////////////////////////////////

// interceptor.c
void __stdcall Interceptor(scFunction* pFunction, UINT32* pFrame);

/////////////////////////////////////////////////////////////////////////////

