/**** C/C++ constants and function definitions for VC1.DLL ****/

#ifndef VC1_H /* include header only once */
#define VC1_H

#if !defined(WIN32)
  #define WIN32 1
#endif


#ifndef EXPLICIT_TYPES
  #define EXPLICIT_TYPES
  #ifndef INT
    typedef int INT; /* you should comment this out if you have any problems with INT */
  #endif
  #ifndef CHAR
    typedef char CHAR; /* you should comment this out if you have any problems with CHAR */
  #endif
  typedef unsigned char UINT8;
  typedef unsigned short UINT16;
  typedef signed char INT8;
  typedef signed short INT16;
  #ifndef _BASETSD_H_ /* MSVC6 defines these itself in basetsd.h */
    typedef unsigned long UINT32;
    typedef signed long INT32;
  #endif
#endif

#if defined(WIN32) && (!defined(__BORLANDC__) || __BORLANDC__ >= 0x450)
 #include <tchar.h>    /* for wide char support - comment this out if you have no 'tchar.h' */
#endif

#ifndef DLLPROC
  #define DLLPROC WINAPI
#endif
#ifndef DLLCPROC
  #ifdef WIN32
    #define DLLCPROC WINAPIV
   #else
    #define DLLCPROC _far _cdecl
  #endif
#endif

#if !defined(_VC1_) && defined(WIN32)
  #define WINVC1API DECLSPEC_IMPORT
#else
  #define WINVC1API
#endif

/*--- type declarations ---*/

#ifndef LPCTSTR
  #define LPCTSTR                        const TCHAR FAR *
#endif

#ifndef PSCEVENT
  #define PSCEVENT                       scEvent FAR *
#endif

#ifndef PSCPROCESSINFO
  #define PSCPROCESSINFO                 scProcessInfo FAR *
#endif

/*--- constant declarations ---*/

#define VC_VERSION_MAJOR               (1)                 
#define VC_VERSION_MINOR               (2)                 
#define VC_QUEST_CHECKPROCESS          (1)                 
#define VC_EVENT_EXECUTE	     	   (10)                 /* ShellExecute, ShellExecuteEx, WinExec, CreateProcess    param = DOC-Name */
#define VC_EVENT_CREATEOBJECT          (11)                 /* ShellExecute, ShellExecuteEx, all COM/OLE functions       param = CLSID */
#define VC_EVENT_CREATEFILE            (12)                 /* CreateFile, CopyFile, MoveFile        param = Filename */
#define VC_EVENT_FILE                  (13)                 /* CreateFile, CopyFile, MoveFile        param = Filename */
#define VC_EVENT_REGKEY		   	       (14)					/* RegCreateKey[Ex], param = KEY */
#define VC_EVENT_REGVALUE		       (15)					/* RegSetValue[Ex], param = KEY */
#define VC_EVENTMASK				   (0x00000fff)

#define VC_EVENTTYPE_NONE			   (0x00000000)
#define	VC_EVENTTYPE_READ			   (0x00001000)
#define	VC_EVENTTYPE_WRITE			   (0x00002000)			/* also _CREATE */
#define	VC_EVENTTYPE_ENUM			   (0x00004000)
#define	VC_EVENTTYPE_DELETE			   (0x00008000)					
#define VC_EVENTTYPEMASK			   (0x000ff000)

/*--- function declaration ---*/

#ifndef RC_INVOKED

#ifdef __ZTC__ /* Zortech C++ */
#pragma ZTC align 1
#elif __WATCOMC__ > 1000 /* Watcom C++ >= 10.5 */
#pragma pack(push,1)
#elif __BORLANDC__ /* Borland C++ */
#pragma option -a1
#else
#pragma pack(1) /* MS, Watcom <= 10.0, ... */
#endif

#ifdef __cplusplus
extern "C" {
#endif

 #ifndef IMPLEMENTATION
 struct scProcessInfo
     {
     INT     _nscProcessInfoVersion; // 0x0001 for now!
     INT     _nThreadID;    // thread ID
     CHAR   _szModule[36];   // module name (length is best guess)
	 CHAR	_szPath[260+1]; // path of module
     };           
 
 struct scEvent
     {
     INT     _nscEventVersion;   // 0x0001 for now
     UINT32  _nUserParam;      // user parameter of VcInstall
     scProcessInfo _Process;   // see above
     CHAR    _szDLL[8+1+3+1];   // name of DLL which call was hooked
     INT     _nEvent;           // VC_EVENT_
     CHAR    _szParameter[260+1];   // program/IID to check, debugging text, ...
     };
 #endif

#ifdef WIN16
#else  /* ifdef WIN16 */
#endif /* ifdef WIN16 */

WINVC1API UINT     DLLPROC  VcGetVersion
	(
	INT                  nType
	);

WINVC1API INT      DLLPROC  VcInstall
	(
	HWND                 hWnd,
	UINT32               nUserParam
	);

WINVC1API void     DLLPROC  VcUninstall
	(
	void
	);

WINVC1API void     DLLPROC  VcEnable
	(
	BOOL                 bEnable
	);



#ifdef __cplusplus
}
#endif

#ifdef __ZTC__ /* Zortech C++ */
#pragma ZTC align
#elif __WATCOMC__ > 1000 /* Watcom C++ */
#pragma pack(pop)
#elif __BORLANDC__ /* Borland C++ */
#pragma option -a.
#else
#pragma pack() /* MS C++ */
#endif

#endif  /* #ifndef RC_INVOKED */

#endif  /* #ifndef VC1_H */

