#include "vc.h"

#define DEFINE_DLLEXPORT(RET,FCT)	extern "C" RET WINAPI FCT

/////////////////////////////////////////////////////////////////////////////

DEFINE_DLLEXPORT(UINT,VcGetVersion(INT nType))
{
    INT     ret;

    ret = 0;
    switch (nType)
        {
        case VC_VERSION_MAJOR:
            ret = HIWORD(__version);
            break;
        case VC_VERSION_MINOR:
            ret = LOWORD(__version);
            break;
        }
    return(ret);
}

/////////////////////////////////////////////////////////////////////////////

DEFINE_DLLEXPORT(INT,VcInstall(HWND hWndParent, UINT32 nUserParam))
{
	INT					nRet = -1;
		
	if (__pData)
		{
		clsVcGlobalMutex	mtx;
		
		__pData->_hWndManager = hWndParent;
		__pData->_nUserParam = nUserParam;
		__pData->_bDisabled  = 0;

 		if (__pData->_hHook == NULL)
 			{
#if !defined(LOCAL_HOOKING_ONLY)
			__pData->_hHook = SetWindowsHookEx(WH_CBT,(HOOKPROC)Hook,__hInstance,0);
#endif			
			}
		
		nRet = 0;
		}

	return(nRet);
}


DEFINE_DLLEXPORT(void,VcUninstall(void))
{
	if (__pData && 
		__pData->_hHook)
		{
	    UnhookWindowsHookEx(__pData->_hHook);
		__pData->_hHook = NULL;
		}
}

/////////////////////////////////////////////////////////////////////////////

DEFINE_DLLEXPORT(void,VcEnable(BOOL bEnable))
{
	if (__pData)
		{
		clsVcGlobalMutex	mtx;
		
		if (bEnable)
			--__pData->_bDisabled;
		  else	
			++__pData->_bDisabled;
		}
}

