unit framEvent;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, vc1, Rules;

type
  TframeEventData = class(TFrame)
    Label1: TLabel;
    edtModule: TEdit;
    Label2: TLabel;
    edtModulePath: TEdit;
    Label3: TLabel;
    edtDLL: TEdit;
    cmbEvent: TComboBox;
    edtParam: TEdit;
  private
    { Private-Deklarationen }
  public
    procedure SetEvent(r: TRule);
    procedure GetEvent(var r: TRule);
  end;

implementation

{$R *.DFM}

procedure TframeEventData.SetEvent(r: TRule);
begin
  with r._rule._event do
  begin
    edtModule.Text := _Process._szModule;
    edtModulePath.Text := _Process._szPath;
    edtDLL.Text := _szDLL;
    edtParam.Text := _szParameter;
    case _nEvent and VC_EVENTMASK of
      0:
        cmbEvent.ItemIndex := 0;
      VC_QUEST_CHECKPROCESS:
        cmbEvent.ItemIndex := 1;
      VC_EVENT_EXECUTE:
        cmbEvent.ItemIndex := 2;
      VC_EVENT_CREATEOBJECT:
        cmbEvent.ItemIndex := 3;
      VC_EVENT_CREATEFILE:
        cmbEvent.ItemIndex := 4;
      VC_EVENT_FILE:
        case _nEvent and VC_EVENTTYPEMASK of
          VC_EVENTTYPE_READ:
            cmbEvent.ItemIndex := 6;
          VC_EVENTTYPE_WRITE:
            cmbEvent.ItemIndex := 7;
          VC_EVENTTYPE_DELETE:
            cmbEvent.ItemIndex := 8;
        else // including 0
          cmbEvent.ItemIndex := 5;
        end;
      else
        cmbEvent.ItemIndex := 9;
    end;
  end;
end;

procedure TframeEventData.GetEvent(var r: TRule);
begin
  with r._rule._event do
  begin
    StrPCopy(_Process._szModule, edtModule.Text);
    StrPCopy(_Process._szPath, edtModulePath.Text);
    StrPCopy(_szDLL, edtDLL.Text);
    StrPCopy(_szParameter, edtParam.Text);
    case cmbEvent.ItemIndex of
      1:
        _nEvent := VC_QUEST_CHECKPROCESS;
      2:
        _nEvent := VC_EVENT_EXECUTE;
      3:
        _nEvent := VC_EVENT_CREATEOBJECT;
      4:
        _nEvent := VC_EVENT_CREATEFILE;
      5:
        _nEvent := VC_EVENT_FILE;
      6:
        _nEvent := VC_EVENT_FILE or VC_EVENTTYPE_READ;
      7:
        _nEvent := VC_EVENT_FILE or VC_EVENTTYPE_WRITE;
      8:
        _nEvent := VC_EVENT_FILE or VC_EVENTTYPE_DELETE;
      else // including 0, 9, -1
        _nEvent := 0;
    end;
  end;
end;

end.
