' ****************************************************************
' Funktion:      Zeigt die Gren aller Unterordner des gedroppten
'                Ordners in einem Excel-Kreisdiagramm an.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - Excel ab Version 97
' 
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objFS
Dim objFolder
Dim objXL
Dim objSubFolder
Dim intZeile

'Excel-Konstanten
Const xl3DPie = -4102
Const xlColumns = 2
Const xlLocationAsNewSheet = 1
Const xlColorIndexNone = -4142
Const xlLineStyleNone = -4142
Const xlDataLabelsShowValue = 2


On Error Resume Next

Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

Set objFolder = objFS.GetFolder(WScript.Arguments(0))
If objFolder Is Nothing Then
    MsgBox "Kein Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

Set objXL = WScript.CreateObject("Excel.Application")
If objXL Is Nothing Then
    MsgBox "Excel kann nicht gestartet werden.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

With objXL
    .Visible = True
    .WorkBooks.Add

    For Each objSubFolder In objFolder.SubFolders
        intZeile = intZeile + 1
        .ActiveSheet.Cells(intZeile, 1).Value = objSubFolder.Name
        .ActiveSheet.Cells(intZeile, 2).Value = objSubFolder.Size
    Next
    .ActiveSheet.UsedRange.Columns(2).Cells.NumberFormat = "#,##0"

    .Charts.Add
    With .ActiveChart
        '3D-Kreisdiagramm
        .ChartType = xl3DPie
        'Datenquelle: Benutzter Bereich von Tabelle1
        .SetSourceData objXL.Sheets("Tabelle1").UsedRange, xlColumns
        'Als neues Diagrammblatt einfgen
        .Location xlLocationAsNewSheet
        'Diagrammtitel anzeigen
        .HasTitle = True
        'Diagrammtitel festlegen
        .ChartTitle.Characters.Text = "Inhalt von " & objFolder.Path
        'Bei allen Excel-Versionen ab XP...
        If objXL.Version = "10.0" Then
            '... keine Legende anzeigen
            .HasLegend = False
            'Namen und Werte, keine Prozent anzeigen
            .ApplyDataLabels , , , , , True, True, False
        'Bei frheren Excel-Versionen...
        Else
            '... Legende anzeigen
            .HasLegend = True
            'Werte anzeigen
            .ApplyDataLabels xlDataLabelsShowValue        
        End If
        'Kein Hintergrund
        .PlotArea.Interior.ColorIndex = xlColorIndexNone
        'Keine Rahmenlinie
        .PlotArea.Border.LineStyle = xlLineStyleNone
    End With
End With
