' ****************************************************************
' Funktion:      Archiviert gedroppte Dateien oder Ordner in einer
'                ZIP-Datei und fgt diese einer neuen Outlook-
'                Nachricht als Anlage bei.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - Archivprogramm WinZIP ab Version 7.0
'               - Outlook ab Version 2000
'
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objShell
Dim objFS
Dim objSysEnv
Dim strWinZipPfad
Dim strZielOrdner
Dim strZieldatei
Dim objFile
Dim intI
Dim strQuelldatei
Dim intErrCode
Dim objOL
Dim objMail

On Error Resume Next

Set objShell = Wscript.CreateObject("WScript.Shell")
Set objFS = WScript.CreateObject("Scripting.FileSystemObject")
Set objSysEnv = objShell.Environment("PROCESS")

If Wscript.Arguments.Count = 0 Then
    MsgBox "Keine Dateien oder Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

strWinZipPfad = objShell.RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\winzip32.exe\")
If strWinZipPfad = "" Then
    MsgBox "WinZip ist nicht installiert.", vbCritical, Wscript.ScriptName
    WScript.Quit
End If

strZielOrdner = objSysEnv("temp")
If Right(strZielOrdner, 1) <> "\" Then
    strZielOrdner = strZielOrdner & "\"
End If

strZieldatei = strZielOrdner & "Anlagen.zip"
If objFS.FileExists(strZieldatei) Then
    Set objFile = objFS.GetFile(strZieldatei)
    objFile.Delete
End If

For intI = 0 To Wscript.Arguments.Count - 1
    strQuelldatei = Chr(34) & Wscript.Arguments(intI) & Chr(34)
    intErrCode = objShell.Run(strWinZipPfad & " -min -a " & strZieldatei & " " & strQuelldatei, 1, True)
    If intErrCode <> 0 Then
        MsgBox "WinZip-Fehler " & CStr(intErrCode) & " aufgetreten.", vbCritical, Wscript.ScriptName
        WScript.Quit
    End If
Next

Set objOL = WScript.CreateObject("Outlook.Application")
If objOL Is Nothing Then
    MsgBox "Outlook kann nicht gestartet werden.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

Set objMail = objOL.Application.CreateItem(0)
With objMail
    .Attachments.Add strZieldatei
    .Display
End With
