' ****************************************************************
' Funktion:      Leitet die gedroppte (PowerPoint-) Datei an die
'                vorgewhlte (PowerPoint-) Viewer-Anwendung weiter.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - DlgTools.ocx
'               - (PowerPoint-) Viewer
'
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objShell
Dim objFS
Dim objFile
Dim objDlgTools
Dim strRegKey
Dim strViewerApp


On Error Resume Next

Set objShell = Wscript.CreateObject("WScript.Shell")
Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

Set objFile = objFS.GetFile(WScript.Arguments(0))
If objFile Is Nothing Then
    MsgBox "Keine Datei gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

strRegKey = "HKCU\Software\DesktopSkripte\ViewerApp"
strViewerApp = objShell.RegRead(strRegKey)
If objFS.FileExists(strViewerApp) = False Then
    Set objDlgTools = WScript.CreateObject("DesktopSkripte.DlgTools")
    If objDlgTools Is Nothing Then
        MsgBox "DlgTools.ocx ist nicht installiert.", vbInformation, Wscript.ScriptName
        WScript.Quit
    End If
    
    strViewerApp = objDlgTools.DlgOpenSaveFile(1, "Anwendungen", "*.exe", "PPView32.exe", "", "Viewer-Anwendung whlen")
    If objFS.FileExists(strViewerApp) = True Then
        objShell.RegWrite strRegKey, strViewerApp
    Else
        MsgBox "Viewer-Anwendung nicht gefunden.", vbCritical, Wscript.ScriptName
        WScript.Quit
    End If
End If

objShell.Run Chr(34) & strViewerApp & Chr(34) & " " & Chr(34) & objFile.Path & Chr(34)
