import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;

/**
 * c't TicTacToe Midlet
 * @author Karsten Violka, Lars Bremer
 */
public class TicTacToeMidlet extends MIDlet implements CommandListener {
  // Member-Variablen
  private Display display;

  //Kommandos
  private Command exitCommand;
  private Command startCommand;
  private Command optionCommand;

  // Subklassen von Displayable
  private TicCanvas canvas;            // Canvas-Klasse mit Spiel-Logik
  private List optionList;

  // Konstruktor
  public TicTacToeMidlet() {
    canvas = new TicCanvas();

    String[] options  = {"Spieler", "Computer"};
    optionList = new List("hallo",List.EXCLUSIVE, options, null);
    optionList.setTitle("Wer beginnt?");

    exitCommand = new Command("EXIT", Command.EXIT, 1);
    startCommand = new Command("START", Command.SCREEN, 1);
    optionCommand = new Command("Optionen", Command.SCREEN, 1);
    canvas.addCommand(exitCommand);
    canvas.addCommand(startCommand);
    canvas.addCommand(optionCommand);
    canvas.setCommandListener(this);
    optionList.addCommand(startCommand);
    optionList.setCommandListener(this);
  }


  protected void startApp() throws MIDletStateChangeException {
    display = Display.getDisplay(this);
    display.setCurrent(canvas);
    canvas.start(false);
  }

  protected void pauseApp()  {
  }

  protected void destroyApp(boolean parm1) throws MIDletStateChangeException {
  }

  // Implementierung des CommandListener-Interface
  public void commandAction(Command command, Displayable screen) {
    if(command == exitCommand) {
      try {
        destroyApp(false);
      } catch (Exception e) {
        System.out.println("Abbruch fehlgeschlagen: " + e);
      }
      notifyDestroyed();
    }
    if(command == startCommand) {
      display.setCurrent(canvas);
      canvas.start(optionList.getSelectedIndex() == 1); // true: Computer beginnt
    }                                                   // false: Spieler beginnt
    if(command == optionCommand) {
      display.setCurrent(optionList);
    }
    return;
  }
}