// Datei Kreis.cpp

#include <iostream> // fr Kontrollausgaben
#include "Kreis.h"

Kreis::Kreis(double x, double y, double r) throw(std::runtime_error)
: GeomObjekt(x,y) {
  setRadius(r); // nimmt auch Bereichsprfung vor
}

Kreis::~Kreis() {
  std::cout << "Destruktor von ";
  print();
}

void Kreis::print() const {
  std::cout << "Kreis: "
            << getX() << ", " << getY()
            << ", "  << getRadius() << std::endl;
}

double Kreis::getRadius() const { return r_; }

void Kreis::setRadius(double r) throw(std::runtime_error) {
  if(r < 0.0)
    throw std::runtime_error(std::string("negativer Radius"));
  r_ = r;
}
