// Datei kreisbeispiel.cs

using System;

namespace CSharpBeispiel {
  public abstract class GeomObjekt {
    public GeomObjekt(double x, double y) {
      x_ = x; y_ = y;
    }
    public abstract void Print();
    public double X { get { return x_; } }
    public double Y { get { return y_; } }
    private double x_, y_; // Referenzkoordinaten
  }

  public class Kreis : GeomObjekt 
  {
    ///<exception>ArgumentOutOfRangeException</exception>
    public Kreis(double x, double y, double r)
    : base(x, y) {
      Radius = r; // nimmt auch Bereichsprfung vor
    }
    public void Dispose() {
      Console.Write("Dispose() von ");
      Print();
    }
    public override void Print() {
      Console.WriteLine("Kreis: "
                        + X + ", " + Y
                        + ", " + Radius);
    }
    ///<exception>ArgumentOutOfRangeException</exception>
    public double Radius 
    {
      get { return r_; }
      set {
        if(value < 0.0)
          throw new ArgumentOutOfRangeException("r",
                              value, "negativer Radius");
        r_ = value;
      }
    }
    private double r_;
  }

  public class Test {
    static void Main(string[] args) {
      Kreis K = null;
      try {
        K = new Kreis(1.0, 2.0, 3.0); // Referenz-Typ
        K.Radius = 9.0;   // erlaubt
        K.Radius = -10.0; // provoziert Exception
      } catch(Exception e) {
        Console.WriteLine(e);
      } finally {
        if(K != null)
          K.Dispose();
      }
    }
  }
}