VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cSPTI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'*************************************
'**  uCDDB - CDDB Active-X Control  **
'**   (c) 2001 by Jon Zahornacky    **
'*************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' CDDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit

'defines
Private Const OS_UNKNOWN = -1
Private Const OS_WIN95 = 0
Private Const OS_WIN98 = 1
Private Const OS_WINNT35 = 2
Private Const OS_WINNT4 = 3
Private Const OS_WIN2K = 4

'dwPlatformId defines
Private Const VER_PLATFORM_WIN32s = 0
Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32_NT = 2

'IOCTL defines
Private Const IOCTL_SCSI_PASS_THROUGH_DIRECT = &H4D014
Private Const SCSI_IOCTL_DATA_OUT = 0
Private Const SCSI_IOCTL_DATA_IN = 1
Private Const SCSI_IOCTL_DATA_UNSPECIFIED = 2

Private Const FILE_SHARE_READ = &H1
Private Const FILE_SHARE_WRITE = &H2

Private Const GENERIC_READ = &H80000000
Private Const GENERIC_WRITE = &H40000000

Private Const CREATE_NEW = 1
Private Const CREATE_ALWAYS = 2
Private Const OPEN_EXISTING = 3
Private Const OPEN_ALWAYS = 4
Private Const TRUNCATE_EXISTING = 5
Private Const INVALID_HANDLE = -1

Private Type SCSI_PASS_THROUGH_DIRECT
    Length As Integer
    ScsiStatus As Byte
    PathId As Byte
    Id As Byte
    Lun As Byte
    CdbLength As Byte
    SenseLength As Byte
    DataIn As Byte
    DataLength As Long
    TimeOut As Long
    DataPointer As Long
    SensePointer As Long
    Cdb(15) As Byte
    Fill(2) As Byte
End Type

Private Type SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER
    SPTD As SCSI_PASS_THROUGH_DIRECT
    Fill As Long
    SenseBuffer(31) As Byte
End Type

Private Type SECURITY_ATTRIBUTES
    nLength As Long
    lpSecurityDescriptor As Long
    bInheritHandle As Long
End Type

Private Type OVERLAPPED
    Internal As Long
    InternalHigh As Long
    offset As Long
    OffsetHigh As Long
    hEvent As Long
End Type

'API's
Private Declare Function CreateFile Lib "kernel32" _
    Alias "CreateFileA" _
    (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, _
     ByVal dwShareMode As Long, lpSecurityAttributes As SECURITY_ATTRIBUTES, _
     ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, _
     ByVal hTemplateFile As Long) As Long

Private Declare Function DeviceIoControl Lib "kernel32" _
    (ByVal hDevice As Long, ByVal dwIoControlCode As Long, _
     lpInBuffer As Any, ByVal nInBufferSize As Long, _
     lpOutBuffer As Any, ByVal nOutBufferSize As Long, _
     lpBytesReturned As Long, lpOverlapped As OVERLAPPED) As Long

Private Declare Function CloseHandle Lib "kernel32" _
    (ByVal hObject As Long) As Long

'local storage
Private m_TOC As String
Private m_W2k As Boolean
'

'****************
'** Properties **
'****************
Public Property Get GetTOC() As String

    GetTOC = m_TOC
End Property

'*****************************
'** Main processing routine **
'*****************************
Public Function InitMediaToc(ByVal strDrive) As Boolean
    Dim hDrive As Long, lFlags As Long
    Dim sts As Integer, nRet As Long
    Dim SPT As SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER
    Dim sa As SECURITY_ATTRIBUTES
    Dim lReturned As Long
    Dim OL As OVERLAPPED
    Dim TocBuffer As TOC
    Dim i As Integer
    Dim mins As Long, secs As Long, frms As Long
    Dim trks As Integer, offst As Long, s As String

    'process errors here
    On Error GoTo errChk

    'see if SPTI is supported
    If (CheckForSPTI = False) Then GoTo errChk

    'setup for type of IO based on O/S
    lFlags = GENERIC_READ
    If (m_W2k = True) Then lFlags = lFlags Or GENERIC_WRITE

    'get handle to CDROM drive
    hDrive = CreateFile("\\.\" & strDrive, lFlags, FILE_SHARE_READ, _
                        sa, OPEN_EXISTING, 0, 0&)
    
    'if accessable, I/O to read the TOC
    If (hDrive <> INVALID_HANDLE) Then
        SPT.SPTD.Length = Len(SPT.SPTD)
        SPT.SPTD.CdbLength = &HA
        SPT.SPTD.DataIn = SCSI_IOCTL_DATA_IN
        SPT.SPTD.TimeOut = 5
        SPT.SPTD.DataLength = Len(TocBuffer)
        SPT.SPTD.DataPointer = VarPtr(TocBuffer)
        SPT.SPTD.SenseLength = 14
        SPT.SPTD.SensePointer = Len(SPT.SPTD) + Len(SPT.Fill)
        SPT.SPTD.Cdb(0) = &H43    'read TOC command
        SPT.SPTD.Cdb(1) = &H2     'MSF mode
        SPT.SPTD.Cdb(7) = &H3     'high-order byte of buffer len
        SPT.SPTD.Cdb(8) = &H24    'low-order byte of buffer len

        'issue the I/O
        nRet = DeviceIoControl(hDrive, IOCTL_SCSI_PASS_THROUGH_DIRECT, _
                               SPT, Len(SPT), SPT, Len(SPT), _
                               lReturned, OL)
        'free drive ref
        CloseHandle (hDrive)
        
        'failed to read TOC
        If (nRet < 1) Then Exit Function
    End If

    'check if valid TOC present...
    trks = TocBuffer.LastTrack - TocBuffer.FirstTrack + 1
    If (TocBuffer.LastTrack = 0 And TocBuffer.FirstTrack = 0) Or _
       (trks < 1) Then Exit Function

    'compute running offsets / verify an audio CD
     sts = 0
     For i = 0 To trks
         mins = TocBuffer.TocTrack(i).Addr(1)
         secs = TocBuffer.TocTrack(i).Addr(2)
         frms = TocBuffer.TocTrack(i).Addr(3)
         
         offst = (mins * 60 * 75) + (secs * 75) + frms
         s = s & " " & Format$(offst)
         
         'FLAG if audio track found
         If (TocBuffer.TocTrack(i).ADR = &H10) Then sts = 1
     Next i

     'failed if no audio tracks...
     If (sts = 0) Then Exit Function

    'good TOC
    m_TOC = Trim$(s)
    InitMediaToc = True
    Exit Function

errChk:
    If (hDrive <> 0) Then CloseHandle (hDrive)
    InitMediaToc = False
End Function

'******************************
'** Check for SPTI interface **
'******************************
Private Function CheckForSPTI() As Boolean
    Dim osVer As OSVERSIONINFO

    'get OS version
    osVer.dwOSVersionInfoSize = Len(osVer)
    GetVersionEx osVer

    'must be: NT platform Vers 4.0+, and must know if W2k+
    If (osVer.dwPlatformId = VER_PLATFORM_WIN32_NT) Then
       If (osVer.dwMajorVersion >= 4) Then CheckForSPTI = True
       If (osVer.dwMajorVersion >= OS_WIN2K) Then m_W2k = True
    End If
End Function

