VERSION 5.00
Begin VB.UserControl uFREEDB 
   ClientHeight    =   1548
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2832
   InvisibleAtRuntime=   -1  'True
   LockControls    =   -1  'True
   ScaleHeight     =   1548
   ScaleWidth      =   2832
   ToolboxBitmap   =   "ctlFREEDB.ctx":0000
   Windowless      =   -1  'True
   Begin VB.Image Image1 
      Height          =   372
      Left            =   0
      Picture         =   "ctlFREEDB.ctx":0312
      Top             =   0
      Visible         =   0   'False
      Width           =   1056
   End
End
Attribute VB_Name = "uFREEDB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "PropPageWizardRun" ,"Yes"
'***************************************
'**  uFREEDB - CDDB Active-X Control  **
'**    (c) 2001 by Jon Zahornacky     **
'***************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' FREEDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit

'FuzzyMatch Form handle
Dim frmFuzzy As frmFuzzyMatch
Dim frmSubmit As frmSubmitInfo

'Default Freedb Server to use
Const CDDB_SERVER As String = "freedb.freedb.org"

'Events
Public Event ProtocolError(ByVal Number As Long, ByVal Message As String)

'Enums
Public Enum uCDDBIfc
    AUTO
    SPTI
    ASPI
    MCI
End Enum

Public Enum uCDDBMode
    TEST
    SUBMIT
End Enum

Public Enum uCDDBMatchCode
    MATCH_NONE
    MATCH_MULTIPLE
    MATCH_EXACT
End Enum

Public Type uCDDBTracks
    Title       As String
    Length      As Integer
End Type

Public Type uCddbDisc
    MediaTOC    As String
    MediaID     As String
    ArtistName  As String
    AlbumName   As String
    AlbumGenre  As String
    AlbumLength As Integer
    AlbumTracks As Integer
    AlbumNotes  As String
    AlbumYear   As String
    Tracks()    As uCDDBTracks
End Type

Private colTrackNames   As Collection
Private colTrackTimes   As Collection

'properties management
Private strAppName      As String
Private strAppVer       As String
Private enumCDDBIfc     As uCDDBIfc
Private enumCDDBMode    As uCDDBMode
Private strCDDBServer   As String
Private strUserEmail    As String

Private m_QueryString   As String
Private m_frmLocTop     As Long
Private m_frmLocLeft    As Long
Private m_UseFirstMatch As Boolean
Private m_AllowSubmit   As Boolean

Private m_MatchCode     As uCDDBMatchCode

Private m_MediaTOC      As String
Private m_strMediaId    As String
Private m_strArtistName As String
Private m_strAlbumName  As String
Private m_strGenre      As String
Private m_AlbumSeconds  As Integer
Private m_Tracks        As Integer
Private m_Notes         As String
Private m_Year          As String
'

'****************
'** Properties **
'****************
Public Property Get GetMediaID() As String
    GetMediaID = m_strMediaId
End Property

Public Property Get GetArtistName() As String
    GetArtistName = m_strArtistName
End Property

Public Property Get GetAlbumName() As String
    GetAlbumName = m_strAlbumName
End Property

Public Property Get GetAlbumGenre() As String
    GetAlbumGenre = m_strGenre
End Property

Public Property Get GetAlbumLength() As Long
    GetAlbumLength = m_AlbumSeconds
End Property

Public Property Get GetAlbumTracks() As Long
    GetAlbumTracks = m_Tracks
End Property

Public Property Get GetAlbumNotes() As String
    GetAlbumNotes = m_Notes
End Property

Public Property Get GetAlbumYear() As String
    GetAlbumYear = m_Year
End Property

Public Property Get GetTrackName(idx As Integer) As String
Attribute GetTrackName.VB_Description = "Returns the name of the specified track."
    
    GetTrackName = ""
    If (idx > 0 And idx <= colTrackNames.Count) Then
        GetTrackName = colTrackNames(idx)
    End If
End Property

Public Property Get GetTrackTime(idx As Integer) As Integer
    
    GetTrackTime = 0
    If (idx > 1 Or idx <= colTrackTimes.Count) Then
        GetTrackTime = colTrackTimes(idx)
    End If
End Property

'******************************************
'** wrap up info into CddbDisc Structure **
'******************************************
Public Property Get GetMatchedDiscInfo() As uCddbDisc
    Dim idx As Integer
    
    'disc info
    GetMatchedDiscInfo.MediaTOC = m_MediaTOC
    GetMatchedDiscInfo.MediaID = m_strMediaId
    
    If (m_MatchCode <> MATCH_NONE) Then
        GetMatchedDiscInfo.ArtistName = m_strArtistName
        GetMatchedDiscInfo.AlbumName = m_strAlbumName
        GetMatchedDiscInfo.AlbumGenre = m_strGenre
        GetMatchedDiscInfo.AlbumLength = m_AlbumSeconds
        GetMatchedDiscInfo.AlbumTracks = m_Tracks
        GetMatchedDiscInfo.AlbumNotes = m_Notes
        GetMatchedDiscInfo.AlbumYear = m_Year

        'track info
        If (m_Tracks > 0) Then
            ReDim GetMatchedDiscInfo.Tracks(1 To m_Tracks)
            For idx = 1 To m_Tracks
                If idx <= colTrackNames.Count Then
                    GetMatchedDiscInfo.Tracks(idx).Title = colTrackNames(idx)
                End If
                If idx <= colTrackTimes.Count Then
                    GetMatchedDiscInfo.Tracks(idx).Length = colTrackTimes(idx)
                End If
            Next
        End If
    End If
End Property

'*********************************
'** Calculate Media ID from TOC **
'*********************************
Public Property Get CalMediaID(ByVal MediaTOC As String) As String
    Dim idx As Integer, sum As Long, tmp As Long
    Dim tTracks As Integer, tAlbumSeconds As Integer
    Dim tMediaTOC As String, strTocData() As String
    
    'trim leading and trailing blanks
    tMediaTOC = Trim$(MediaTOC)

    'check empty string and at least start of 2 tracks (trk + leadout)
    If (tMediaTOC = "" Or InStr(1, tMediaTOC, " ") = 0) Then Exit Property
    
    'breakdown the string into individual elements
    strTocData = Split(tMediaTOC, " ", 100, vbTextCompare)

    'construct MEDIA ID
    tTracks = UBound(strTocData)

    'album time in seconds
    tAlbumSeconds = (Val(strTocData(tTracks)) \ 75) - (Val(strTocData(0)) \ 75)

    'generate CDid
    For idx = 0 To tTracks - 1
        tmp = Val(strTocData(idx)) \ 75

        Do While tmp > 0
            sum = sum + (tmp Mod 10)
            tmp = tmp \ 10
        Loop
    Next idx

    'format...
    CalMediaID = LCase$(LeftZeroPad(Hex$(sum Mod &HFF), 2) & _
                        LeftZeroPad(Hex$(tAlbumSeconds), 4) & _
                        LeftZeroPad(Hex$(tTracks), 2))
End Property

'*************************************************
'** Take First Match or PopUp FuzzyMatch Dialog **
'*************************************************
Public Property Let UseFirstMatch(FirstMatch As Boolean)
    m_UseFirstMatch = FirstMatch
End Property

'****************************************
'** Allow Submission to Freedb Service **
'****************************************
Public Property Let AllowSubmission(AllowSubmit As Boolean)
    m_AllowSubmit = AllowSubmit
End Property

'************************************
'** PopUp Dialogs Location control **
'************************************
Public Property Let PopUpLocTop(Top As Long)
    m_frmLocTop = Top
End Property

Public Property Let PopUpLocLeft(Left As Long)
    m_frmLocLeft = Left
End Property

'*************************
'** Extender Properties **
'*************************
Public Property Get AppName() As String
    AppName = strAppName
End Property

Public Property Let AppName(strName As String)
    strAppName = strName
    PropertyChanged AppName
End Property

Public Property Get AppVersion() As String
    AppVersion = strAppVer
End Property

Public Property Let AppVersion(strVer As String)
    strAppVer = strVer
    PropertyChanged AppVersion
End Property

Public Property Get CDDBServer() As String
    CDDBServer = strCDDBServer
End Property

Public Property Let CDDBServer(strServer As String)
    strCDDBServer = strServer
    PropertyChanged CDDBServer
End Property

Public Property Get CDDBInterface() As uCDDBIfc
    CDDBInterface = enumCDDBIfc
End Property

Public Property Let CDDBInterface(eIFC As uCDDBIfc)
    enumCDDBIfc = eIFC
    PropertyChanged CDDBInterface
End Property

Public Property Get CDDBMode() As uCDDBMode
    CDDBMode = enumCDDBMode
End Property

Public Property Let CDDBMode(eMode As uCDDBMode)
    enumCDDBMode = eMode
    PropertyChanged CDDBMode
End Property

Public Property Get EmailAddress() As String
    EmailAddress = strUserEmail
End Property

Public Property Let EmailAddress(strEmail As String)
    strUserEmail = strEmail
    PropertyChanged EmailAddress
End Property

'*************
'** Methods **
'*************

'***********************************************
'** Return formatted time string from seconds **
'***********************************************
Public Function SecondsToTimeString(Seconds As Integer) As String
    Dim iMin As Integer
    Dim iSec As Integer
    
    'convert to min:sec string
    iMin = Seconds \ 60
    iSec = Seconds Mod 60
    
    'format it...
    SecondsToTimeString = iMin & ":" & Format(iSec, "00")
End Function

'****************************************
'** BSTR GetMediaToc (STR DriveLetter) **
'****************************************
Public Function GetMediaTOC(ByVal DriveLetter As String) As String
    Dim oCD As Object

    'process errors
    On Error GoTo errChk

    'trim leading and trailing blanks and add colon
    DriveLetter = Trim(DriveLetter) & ":"

    'AUTO tries all interfaces
    If (enumCDDBIfc = AUTO) Or (enumCDDBIfc = SPTI) Then
        'SPTI (SCSI Pass Thru Inteface) is preferred
        Set oCD = New cSPTI
    
        'try to read with SPTI interface
        If (oCD.InitMediaToc(DriveLetter) = True) Then
            GetMediaTOC = oCD.GetTOC
            Set oCD = Nothing
            Exit Function
        End If
    End If

    'AUTO tries all interfaces
    If (enumCDDBIfc = AUTO) Or (enumCDDBIfc = ASPI) Then
        'ASPI is OK, if SPTI fails
        Set oCD = New cASPI
    
        'try to read with ASPI interface
        If (oCD.InitMediaToc(DriveLetter) = True) Then
            GetMediaTOC = oCD.GetTOC
            Set oCD = Nothing
            Exit Function
        End If
    End If

    'AUTO tries all interfaces
    If (enumCDDBIfc = AUTO) Or (enumCDDBIfc = MCI) Then
        'otherwise fallback to MCI
        Set oCD = New cMCI
    
        'try to read with MCI interface
        If (oCD.InitMediaToc(DriveLetter)) Then
            GetMediaTOC = oCD.GetTOC
            Set oCD = Nothing
            Exit Function
        End If
    End If

errChk:
    Set oCD = Nothing
End Function

'****************************************************
'** uCDDBMatchCode LookupMediaByToc (STR MediaToc) **
'****************************************************
Public Function LookupMediaByToc(ByVal MediaTOC As String) As uCDDBMatchCode
    Dim idx As Integer
    Dim sum As Long, tmp As Long
    Dim strTocData() As String

    'process errors
    On Error GoTo errChk

    'init the Media Params
    ResetVariables

    'trim leading and trailing blanks
    m_MediaTOC = Trim$(MediaTOC)

    'check empty string and at least start of 2 tracks (trk + leadout)
    If (m_MediaTOC = "" Or InStr(1, m_MediaTOC, " ") = 0) Then Exit Function
    
    'breakdown the string into individual elements
    strTocData = Split(m_MediaTOC, " ", 100, vbTextCompare)

    'construct MEDIA ID
    m_Tracks = UBound(strTocData)

    'track times in seconds
    For idx = 1 To m_Tracks
        colTrackTimes.Add (Val(strTocData(idx)) - Val(strTocData(idx - 1))) \ 75
    Next

    'album time in seconds
    m_AlbumSeconds = (Val(strTocData(m_Tracks)) \ 75) - (Val(strTocData(0)) \ 75)

    'generate CDid
    For idx = 0 To m_Tracks - 1
        tmp = Val(strTocData(idx)) \ 75

        Do While tmp > 0
            sum = sum + (tmp Mod 10)
            tmp = tmp \ 10
        Loop
    Next idx

    'format...
    m_strMediaId = LCase$(LeftZeroPad(Hex$(sum Mod &HFF), 2) & _
                          LeftZeroPad(Hex$(m_AlbumSeconds), 4) & _
                          LeftZeroPad(Hex$(m_Tracks), 2))

    'start to build query string for lookup...
    m_QueryString = m_strMediaId & "+" & m_Tracks

    'add start of each track
    For idx = 0 To m_Tracks - 1
        m_QueryString = m_QueryString & "+" & strTocData(idx)
    Next

    'add len in seconds
    m_QueryString = m_QueryString & "+" & (Val(strTocData(m_Tracks)) \ 75)

    'lookup on CDDB service
    QueryCddb
    
    'return match status
    LookupMediaByToc = m_MatchCode
    Exit Function

errChk:
    m_MatchCode = MATCH_NONE
    LookupMediaByToc = m_MatchCode
End Function

'clears all data storage
Private Sub ResetVariables()
    Dim idx As Integer

    'album info
    m_strArtistName = ""
    m_strAlbumName = ""
    m_strGenre = ""
    m_AlbumSeconds = 0
    m_Tracks = 0
    m_Notes = ""
    m_Year = ""
    m_MatchCode = MATCH_NONE

    ReDim strTemp(0)
    ReDim strTemp2(0)
    
    'Clear collections
    For idx = 1 To colTrackNames.Count
        colTrackNames.Remove 1
    Next idx
    For idx = 1 To colTrackTimes.Count
        colTrackTimes.Remove 1
    Next idx
End Sub

'left zero pad string to requested length
Private Function LeftZeroPad(s As String, n As Integer) As String

    If Len(s) < n Then
        LeftZeroPad = String$(n - Len(s), "0") & s
    Else
        LeftZeroPad = s
    End If
End Function

'********************
'** Query Routines **
'********************

'**************************************
'** Query the CDDB database via HTTP **
'**************************************
Private Sub QueryCddb()
    Dim strEmail() As String
    Dim strAppMod As String
    Dim strPreURL As String
    Dim strPostURL As String
    Dim strText As String

    'process errors here
    On Error GoTo errChk

    'trim and split User Email
    strUserEmail = Trim$(strUserEmail)
    'validate - got a "@" and a "." and no imbedded spaces
    If InStr(1, strUserEmail, "@", vbTextCompare) > 0 And _
       InStr(1, strUserEmail, ".", vbTextCompare) > 0 And _
       InStr(1, strUserEmail, " ", vbTextCompare) < 1 Then
        'split to: name / domain
        strEmail = Split(strUserEmail, "@", , vbTextCompare)
    Else
        Exit Sub
    End If

    'must be no spaces in the App Name
    strAppMod = Replace(Trim$(strAppName), " ", "-", vbTextCompare)

    'pre-build query URL fragments
    strPreURL = "http://" & strCDDBServer & "/~cddb/cddb.cgi/?cmd="
    strPostURL = "&hello=" & strEmail(0) & "+" & strEmail(1) & "+" & _
                 strAppMod & "+" & strAppVer & "&proto=5"

    'send & parse QUERY request
    strText = OpenURL(strPreURL & "cddb+query+" & m_QueryString & strPostURL)
    
    If (strText <> "") Then
        'decode the Query results
        ParseQueryMessage (strText)
        
        If (m_MatchCode <> MATCH_NONE) Then
            'match, get details...
            strText = OpenURL(strPreURL & "cddb+read+" & m_strGenre & _
                              "+" & m_strMediaId & strPostURL)
            
            If (strText <> "") Then
                'decode the Read results
                ProcessReadMessage (strText)
                Exit Sub
            End If
        
        Else
            If (m_AllowSubmit = True) Then
                'prompt for input...
                strText = GetSubmissionData
                
                If (strText <> "") Then
                    'must be right!
                    m_MatchCode = MATCH_EXACT

                    'decode the Read results
                    ProcessReadMessage ("210" & strText)
                    Exit Sub
                End If
            End If
        End If
    End If

errChk:
    m_MatchCode = MATCH_NONE
End Sub

'*******************************
'** OpenURL by using WinAPI's **
'*******************************
Private Function OpenURL(ByVal sUrl As String) As String
    Dim hOpen       As Long
    Dim hOpenUrl    As Long
    Dim lBytesRead  As Long
    Dim strBuffer   As String * 2048
    Dim strData     As String

    'process errors here
    On Error GoTo errChk

    'init the internet DLL via registry
    hOpen = InternetOpen("uFreedb", INTERNET_OPEN_TYPE_PRECONFIG, vbNullString, vbNullString, 0)
    
    If (hOpen <> 0) Then
        'open the URL for reading (GET)
        hOpenUrl = InternetOpenUrl(hOpen, sUrl, vbNullString, 0, INTERNET_FLAG_RELOAD, 0)

        If (hOpenUrl <> 0) Then
            'read in the returned info...
            Do
                strBuffer = vbNullString
                Call InternetReadFile(hOpenUrl, strBuffer, Len(strBuffer), lBytesRead)
                strData = strData & Left$(strBuffer, lBytesRead)
            Loop Until (lBytesRead = 0)

            InternetCloseHandle (hOpenUrl)
        
        'failed hOpenUrl...
        Else
            RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
        End If

        InternetCloseHandle (hOpen)
    
    'failed hOpen...
    Else
        RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
    End If

    'return the data
    OpenURL = strData
    Exit Function

errChk:
    'internal error
    RaiseEvent ProtocolError(0, "UnKnown Error")

    'closing root handle closes all handles...
    If (hOpen <> 0) Then InternetCloseHandle (hOpen)
End Function

'
'need a case else, and a return code.  if no match on a case, flag as protocol error
'
Private Sub ParseQueryMessage(ByVal strText As String)
    Dim sel As Integer
    Dim strTmp As String
    Dim strTemp() As String

    'process errors here
    On Error Resume Next

    'get "code"
    Select Case Val(Left$(strText, 3))

        Case 200
            'exact match, read details
            m_MatchCode = MATCH_EXACT
            
            'get genre
            m_strGenre = Mid$(strText, 5, InStr(5, strText, " ", vbTextCompare) - 5)

        Case 202
            'couldn't find CD-ID from CDDB "cddb query" command
            m_MatchCode = MATCH_NONE

        Case 210, 211
            'multiple matches, select one - then read details
            m_MatchCode = MATCH_MULTIPLE
            
            'if user wants first hit...
            If (m_UseFirstMatch = True) Then
                'default selection is the first one returned
                sel = 1
            
            'if user wants FuzzyMatch dialog...
            Else
                'request selection from user
                sel = GetUserSelection(strText)
                If (sel = 0) Then               '"0" = submission request...
                    m_MatchCode = MATCH_NONE
                    Exit Sub
                End If
            End If
            
            'breakdown message
            strTemp = Split(strText, vbCrLf)

            'get genre...
            m_strGenre = Left$(strTemp(sel), InStr(1, strTemp(sel), " ", vbTextCompare) - 1)

            'find the first space...
            strTmp = InStr(1, strTemp(sel), " ", vbTextCompare) + 1
            'Media Id string is until second space...
            m_strMediaId = Mid$(strTemp(sel), strTmp, InStr(strTmp, strTemp(sel), " ", vbTextCompare) - strTmp)
    
    End Select
End Sub

Private Function GetUserSelection(ByVal strText As String) As Integer
    Dim idx As Integer
    Dim strTmp As String
    Dim strTemp() As String

    'process errors here
    On Error Resume Next

    'breakdown message
    strTemp = Split(strText, vbCrLf)

    'populate it
    For idx = 1 To UBound(strTemp)
        'entry until terminating "."
        If strTemp(idx) = "." Then Exit For

        'find first space location
        strTmp = InStr(1, strTemp(idx), " ", vbTextCompare) + 1
        'find second space location
        strTmp = InStr(strTmp, strTemp(idx), " ", vbTextCompare) + 1
        'get info on album and add to FuzzyMatch dialog
        strTmp = Mid$(strTemp(idx), strTmp, Len(strTemp(idx)) - strTmp + 1)
        frmFuzzy.lstList.AddItem (strTmp)
    Next

    'dialog position control...
    frmFuzzy.Top = m_frmLocTop
    If (frmFuzzy.Top = 0) Then
        frmFuzzy.Top = Screen.Height / 2 - frmFuzzy.Height / 2
    End If
    frmFuzzy.Left = m_frmLocLeft
    If (frmFuzzy.Left = 0) Then
        frmFuzzy.Left = Screen.Width / 2 - frmFuzzy.Width / 2
    End If
                
    'instantiate FuzzyMatch Dialog and get user selection
    GetUserSelection = frmFuzzy.GetSelection(m_AllowSubmit)
End Function

Private Sub ProcessReadMessage(ByVal strText As String)
    Dim idx As Integer
    Dim lstTrk As String
    Dim tmpTrk As String
    Dim strTmp As String
    Dim strTemp() As String
    Dim strTemp2() As String

    'process errors here
    On Error Resume Next

    'get "code"
    Select Case Val(Left$(strText, 3))

        Case 210
           'breakdown message
            strTemp = Split(strText, vbCrLf)
            
            For idx = 0 To UBound(strTemp)
                'entry until terminating "."
                If strTemp(idx) = "." Then Exit For

                'year info
                If InStr(1, strTemp(idx), "DYEAR=", vbTextCompare) Then
                    m_Year = Mid(strTemp(idx), 7, Len(strTemp(idx)) - 6)
                End If

                'genre info
                If InStr(1, strTemp(idx), "DGENRE=", vbTextCompare) Then
                    If (Mid(strTemp(idx), 8, Len(strTemp(idx)) - 7) <> "") Then
                        m_strGenre = Mid(strTemp(idx), 8, Len(strTemp(idx)) - 7)
                    End If
                End If

                'artist/album info
                If InStr(1, strTemp(idx), "DTITLE=", vbTextCompare) Then
                    'extract artist / album
                    strTmp = Mid(strTemp(idx), 8, Len(strTemp(idx)) - 7)
                    'split based on "/"
                    strTemp2$ = Split(strTmp, " / ")
                    'recover each, catch empty value...
                    m_strArtistName = strTemp2(0)
                    If Err Then m_strArtistName = ""
                    m_strAlbumName = strTemp2(1)
                    If Err Then m_strAlbumName = m_strArtistName   'punt
                End If
            
                'track title info
                If InStr(1, strTemp(idx), "TTITLE", vbTextCompare) Then
                    'position of "=" in string
                    strTmp = InStr(1, strTemp(idx), "=", vbTextCompare)

                    'verify TTITLEn is unique...
                    If (lstTrk <> Mid$(strTemp(idx), strTmp - 1, 1)) Then
                        'update pointer to current entry
                        lstTrk = Mid$(strTemp(idx), strTmp - 1, 1)

                        'extract track name and add to collection
                        strTmp = Mid$(strTemp(idx), strTmp + 1, Len(strTemp(idx)) - strTmp)
                        colTrackNames.Add strTmp

                    'additional info on same track detected...
                    Else
                        'extract track name and concatenate track collection
                        strTmp = Mid$(strTemp(idx), strTmp + 1, Len(strTemp(idx)) - strTmp)
                        
                        'save current info, remove, and add additional info
                        tmpTrk = colTrackNames(colTrackNames.Count)
                        colTrackNames.Remove (colTrackNames.Count)
                        colTrackNames.Add (tmpTrk & strTmp)
                    End If
                End If

                'notes info
                If InStr(1, strTemp(idx), "EXTD=", vbTextCompare) Then
                    m_Notes = m_Notes & Mid(strTemp(idx), 6, Len(strTemp(idx)) - 5)
                End If
            Next

            'clean up
            If (m_Notes <> "") Then m_Notes = Replace(m_Notes, "\n", vbCrLf)

        Case 401
            'Couldn't find CD ID in CDDB "cddb read" command
            If InStr(1, strText, " No such CD entry", vbTextCompare) Then
                m_MatchCode = MATCH_NONE
            End If

    End Select
End Sub

'**************************************
'** Prompt user for Submission input **
'**************************************
Private Function GetSubmissionData() As String
    Dim iPos As Integer
    Dim strCat As String
    Dim strInfo As String
    Dim strText As String
    Dim bRet As Boolean

    'process errors here
    On Error Resume Next

    'frmSubmit - dialog position control...
    frmSubmit.Top = m_frmLocTop
    If (frmSubmit.Top = 0) Then
        frmSubmit.Top = Screen.Height / 2 - frmSubmit.Height / 2
    End If
    frmSubmit.Left = m_frmLocLeft
    If (frmSubmit.Left = 0) Then
        frmSubmit.Left = Screen.Width / 2 - frmSubmit.Width / 2
    End If
          
    'ask user for submit data...
    strText = frmSubmit.SubmitData(m_MediaTOC, m_strMediaId, _
                                   strAppName & " " & strAppVer)
    'split Catagory and Submit Info
    iPos = InStr(1, strText, "*", vbTextCompare)
    strCat = Left$(strText, iPos - 1)
    strInfo = Right$(strText, Len(strText) - iPos)

    If (strText <> "") Then
        'send submission via API's
        bRet = SubmitFreedb(strCat, strInfo)

        'good submission, return info to calling application
        If (bRet) Then
            GetSubmissionData = strInfo
        End If
    End If
End Function

'**********************************
'** Send info to Freedb Database **
'**********************************
Private Function SubmitFreedb(ByVal strCat As String, ByVal strInfo As String)
    Dim hOpen As Long
    Dim hConnect As Long
    Dim hRequest As Long
    Dim strHeaders As String
    Dim strResponse As String
    Dim lResponseLen As Long
    Dim bRet As Boolean

    'process errors here
    On Error GoTo errChk

    'init the internet DLL via registry
    hOpen = InternetOpen("uFreedb", INTERNET_OPEN_TYPE_PRECONFIG, vbNullString, vbNullString, 0)
    
    If (hOpen <> 0) Then
        'Type of service to access.
        hConnect = InternetConnect(hOpen, strCDDBServer, INTERNET_DEFAULT_HTTP_PORT, _
                                    vbNullString, "HTTP/1.0", INTERNET_SERVICE_HTTP, 0, 0)

        If (hConnect <> 0) Then
            hRequest = HttpOpenRequest(hConnect, "POST", "/~cddb/submit.cgi", "HTTP/1.0", _
                                        vbNullString, 0, INTERNET_FLAG_RELOAD, 0)
            'build headers for post...
            strHeaders = "Category: " & strCat & vbCrLf & _
                         "Discid: " & m_strMediaId & vbCrLf & _
                         "User-Email: " & strUserEmail & vbCrLf & _
                         "Submit-Mode: " & IIf(enumCDDBMode = TEST, "test", "submit") & vbCrLf & _
                         "X-Cddbd-Note: " & strAppName & " " & strAppVer & vbCrLf & _
                         "Content-Length: " & CStr(Len(strInfo)) & vbCrLf

            'now submit it...
            If (hRequest <> 0) Then
                bRet = HttpSendRequest(hRequest, strHeaders, Len(strHeaders), _
                                       strInfo, Len(strInfo))
                If (bRet) Then
                    'get server status
                    strResponse = String(100, vbNull)
                    bRet = HttpQueryInfo(hRequest, HTTP_QUERY_STATUS_CODE, _
                                         strResponse, Len(strResponse), 0)
                    'return status
                    If (strResponse = 200) Then SubmitFreedb = True

                'failed to send request...
                Else
                    RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
                End If
                
                bRet = InternetCloseHandle(hRequest)
            
            'failed hRequest...
            Else
                RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
            End If
        
            bRet = InternetCloseHandle(hConnect)
        
        'failed hConnect
        Else
            RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
        End If
     
        bRet = InternetCloseHandle(hOpen)
    
    'failed hOpen...
    Else
        RaiseEvent ProtocolError(Err.LastDllError, ErrDesc(Err.LastDllError))
    End If
    
    'good submission
    Exit Function

errChk:
    'internal error
    RaiseEvent ProtocolError(0, "UnKnown Error")

    'closing root handle closes all handles...
    If (hOpen <> 0) Then InternetCloseHandle (hOpen)
End Function

'****************************************
'** convert error number to error text **
'****************************************
Public Function ErrDesc(ByVal ErrNo As Long) As String
    Dim hLoad As Long
    Dim nRet As Long
    Dim strMsg As String * 512

    'load the error messages to parse...
    hLoad = LoadLibraryEx("wininet.dll", 0&, 2&)

    'lookup error string
    nRet = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM Or FORMAT_MESSAGE_IGNORE_INSERTS Or _
                         FORMAT_MESSAGE_FROM_HMODULE Or FORMAT_MESSAGE_MAX_WIDTH_MASK, _
                         ByVal hLoad, ErrNo, 0&, strMsg, Len(strMsg), ByVal 0&)
    If nRet Then
        ErrDesc = Left$(strMsg, nRet)
    Else
        ErrDesc = "UnKnown Error"
    End If

    'Release library
    If (hLoad <> 0) Then Call FreeLibrary(hLoad)
End Function

'*******************************
'** Control specific routines **
'*******************************
Private Sub UserControl_Initialize()

    'init forms and collections
    Set frmFuzzy = New frmFuzzyMatch
    Set frmSubmit = New frmSubmitInfo
    Set colTrackNames = New Collection
    Set colTrackTimes = New Collection

    m_frmLocTop = 0
    m_frmLocLeft = 0
    m_UseFirstMatch = True
    m_AllowSubmit = True

    'to display on designer...
    UserControl.Picture = Image1.Picture
End Sub

'Set control size to "freedb" graphic size
Private Sub UserControl_Resize()

    UserControl.Width = Image1.Width
    UserControl.Height = Image1.Height
End Sub

'Init control on form placement
Private Sub UserControl_InitProperties()

    strAppName = App.Title
    strAppVer = App.Major & "." & App.Minor
    enumCDDBIfc = AUTO
    enumCDDBMode = TEST
    strCDDBServer = CDDB_SERVER
    strUserEmail = ""
End Sub

'Get property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
   
    strAppName = PropBag.ReadProperty("AppTitle", App.Title)
    strAppVer = PropBag.ReadProperty("AppVer", App.Major & "." & App.Minor)
    enumCDDBIfc = PropBag.ReadProperty("CDDBIfc", AUTO)
    enumCDDBMode = PropBag.ReadProperty("CDDBMode", TEST)
    strCDDBServer = PropBag.ReadProperty("CDDBServer", CDDB_SERVER)
    strUserEmail = PropBag.ReadProperty("UserEmail", "")
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    PropBag.WriteProperty "AppTitle", strAppName, App.Title
    PropBag.WriteProperty "AppVer", strAppVer, App.Major & "." & App.Minor
    PropBag.WriteProperty "CDDBIfc", enumCDDBIfc, "AUTO"
    PropBag.WriteProperty "CDDBMode", enumCDDBMode, "TEST"
    PropBag.WriteProperty "CDDBServer", strCDDBServer, CDDB_SERVER
    PropBag.WriteProperty "UserEmail", strUserEmail, ""
End Sub

'clean up
Private Sub UserControl_Terminate()
    
    Set frmFuzzy = Nothing
    Set frmSubmit = Nothing
    Set colTrackNames = Nothing
    Set colTrackTimes = Nothing
End Sub

