VERSION 5.00
Begin VB.Form frmSubmitInfo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Submit Disc / Track Information"
   ClientHeight    =   5076
   ClientLeft      =   36
   ClientTop       =   336
   ClientWidth     =   7956
   Icon            =   "frmSubmitInfo.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5076
   ScaleWidth      =   7956
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cmdSubmit 
      Caption         =   "Submit"
      Height          =   372
      Left            =   5400
      TabIndex        =   10
      Top             =   4560
      Width           =   1092
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   372
      Left            =   6720
      TabIndex        =   11
      Top             =   4560
      Width           =   972
   End
   Begin VB.Frame Frame2 
      Caption         =   "Tracks X to Y"
      Height          =   4332
      Left            =   3120
      TabIndex        =   19
      Top             =   120
      Width           =   4692
      Begin VB.ListBox lstList 
         Height          =   2928
         Left            =   240
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   1200
         Width           =   4212
      End
      Begin VB.TextBox strTrack 
         Height          =   288
         Left            =   240
         TabIndex        =   7
         Top             =   600
         Width           =   2652
      End
      Begin VB.CommandButton cmdTrack 
         Caption         =   ">>"
         Height          =   252
         Index           =   1
         Left            =   3840
         TabIndex        =   9
         Top             =   620
         Width           =   612
      End
      Begin VB.CommandButton cmdTrack 
         Caption         =   "<<"
         Height          =   252
         Index           =   0
         Left            =   3120
         TabIndex        =   8
         Top             =   620
         Width           =   612
      End
      Begin VB.Label Label7 
         Caption         =   "Track List:"
         Height          =   252
         Left            =   240
         TabIndex        =   21
         Top             =   960
         Width           =   1452
      End
      Begin VB.Label lblTrack 
         Caption         =   "Track 1 Name:"
         Height          =   252
         Left            =   240
         TabIndex        =   20
         Top             =   360
         Width           =   1452
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Album"
      Height          =   4332
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2892
      Begin VB.ComboBox cboGenre 
         Height          =   288
         Left            =   240
         TabIndex        =   5
         Top             =   2400
         Width           =   2412
      End
      Begin VB.TextBox strNotes 
         Height          =   1132
         Left            =   240
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   6
         Top             =   3000
         Width           =   2412
      End
      Begin VB.TextBox strYear 
         Height          =   288
         Left            =   2040
         MaxLength       =   4
         TabIndex        =   4
         Top             =   1800
         Width           =   612
      End
      Begin VB.ComboBox cboCategory 
         Height          =   288
         Left            =   240
         Style           =   2  'Dropdown List
         TabIndex        =   3
         Top             =   1800
         Width           =   1572
      End
      Begin VB.TextBox strAlbum 
         Height          =   288
         Left            =   240
         TabIndex        =   2
         Top             =   1200
         Width           =   2412
      End
      Begin VB.TextBox strArtist 
         Height          =   288
         Left            =   240
         TabIndex        =   1
         Top             =   600
         Width           =   2412
      End
      Begin VB.Label Label6 
         Caption         =   "Genre:"
         Height          =   252
         Left            =   240
         TabIndex        =   22
         Top             =   2160
         Width           =   1092
      End
      Begin VB.Label Label5 
         Caption         =   "Album Notes:"
         Height          =   252
         Left            =   240
         TabIndex        =   18
         Top             =   2760
         Width           =   1092
      End
      Begin VB.Label Label4 
         Caption         =   "Year:"
         Height          =   252
         Left            =   2040
         TabIndex        =   17
         Top             =   1560
         Width           =   492
      End
      Begin VB.Label Label3 
         Caption         =   "Category:"
         Height          =   252
         Left            =   240
         TabIndex        =   16
         Top             =   1560
         Width           =   1092
      End
      Begin VB.Label Label2 
         Caption         =   "Album Name:"
         Height          =   252
         Left            =   240
         TabIndex        =   15
         Top             =   960
         Width           =   1092
      End
      Begin VB.Label Label1 
         Caption         =   "Artist Name:"
         Height          =   252
         Left            =   240
         TabIndex        =   14
         Top             =   360
         Width           =   1092
      End
   End
   Begin VB.Label lblError 
      Alignment       =   2  'Center
      ForeColor       =   &H000000FF&
      Height          =   252
      Left            =   1560
      TabIndex        =   13
      Top             =   4644
      Width           =   3612
   End
   Begin VB.Image Image1 
      Height          =   372
      Left            =   240
      Picture         =   "frmSubmitInfo.frx":000C
      Top             =   4560
      Width           =   1056
   End
End
Attribute VB_Name = "frmSubmitInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'***************************************
'**  uFREEDB - CDDB Active-X Control  **
'**    (c) 2001 by Jon Zahornacky     **
'***************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' FREEDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit
'
Dim m_MaxTrack As Integer
Dim m_CurrentTrack As Integer
Dim m_TrackEdited As Boolean
Dim m_InListMgt As Boolean
'
Dim m_CDID As String
Dim m_SUBMIT As String
Dim m_strTocData() As String
'
Dim m_strSubmit As String
'

'*************************
'** Main Submit Routine **
'*************************
Public Function SubmitData(strTOC As String, strCdId As String, _
                            strSubmit As String) As String
    Dim i As Integer

    'init return value...
    m_strSubmit = ""

    'save off temp info to make submission string
    m_CDID = strCdId
    m_SUBMIT = strSubmit
    
    'breakdown the string into individual elements
    m_strTocData = Split(strTOC, " ", 100, vbTextCompare)

    'get tracks
    m_MaxTrack = UBound(m_strTocData)

    'display update
    Frame2.Caption = "Tracks:  1 to " & m_MaxTrack

    'update user display from track array
    For i = 1 To m_MaxTrack
        lstList.AddItem "Untitled Track " & Format$(i, "0#")
    Next
    
    'housekeeping...
    m_CurrentTrack = 1
    lstList.Selected(0) = True
    strTrack.Text = "Untitled Track 01"
    lblTrack.Caption = "Track  1  Name:"

    cboCategory.AddItem ("blues")
    cboCategory.AddItem ("country")
    cboCategory.AddItem ("classical")
    cboCategory.AddItem ("data")
    cboCategory.AddItem ("folk")
    cboCategory.AddItem ("jazz")
    cboCategory.AddItem ("misc")
    cboCategory.AddItem ("newage")
    cboCategory.AddItem ("reggae")
    cboCategory.AddItem ("rock")
    cboCategory.AddItem ("soundtrack")

    cboGenre.AddItem ("Alternative")
    cboGenre.AddItem ("Blues")
    cboGenre.AddItem ("Books & Spoken")
    cboGenre.AddItem ("Children's Music")
    cboGenre.AddItem ("Classical")
    cboGenre.AddItem ("Country")
    cboGenre.AddItem ("Dance")
    cboGenre.AddItem ("Data")
    cboGenre.AddItem ("Disco")
    cboGenre.AddItem ("Easy Listening")
    cboGenre.AddItem ("Electronic")
    cboGenre.AddItem ("Folk")
    cboGenre.AddItem ("Gospel & Religious")
    cboGenre.AddItem ("Hip Hop")
    cboGenre.AddItem ("Holiday")
    cboGenre.AddItem ("Industrial")
    cboGenre.AddItem ("Jazz")
    cboGenre.AddItem ("Latin")
    cboGenre.AddItem ("Metal")
    cboGenre.AddItem ("New Age")
    cboGenre.AddItem ("Pop")
    cboGenre.AddItem ("R & B")
    cboGenre.AddItem ("Rap")
    cboGenre.AddItem ("Reggae")
    cboGenre.AddItem ("Rock")
    cboGenre.AddItem ("Soundtrack")
    cboGenre.AddItem ("UnClassifiable")

    'prompt
    Me.Show vbModal

    '** CAUTION ******************************************
    ' We "overload" the returned info with the "Catagory"
    ' and the submit string to be sent to the Freedb...
    '*****************************************************

    'return Catagory and Submission info...
    SubmitData = m_strSubmit
End Function

'************************************
'** Track Entry Managment Routines **
'************************************
Private Sub Form_KeyDown(keycode As Integer, shift As Integer)

    'if working on track list, advance with "arrows" permitted
    If (m_InListMgt = True) Then
        strTrack_Click
        If (keycode = vbKeyUp) Then cmdTrack_Click (0)
        If (keycode = vbKeyDown) Then cmdTrack_Click (1)
    End If
End Sub

Private Sub strTrack_GotFocus()
    m_InListMgt = True
    strTrack_Click
End Sub

Private Sub strTrack_LostFocus()
    m_InListMgt = False
End Sub

Private Sub strTrack_Click()
    lstList.BackColor = vbWhite
    m_TrackEdited = True
    If InStr(1, strTrack.Text, "Untitled Track") Then strTrack.Text = ""
End Sub

Private Sub cmdTrack_Click(Index As Integer)
    Dim i As Integer
    
    'clear warning highlite
    lstList.BackColor = vbWhite

    'only take input if new data
    If (m_TrackEdited = True) Then
        m_TrackEdited = False
        lstList.RemoveItem (m_CurrentTrack - 1)
        lstList.AddItem Left$(strTrack.Text, 50), m_CurrentTrack - 1
    End If

    'index = 0 is prev entry button
    If (Index = 0) Then
        m_CurrentTrack = m_CurrentTrack - 1
        If (m_CurrentTrack < 1) Then m_CurrentTrack = m_MaxTrack
        lblTrack.Caption = "Track  " & m_CurrentTrack & "  Name:"

    'index = 1 is next entry button
    Else
        m_CurrentTrack = m_CurrentTrack + 1
        If (m_CurrentTrack > m_MaxTrack) Then m_CurrentTrack = 1
        lblTrack.Caption = "Track  " & m_CurrentTrack & "  Name:"
    End If

    'highlite new selection
    lstList.Selected(m_CurrentTrack - 1) = True
    
    'update track edit box from new selection arrival
    strTrack.Text = lstList.Text
End Sub

Private Sub lstList_Click()
        
    'only take input if new data
    If (m_TrackEdited = True) Then
        m_TrackEdited = False
        lstList.RemoveItem (m_CurrentTrack - 1)
        lstList.AddItem Left$(strTrack.Text, 50), m_CurrentTrack - 1
    End If

    'if valid selection
    If (lstList.ListIndex <> -1) Then
        m_CurrentTrack = lstList.ListIndex + 1
        lblTrack.Caption = "Track  " & m_CurrentTrack & "  Name:"

        strTrack.Text = lstList.Text
    End If
End Sub

'***********************************
'** Clear the warning highlite(s) **
'***********************************
Private Sub strArtist_GotFocus()
    strArtist.BackColor = vbWhite
End Sub
Private Sub strAlbum_GotFocus()
    strAlbum.BackColor = vbWhite
End Sub
Private Sub cboCategory_GotFocus()
    cboCategory.BackColor = vbWhite
End Sub
Private Sub cboGenre_GotFocus()
    cboGenre.BackColor = vbWhite
End Sub
Private Sub strYear_GotFocus()
    strYear.BackColor = vbWhite
End Sub

'************************************************
'** Validate info and Create Submission Packet **
'************************************************
Private Sub cmdSubmit_Click()
    Dim i As Integer
    Dim strSubmit As String
    Dim tmpString As String

    'only take input if new data
    If (m_TrackEdited = True) Then
        m_TrackEdited = False
        lstList.RemoveItem (m_CurrentTrack - 1)
        lstList.AddItem Left$(strTrack.Text, 50), m_CurrentTrack - 1
    End If

    'first make sure good data entered...
    If (ValidSubmission = False) Then Exit Sub

    'build submission packet...
    m_strSubmit = "# xmcd" & vbCrLf & _
                  "#" & vbCrLf & _
                  "# Track frame offsets:" & vbCrLf
    
    'track offset info
    For i = 0 To m_MaxTrack - 1
        m_strSubmit = m_strSubmit & _
                  "#   " & m_strTocData(i) & vbCrLf
    Next

    'program info
    m_strSubmit = m_strSubmit & _
                  "#" & vbCrLf & _
                  "# Disc length: " & (Val(m_strTocData(m_MaxTrack)) \ 75) & " seconds" & vbCrLf & _
                  "#" & vbCrLf & _
                  "# Revision: 0" & vbCrLf & _
                  "# Submitted via: " & m_SUBMIT & vbCrLf & _
                  "#" & vbCrLf & _
                  "DISCID=" & m_CDID & vbCrLf

    'user data info...
    m_strSubmit = m_strSubmit & _
                  "DTITLE=" & strArtist & " / " & strAlbum & vbCrLf & _
                  "DYEAR=" & strYear & vbCrLf & _
                  "DGENRE=" & cboGenre.Text & vbCrLf

    For i = 0 To m_MaxTrack - 1
        lstList.Selected(i) = True
        tmpString = lstList.Text
        m_strSubmit = m_strSubmit & _
                  "TTITLE" & (i) & "=" & tmpString & vbCrLf
    Next

    tmpString = Replace(strNotes, vbCrLf, "\n")
    m_strSubmit = m_strSubmit & _
                  "EXTD=" & tmpString & vbCrLf

    For i = 1 To m_MaxTrack
        m_strSubmit = m_strSubmit & _
                  "EXTT" & (i - 1) & "=" & vbCrLf
    Next

    m_strSubmit = m_strSubmit & _
                  "PLAYORDER=" & vbCrLf

    'return the Catagory and Submission info
    m_strSubmit = cboCategory.Text & "*" & m_strSubmit

    'return to caller...
    Unload Me
End Sub

Private Function ValidSubmission() As Boolean
    Dim i As Integer
    Dim strTemp As String
    Dim bOneText As Boolean
    Dim bHasBlank As Boolean
    Dim iFirstBlank As Integer
    Dim rslt As VbMsgBoxResult

    'clear warnings / set OK
    lblError.Caption = ""
    ValidSubmission = True
    
    'validate all user fields
    If (strArtist = "") Then
        ValidSubmission = False
        strArtist.BackColor = vbYellow
    End If

    If (strAlbum = "") Then
        ValidSubmission = False
        strAlbum.BackColor = vbYellow
    End If

    If (cboCategory.Text = "") Then
        ValidSubmission = False
        cboCategory.BackColor = vbYellow
    End If

    If (cboGenre.Text = "") Then
        ValidSubmission = False
        cboGenre.BackColor = vbYellow
    End If

    If (strYear = "" Or Val(strYear) < 1900 Or Val(strYear) > 2100) Then
        ValidSubmission = False
        strYear.BackColor = vbYellow
    End If

    'scan Tracks for correct info
    For i = 1 To m_MaxTrack
        lstList.Selected(i - 1) = True
        strTemp = lstList.Text
        
        'log if any track has non-blank entry
        If (strTemp <> "") Then bOneText = True
        
        'log if any track has blank entry & remember entry
        If (strTemp = "") Then
            bHasBlank = True
            If (iFirstBlank = 0) Then iFirstBlank = i
        End If
        
        'if any track has init string, NO ENTRY & remember entry
        If (InStr(1, strTemp, "Untitled Track", vbTextCompare) > 0) Then
            ValidSubmission = False
            lstList.BackColor = vbYellow
            
            're-index to bad entry
            m_CurrentTrack = i
            strTrack.Text = lstList.Text
            Exit For
        End If
    Next

    'all entries are blank...
    If (bOneText = False) Then
        lstList.Selected(0) = True
        
        're-index to first entry
        m_CurrentTrack = 1
        strTrack.Text = lstList.Text

        ValidSubmission = False
        lstList.BackColor = vbYellow
    End If

    'invalid, so error msg and exit
    If (ValidSubmission = False) Then
        lblError.Caption = "Please correct the highlited information..."
        Exit Function
    End If

    'OK so far, check for one or more blank track(s), if so issue warning
    If (bHasBlank = True) Then
        rslt = MsgBox("Blank tracks are entered, Ok to Submit?", vbOKCancel, "Confirm")
            
        'user wants to fix the blanks
        If (rslt = vbCancel) Then
            lstList.Selected(iFirstBlank - 1) = True
        
            're-index to bad entry
            m_CurrentTrack = iFirstBlank
            strTrack.Text = lstList.Text
            strTrack.SetFocus

            ValidSubmission = False
            lstList.BackColor = vbYellow
            
            lblError.Caption = "Please enter track info, then re-submit..."
        End If
    End If
End Function

Private Sub cmdCancel_Click()

    m_strSubmit = ""
    Unload Me
End Sub

