/***
 * c't Motorsteuerung
 * motor.h
 *
 * eigentliche Motorsteuerung
 *
 * (c) 2002 Redaktion c't, Hannover
 *          Herbert Schmid
 ***/

/* Callback-Funktion, wird aufgerufen wenn Motor an- oder abgeschaltet wird. */
void MotorSetGui(HWND hWnd, BOOL MotorRuns);

/* enthlt die aktuelle Position */
int MotorPoti;


/* 
 * alle Funktionen liefern bei Erfolg 0, im Fehlerfalle einen Wert >= 1
 *
 * Rckgabewerte:
 *   0 .. alles ok
 *   1 .. USB-Baustein nicht erreichbar
 *  11 .. USB-Baustein nicht erreichbar, Motor lief
 *   2 .. Motor lief nicht an oder blieb hngen
 *   3 .. Ziel trotz Richtungskorrektur nicht erreicht
 *   9 .. sonstiger Fehler bei der Initialisierung
 */

/* Zielvorgabe fr den Motor, 0 .. 255 */
int MotorGoal;

/* Potiwert negieren */
BOOL MotorInvertPoti;

/* Drehrichtung vertauschen */
BOOL MotorExchangeLR;


/***
 * USB-Treiber ffnen und Timer starten
 *
 *  hWnd: Handle des Dialog-Fensters
 *			(wird zum setzen des Timers bentigt)
 ***/
BOOL MotorInit(HWND hWnd);


/***
 * Timer und Motor stoppen, USB-Treiber schlieen
 *
 *  hWnd: Handle des Dialog-Fensters
 ***/
BOOL MotorClose(HWND hWnd);


/***
 * Motor starten
 *
 *  hWnd: Handle des Dialog-Fensters
 ***/
BOOL MotorStart(HWND hWnd);


/***
 * Motor ausschalten
 *
 *  hWnd: Handle des Dialog-Fensters
 ***/ 
BOOL MotorStop(HWND hWnd);


/***
 * MotorTimer
 *
 *   berwacht den Motor und liest regelmig den Wert des Poti aus
 *	 ruft gegebenenfalls die Callback-Funktion MotorSetGui auf 
 *
 *  hWnd: Handle des Dialog-Fensters
 ***/
BOOL MotorTimer(HWND hWnd);
