unit USB;
(**********************************)
(* usb.pas			  *)
(*				  *)
(*                                *)
(* nach USB.C von 		  *)
(* Kai-Uwe Mrkor / c't            *)
(* Delphi-version  v. A.Stiller   *)
(* (C) 2002                       *)
(* www.heise.de/ct		  *)
(**********************************)


interface
  Function USBOpenDriver:boolean;
  Function USBCloseDriver:boolean;
  Function USBWritePort(Port:Word; Value:Byte):boolean;
  Function USBReadPort(Port:Word; Var Value:Byte):boolean;

implementation
uses Windows;

const COMPULAB_IOCTL= 4;


(* alle Funktionen liefern im Fehlerfalle FALSE, bei Erfolg einen Wert ungleich 0 *)

(* Handle auf GerteTreiber *)
const hgDriver:Thandle = INVALID_HANDLE_VALUE;


(**********************)
(* USB-Treiber ffnen *)
(**********************)
Function USBOpenDriver:boolean;
begin
  // Gertetreiber mit passenden Dateinamen ffnen
  hgDriver:= CreateFile('\\.\CompuLABusb_0',GENERIC_WRITE or GENERIC_READ,
						 FILE_SHARE_WRITE or FILE_SHARE_READ, NIL, OPEN_EXISTING, 0, 0);
  USBOpenDriver:= hgDriver <> INVALID_HANDLE_VALUE
end;



(*************************)
(* USB-Treiber schlieen *)
(*************************)

Function USBCloseDriver:boolean;
begin
  USBCloseDriver := CloseHandle(hgDriver);
  hgDriver := INVALID_HANDLE_VALUE;
end;

(****************************)
(* Port setzen              *)
(*			    *)
(* Port: Ausgabeport (0,1)  *)
(* Wert: auszugebender Wert *)
(****************************)

Function USBWritePort(Port:Word; Value:Byte):boolean;

var command, inDummy, count:longword;

begin
  (* Befehl fr Treiber berechnen: *)
  (* 21: Port setzen *)
  command := (Longword(Value) shl 16) + Port * 256 + 21;
  inDummy := 0;

  (* Ausgabe *)
  USBWritePort := DeviceIoControl(hgDriver,
                                  COMPULAB_IOCTL,
                                  @command,
                                  sizeof(command),
                                  @inDummy,
                                  sizeof(inDummy),
                                  count,
                                  NIL);

end;


(****************************)
(* Port auslesen            *)
(*			    *)
(* Port: Einleseport (0,1)  *)
(* Wert: eingelesener Wert  *)
(****************************)
Function USBReadPort(Port:Word; Var Value:Byte):boolean;
var command, count:longword;
var inBytes:word;
begin
 (* Befehl fr den Treiber berechnen *)
 (* 20: Port auslesen *)
 command := 20 + Port*256;

 USBReadPort := DeviceIoControl(hgDriver,
                                COMPULAB_IOCTL,
                                @command,
                                sizeof(command),
                                @inBytes,
                                sizeof(inBytes),
                                count,
                                NIL);
  Value:= hi(inBytes);

end;

end.
