unit clientmain;
{$H+}
(**********************************)
(* clientmain.pas		  *)
(*				  *)
(* c't/Andreas  Stiller           *)
(* (C) 2002                       *)
(* www.heise.de/ct		  *)
(**********************************)




interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Buttons, ScktComp, ExtCtrls, ComCtrls, inifiles, math;

type
  TMotorForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    FileConnectItem: TMenuItem;
    StatusBar1: TStatusBar;
    Bevel1: TBevel;
    Panel1: TPanel;
    Memo2: TMemo;
    N1: TMenuItem;
    SpeedButton1: TSpeedButton;
    Disconnect1: TMenuItem;
    ClientSocket: TClientSocket;
    bStop: TButton;
    Image1: TImage;
    Image2: TImage;
    lSoll: TLabel;
    lIst: TLabel;
    eIst: TEdit;
    Optionen1: TMenuItem;
    esoll: TEdit;
    TrackBar1: TTrackBar;
    bLinks: TButton;
    bRechts: TButton;
    LFast: TLabel;
    lSlow: TLabel;
    changes: TMenuItem;
    Timer1: TTimer;
    procedure FileConnectItemClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure ServerSocketError(Sender: TObject; Number: Smallint;
      var Description: string; Scode: Integer; const Source,
      HelpFile: string; HelpContext: Integer; var CancelDisplay: Wordbool);
    procedure ClientSocketConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ClientSocketRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure  showarrows(a,b:real);
    procedure ClientSocketError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure ClrScr;
    procedure WriteLn (s:string);

    procedure BLinksClick(Sender: TObject);
    procedure bRechtsClick(Sender: TObject);
    procedure bStopClick(Sender: TObject);
    procedure eSollKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Image2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TrackBar1Change(Sender: TObject);
    Procedure InterpretIni;
    procedure ChangesClick(Sender: TObject);
    procedure SendChanges;
    procedure Timer1Timer(Sender: TObject);
   
  protected
    IsServer: Boolean;
    hasConnection: Boolean;
    IsLogin:Boolean;
    
    x0,y0:integer;
    r1,r2,r3:real;
    hit:boolean;
    Mypath:string;
    Servername:string;
    Inidat:Tinifile;
    ist,soll:integer;
  end;

var
  MotorForm: TMotorForm;
  Server: String;


const password:string='*';
const deltaw:real=5;
const maxlines=25;
implementation

{$R *.DFM}

Procedure TmotorForm.ClrScr;
begin
memo2.Lines.clear;
end;

Procedure TmotorForm.WriteLn (s:string);
begin
if memo2.Lines.count >= maxLines then memo2.lines.delete(0);
memo2.Lines.add(s)
end;

Function ShowError (x:string):integer;
begin
 Showerror:=application.messagebox(pchar(x),'Error',MB_OK or MB_ICONERROR);
 halt(1);
end;



procedure TMotorForm.FileConnectItemClick(Sender: TObject);
begin
  Server:=Servername;
  ClientSocket.Active := False;
  if InputQuery( 'Computer to connect to', 'Address Name:', Server) then
    if Length(Server) > 0 then
      with ClientSocket do
      begin
        Host := Server;
        Active := True;
      end;
end;

procedure TMotorForm.Exit1Click(Sender: TObject);
begin
  ClientSocket.Close;
  Close;
end;

procedure TMotorForm.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then
   ClientSocket.Socket.SendText(Memo2.Lines[Memo2.Lines.Count - 1]);
end;

Procedure TMotorform.InterpretIni;
 begin
  // Auch wenns Microsoft nicht mag, ich finde oft lokale INI-Dateien
  // besser als Registry-Eintrge
 Mypath:=ExtractFilePath(ParamStr(0));
 Inidat:=Tinifile.Create(mypath+'motorclient.ini');
 With Inidat do
  begin
   If not FileExists (Filename) then Writeln (Filename+ ' nicht gefunden, nehme Defaultwerte');
   Writeln (Filename);
   Clientsocket.port:=ReadInteger ('IP','PORT',ClientSocket.port);
   Password:=ReadString('IP','Password',Password);

   If Password='*' then
     begin
     Password:='';
     if InputQuery( 'Passwort fr Kommunikation mit motorhost eingeben', 'Passwort:', Password) then

      WriteString ('IP','Password',Password)

     end;
   Servername:=ReadString('IP','Servername','');
   Timer1.Interval:=ReadInteger('IP','Timeout',1000);
   Changes.Checked:=ReadBool ('MOTOR','Sendchanges',true);
 end;

 end;


procedure TMotorForm.FormCreate(Sender: TObject);
begin
   Timer1.enabled:=false;
   InterpretIni;
   FileConnectItemClick(nil);
   x0:=image1.width div 2;
   y0:=image1.height div 2;
   r1:=x0-30;
   r2:=r1/2;
   r3:=r1+10;
   showarrows (0,0);
   hit:=false;
end;

procedure TMotorForm.ServerSocketError(Sender: TObject; Number: Smallint;
  var Description: string; Scode: Integer; const Source, HelpFile: string;
  HelpContext: Integer; var CancelDisplay: Wordbool);
begin
  ShowMessage(Description);
end;


Procedure TMotorform.Showarrows(a,b:real);

var api,bpi:real;

const d=pi/36;
 begin
 while  a > 360 do a := a-360;
 while a < 0    do a := a+360;
 api:=a/180*pi;

 while  b > 360 do b := b-360;
 while  b < 0   do b := b+360;
 bpi:=b/180*pi;
 soll:=round(a);
 ist:= round (b);

 with image2.Canvas do
   begin
   Brush.Color:=clblack;//TransparentcolorValue;
   FillRect(Rect(0,0,image2.width,image2.height));

   pen.Color:=clBlue;
   moveto (X0,Y0);
   //moveto (x0+round(r1*sin (bpi)),y0-round (r1*cos (bpi)));
   lineto (x0+round(r3*sin (bpi)),y0-round (r3*cos (bpi)));
   lineto (x0+round(r1*sin (bpi-0.1)),y0-round (r1*cos (bpi-0.1)));
   moveto (x0+round(r3*sin (bpi)),y0-round (r3*cos (bpi)));
   lineto (x0+round(r1*sin (bpi+0.1)),y0-round (r1*cos (bpi+0.1)));
   pen.Color:=clRed;
   Brush.Color:=clRed;
   polygon (
    [point(x0+round(r2*sin (api-d)),y0-round (r2*cos (api-d))),
     point(x0+round(r1*sin (api  )),y0-round (r1*cos (api  ))),
     point(x0+round(r2*sin (api+d)),y0-round (r2*cos (api+d))),
     point(x0,y0)]);

   pen.Color:=clBlue;
   moveto (x0+round(r1*sin (bpi)),y0-round (r1*cos (bpi)));
   lineto (x0+round(r3*sin (bpi)),y0-round (r3*cos (bpi)));
   lineto (x0+round(r1*sin (bpi-0.1)),y0-round (r1*cos (bpi-0.1)));
   moveto (x0+round(r3*sin (bpi)),y0-round (r3*cos (bpi)));
   lineto (x0+round(r1*sin (bpi+0.1)),y0-round (r1*cos (bpi+0.1)));
   eSoll.Text:=FloattostrF(a,fffixed,3,0)+'';


  end;
end;


procedure TMotorForm.ClientSocketConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Statusbar1.Panels[0].Text := 'connected to '+Socket.RemoteHost;
  ClientSocket.Socket.SendText(Password);
  Timer1.Enabled:=true;
end;


procedure TMotorForm.ClientSocketRead(Sender: TObject;
  Socket: TCustomWinSocket);
  var s:shortstring;
  var p:integer;
  var res:integer;
begin
  s:=Socket.ReceiveText;
  Writeln (s);
  If s='ok, Zugang erlaubt' then Islogin:=true;
  if s[1]='#' then
   begin
    delete (s,1,1);
    repeat
     p:=pos ('#',s);
     if p <> 0 then delete (s,1,p);
    until p=0;
    p:=pos (',',s); if p=0 then p:=255;
    val (copy(s,1,p-1),ist,res);
    if res<> 0 then exit;
    eIst.Text:=inttostr(ist)+'';
    val (copy(s,p+1,255),soll,res);
    if res <>0 then exit;
    eSoll.Text:=inttostr(soll)+'';
    showarrows(soll,ist);
    //statusbar1.Panels[1].text:=char(lo(lparam));
   end;

end;


procedure TMotorForm.ClientSocketError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
  Writeln('Error connecting to : ' + Server);
  ErrorCode := 0;
end;

procedure TMotorForm.BLinksClick(Sender: TObject);
begin
 ClientSocket.Socket.SendText('L');
end;


procedure TMotorForm.bRechtsClick(Sender: TObject);
begin
 ClientSocket.Socket.SendText('R');
end;

procedure TMotorForm.bStopClick(Sender: TObject);
begin
 ClientSocket.Socket.SendText('S');
end;

procedure TMotorForm.SendChanges;
begin
  if changes.Checked then ClientSocket.Socket.SendText('SendChanges')
 else ClientSocket.Socket.SendText('NoChanges');
end;


procedure TMotorForm.eSollKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var wneu:real;
var l:integer;
var res:integer;
begin
if key=VK_Return then
 begin
 l:=length(eSoll.Text);
 if eSoll.text[l]='' then dec(l);
 val (copy (eSoll.text,1,l),wneu,res);

 if Res<>0 then WriteLn ('wat dat')
 else showarrows (wneu,ist);
 ClientSocket.Socket.SendText ('N'+inttostr(soll));
 end;
end;

procedure TMotorForm.Image2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
hit:=(ssleft in shift) and (image2.Canvas.pixels[x,y]=clred);
end;

procedure TMotorForm.Image2MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
if hit and (ssLeft in Shift) then
 begin
 if (y<y0) then showarrows(round(arctan ((x-x0)/(y0-y))*180/pi),ist)
 else if (y=y0) then
     begin
      if x> x0 then showarrows(90,ist)
      else showarrows (270,ist);
     end
 else showarrows(180+round(arctan ((x-x0)/(y0-y))*180/pi),ist);
 end;

end;


procedure TMotorForm.Image2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

ClientSocket.Socket.SendText ('N'+inttostr(soll));
hit:=false;
end;

procedure TMotorForm.TrackBar1Change(Sender: TObject);
begin
 With trackbar1 do ClientSocket.Socket.SendText('V'+inttostr(position))
end;



procedure TMotorForm.changesClick(Sender: TObject);
begin
 changes.checked:=not changes.checked;
 SendChanges;
 Inidat.WriteBool ('MOTOR','SendChanges',changes.checked)
end;

procedure TMotorForm.Timer1Timer(Sender: TObject);
begin
Timer1.enabled:=false;
if not isLogin then
     begin
     Showerror ('Passwort falsch oder Timeout');
     end
 else
  begin
   Writeln ('Sollwert einstellen  => roter Pfeil anclicken und mit Maus drehen');
   ClientSocket.Socket.SendText('P'); //aktuelle Position einlesen
   SendChanges;                       //soll laufend Position gesendet werden?

  end;
end;



end.
