Attribute VB_Name = "OL_AntiSpam"
Option Explicit

' 2002, Ralf Nebelo

Public Sub AntiSpam()
    Dim objNameSpace As NameSpace
    Dim objPosteingang As MAPIFolder
    Dim objOrdner As MAPIFolder
    Dim objSpamOrdner As MAPIFolder
    Dim objNachricht1 As MailItem
    Dim objAntwortMail As MailItem
    Dim objAbsender As Recipient
    Dim strAbsenderAdresse As String
    Dim intPos As Integer
    Dim intPos2 As Integer
    Dim strPrfID As String
    Dim objNachricht2 As MailItem
    Dim objKontakt As ContactItem
    Dim dtmLschdatum As Date
    Dim blnBekannt As Boolean

    On Error Resume Next

    Set objNameSpace = GetNamespace("MAPI")
    'Posteingangsordner ermitteln
    Set objPosteingang = objNameSpace.GetDefaultFolder(olFolderInbox)

    'Alle Unterordner des Posteingangsordners durchlaufen
    For Each objOrdner In objPosteingang.Folders
        'Wenn Ordner 'Ungeprfte Nachrichten' vorhanden, dann...
        If objOrdner.Name = "Ungeprfte Nachrichten" Then
            '... Verweis darauf speichern und Schleife verlassen
            Set objSpamOrdner = objOrdner
            Exit For
        End If
    Next
    'Wenn Verweis ungltig ist, dann...
    If objSpamOrdner Is Nothing Then
        '... Ordner 'Ungeprfte Nachrichten' anlegen
        Set objSpamOrdner = objPosteingang.Folders.Add("Ungeprfte Nachrichten")
    End If

    'Alle Nachrichten im Posteingangsordner durchlaufen
    For Each objNachricht1 In objPosteingang.Items
        'Wenn Nachricht ungelesen und nicht geprft ist, dann...
        If objNachricht1.UnRead = True And objNachricht1.UserProperties.Find("Geprft") Is Nothing Then
            '... Antwort-Mail anlegen
            Set objAntwortMail = objNachricht1.Reply
            'E-Mail-Adresse des Absenders der Originalnachricht aus
            'Address-Eigenschaft des Antwort-Mail-Empfngers auslesen
            Set objAbsender = objAntwortMail.Recipients(1)
            strAbsenderAdresse = LCase(objAbsender.Address)
            
            'Wenn E-Mail-Adresse des Absenders weiterhin unbekannt ist
            '(was nur in Outlook 2000 vorkommen kann), dann...
            If InStr(strAbsenderAdresse, "@") = 0 Then
                '... prfen, ob AddressEntry-Eigenschaft des Absenders eine
                'gltige E-Mail-Adresse enthlt. Wenn das zutrifft, dann...
                If InStr(objAbsender.AddressEntry, "@") > 0 Then
                    '... AddressEntry-Inhalt als E-Mail-Adresse merken
                    strAbsenderAdresse = objAbsender.AddressEntry
                'Wenn auch AddressEntry-Eigenschaft keine gltige E-Mail-
                'Adresse enthlt, dann...
                Else
                    '... MailTo-Tag im Text der Nachricht suchen
                    intPos = InStr(objAntwortMail.Body, "[mailto:")
                    'Wenn MailTo-Tag gefunden, dann...
                    If intPos > 0 Then
                        '... dahinter angegebene E-Mail-Adresse merken
                        intPos2 = InStr(intPos + 8, objAntwortMail.Body, "]")
                        strAbsenderAdresse = Trim(Mid(objAntwortMail.Body, intPos + 8, intPos2 - intPos - 8))
                    End If
                End If
            End If
            
            'Prfen, ob es sich bei der Nachricht um eine Besttigung handelt
            intPos = InStr(objNachricht1.Subject, "[SpamCheck-ID")
            'Wenn Nachricht Besttigung ist, dann...
            If intPos > 0 Then
                '... Prf-ID isolieren
                strPrfID = Trim(Right(objNachricht1.Subject, Len(objNachricht1.Subject) - intPos + 1))
                'Lschdatum festlegen: Aktuelles Datum minus 7 Tage
                dtmLschdatum = DateSerial(Year(Now), Month(Now), Day(Now) - 7)
                
                'Ordner 'Ungeprfte Nachrichten' durchlaufen
                For Each objNachricht2 In objSpamOrdner.Items
                    'Wenn Nachricht die gesuchte Prf-ID enthlt, dann...
                    If InStr(objNachricht2.Subject, strPrfID) = 1 Then
                        With objNachricht2
                            '... Prf-ID aus Betreff entfernen
                            .Subject = Trim(Right(.Subject, Len(.Subject) - Len(strPrfID)))
                            'Prfvermerk anfgen
                            .Body = .Body & vbCr & vbCr & "----- Geprft vom AntiSpam-Makro ( 2002, Ralf Nebelo) -----"
                            'Nachricht als ungelesen markieren
                            .UnRead = True
                            'Nachricht in Posteingang verschieben
                            .Move objPosteingang
                        End With
                        
                        'Neuen Kontakt anlegen
                        Set objKontakt = Application.CreateItem(olContactItem)
                        With objKontakt
                            'Namen festlegen
                            .FullName = objNachricht1.SenderName
                            'E-Mail-Adresse des Absenders bernehmen
                            .Email1Address = strAbsenderAdresse
                            'Kontakt speichern
                            .Save
                        End With
                        
                        'Nicht mehr bentigte Besttigungs-Mail lschen
                        objNachricht1.Delete
                    'Wenn Nachricht nicht die gesuchte Prf-ID enthlt...
                    Else
                        '... und lter ist als Lschdatum, dann...
                        If objNachricht2.ReceivedTime < dtmLschdatum Then
                            '... beraltete Nachricht lschen
                            objNachricht2.Delete
                        End If
                    End If
                Next
            
                'Antwort auf Besttigung nicht ntig, daher lschen
                objAntwortMail.Delete
            
            'Wenn Nachricht normale Mail ist, dann...
            Else
                '... zunchst von unbekanntem Absender ausgehen
                blnBekannt = False
    
                'Alle Kontakte durchlaufen
                For Each objKontakt In objNameSpace.GetDefaultFolder(olFolderContacts).Items
                    'Wenn erste E-Mail-Adresse mit E-Mail-Adresse des
                    'Absenders bereinstimmt, dann...
                    If LCase(objKontakt.Email1Address) = strAbsenderAdresse Then
                        '... Absender als bekannt markieren, Schleife verlassen
                        blnBekannt = True
                        Exit For
                    'Wenn zweite E-Mail-Adresse mit E-Mail-Adresse des
                    'Absenders bereinstimmt, dann...
                    ElseIf LCase(objKontakt.Email2Address) = strAbsenderAdresse Then
                        '... Absender als bekannt markieren, Schleife verlassen
                        blnBekannt = True
                        Exit For
                    'Wenn dritte E-Mail-Adresse mit E-Mail-Adresse des
                    'Absenders bereinstimmt, dann...
                    ElseIf LCase(objKontakt.Email3Address) = strAbsenderAdresse Then
                        '... Absender als bekannt markieren, Schleife verlassen
                        blnBekannt = True
                        Exit For
                    End If
                Next
            
                'Nachricht als 'geprft' kennzeichnen und nderung speichern
                With objNachricht1
                    .UserProperties.Add("Geprft", olText).Value = "Ja"
                    .Save
                End With
    
                'Wenn Absender bekannt ist, dann...
                If blnBekannt = True Then
                    '... Antwort-Mail lschen
                    objAntwortMail.Delete
                'Wenn Absender nicht bekannt ist, dann...
                Else
                    'Eindeutige Prf-ID aus Absendername, Betreff und Empfangszeit bilden
                    strPrfID = "[SpamCheck-ID " & CStr(HolPrfsumme(objNachricht1.SenderName & objNachricht1.Subject & objNachricht1.ReceivedTime)) & "]"
                    With objAntwortMail
                        'Prf-ID an Betreff der Antwort-Mail anhngen
                        .Subject = .Subject & " " & strPrfID
                        'Text der Antwort-Mail festlegen
                        .Body = "Dies ist eine automatisch erzeugte Antwort auf Ihre Nachricht " & Chr(34) & objNachricht1.Subject & Chr(34) & "." & vbCr & vbCr
                        .Body = .Body & "Bevor Ihre Nachricht den Empfnger erreichen kann, mssen Sie diese Nachricht innerhalb von 7 Tagen korrekt beantworten, wozu Sie nur auf die entsprechende Schaltflche Ihres E-Mail-Programms zu klicken brauchen." & vbCr & vbCr
                        .Body = .Body & "Bitte nehmen Sie keine Vernderungen am Betreff Ihrer Antwort vor." & vbCr & vbCr
                        .Body = .Body & "Danke fr Ihre Mitarbeit!"
                        'Sollten Sie Outlook 2000 ohne Sicherheits-Update
                        'einsetzen, knnen Sie die Antwort-Mail automatisch
                        'verschicken lassen:
                        .Send
                        'Im Fall von Outlook XP oder Outlook 2000 mit
                        'Sicherheits-Update sollten Sie die Nachricht nur
                        'anzeigen lassen (und sie dann manuell verschicken).
                        'Dazu setzen sie ein Hochkomma (') vor die obige
                        'Send-Zeile und entfernen das Hochkomma vor der
                        'folgenden Anweisung:
                        '.Display
                    End With
    
                    With objNachricht1
                        'Prf-ID vor Betreff der Nachricht setzen
                        .Subject = strPrfID & " " & .Subject
                        'Nachricht in Ordner 'Ungeprfte Nachrichten' verschieben
                        .Move objSpamOrdner
                    End With
                End If
            End If
        End If
    Next
End Sub

Private Function HolPrfsumme(strText As String) As Long
    Dim intI As Integer
    Dim intByte As Integer
    Dim intJ As Integer
    Dim intTestBit As Integer
    Dim lngCRC As Long
    
    For intI = 1 To Len(strText)
       intByte = Asc(Mid(strText, intI, 1))
       For intJ = 7 To 0 Step -1
          intTestBit = ((lngCRC And 32768) = 32768) Xor ((intByte And (2 ^ intJ)) = 2 ^ intJ)
          lngCRC = ((lngCRC And 32767&) * 2&)
          If intTestBit Then
             lngCRC = lngCRC Xor &H8005&
          End If
       Next intJ
    Next intI
    
    HolPrfsumme = lngCRC
End Function

