package de.ct.refactoring;
import java.util.Arrays;

/**
 * Schritt 6: umbennen und aufrumen
 */
public class RefactoringExample7 {
	public static String longestRepeatingSubstring(String string) {
		String[] substrings = tailStrings(string);
		Arrays.sort(substrings);		
		return longestConsecutiveMatch(substrings);
	}
	
	private static String longestConsecutiveMatch(String[] substrings) {
		String currentLongest = "";
			for (int index = 0; index < substrings.length - 1; index++) {
				final int currentLength = matchLengthFromStart(substrings[index],substrings[index + 1]);
				if(currentLength > currentLongest.length()) {
					currentLongest = substrings[index].substring(0, currentLength);
				}
			}
		return currentLongest;
	}

	private static String[] tailStrings(String string) {
		String[] substrings=new String[string.length()];
			for(int index = 0; index < string.length(); index++) {
				substrings[index]=string.substring(index,string.length());
			}
		return substrings;
	}

	private static int matchLengthFromStart(String string1,String string2) {
		final int minLength = Math.min(string1.length(), string2.length());
			for(int index = 0; index < minLength; index++) {
				if(string1.charAt(index) != string2.charAt(index)) {
					return(index);
				}
			}
		return minLength;
	}	
}