<?xml version="1.0" encoding="iso8859-1" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" encoding="iso8859-1"/>
  <xsl:template match="/">
    <html>
      <body background="braun.gif">
        <h1>
          Erfasste Musikstcke:
        </h1> 
    <xsl:for-each select="Musikbestand/Sortiment">
      <xsl:for-each select="document(@Datei)/Musikstck-Sortiment/Musikstck">
        <xsl:sort select="Satz/Track-Nr."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="Musikstck">
    <table border="2" width="100%" bgcolor="#B0D0FF">
      <tr>
        <td width="14%">
        </td>
        <td width="26%">
        </td>
        <td width="10%">
        </td>
        <td width="10%">
        </td>
        <td width="10%">
        </td>
        <td width="10%">
        </td>
        <td width="10%">
        </td>
        <td width="10%">
        </td>
      </tr>
      <tr>
        <xsl:apply-templates select="Titel"/>
        <xsl:apply-templates select="Satz/Satzbezeichnung"/>
        <td>
        </td>
      </tr>
      <tr>
        <xsl:apply-templates select="gehrt_zu"/>
        <xsl:apply-templates select="Satz/Track-Nr."/>   
      </tr>
      <tr>
        <td>
          <b>Urheber</b>
        </td>
        <td colspan="7">
          <xsl:apply-templates select="Komponist"/>
        </td>
      </tr>
      <tr>
        <td align="left">
          <b>Interpret(en)</b>
        </td>
        <td colspan="7">
          <xsl:apply-templates select="Interpret"/>
        </td>
      </tr>
      <tr>
        <xsl:apply-templates select="Erscheinungsdatum"/>
        <xsl:apply-templates select="Genre"/>
        <xsl:apply-templates select="Aufnahmeparameter"/>
      </tr>
      <tr>
        <xsl:apply-templates select="Speichermedium"/>
        <xsl:apply-templates select="Kommentar"/>
      </tr>
    </table>
    <br>
    </br>
  </xsl:template>

  <xsl:template match="Titel">
    <td>
      <b>Titel</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

  <xsl:template match="gehrt_zu">
    <td>
      <b>gehrt zu</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

  <xsl:template match="Komponist">
    <xsl:value-of select="."/>
    <xsl:if test="position() != last()">
      / 
    </xsl:if>
  </xsl:template>

  <xsl:template match="Interpret">
    <xsl:value-of select="."/>
    <xsl:if test="position() != last()">
      /
    </xsl:if>
  </xsl:template>  

  <xsl:template match="Satz/Satzbezeichnung">
    <td>
      <xsl:if test="position() &lt; 7">
        <xsl:value-of select="."/>
      </xsl:if>
    </td>
  </xsl:template>

  <xsl:template match="Satz/Track-Nr.">
    <td>
      <xsl:if test="position() &lt; 7">
        Track&#32;&#32;
        <xsl:value-of select="."/>&#32;(<xsl:value-of select="../Lnge"/>)
      </xsl:if>
    </td>
  </xsl:template>

  <xsl:template match="Erscheinungsdatum">
    <td align="left">
      <b>erschienen:</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

  <xsl:template match="Genre">
    <td>
      <b>Genre:</b>
    </td>
    <xsl:choose>
      <xsl:when test=". = 'Classic Pop'">
        <td bgcolor="#FF3030">
          <xsl:value-of select="."/>          
        </td>
      </xsl:when>
      <xsl:when test=". = 'Irish Folk'">
        <td bgcolor="#3FD030">
          <xsl:value-of select="."/>          
        </td>
      </xsl:when>
      <xsl:when test=". = 'Sinfonie'">
        <td bgcolor="#80A0FF">
          <xsl:value-of select="."/>          
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:value-of select="."/>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="Aufnahmeparameter">
    <td>
      <b>Aufnahme:</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

  <xsl:template match="Speichermedium">
    <td>
      <b>gespeichert auf:</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

  <xsl:template match="Kommentar">
    <td>
      <b>Anmerkung:</b>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>

</xsl:stylesheet>
