#include <sys/types.h>
#include <ctype.h>

int
strncasecmp (const char *str1, const char *str2, size_t n)
{
  unsigned char c1, c2;
  if (str1 == str2 || n == 0)
    return 0;
  do
    {
      c1 = tolower (*str1), c2 = tolower (*str2);
      if (--n == 0 || c1 == '\0')
        break;
      str1++, str2++;
    }
  while (c1 == c2);
  return c1 - c2;
}
