// GarbageCollector.cs - demonstriert Steuerung des Garbage Collectors
// Aufruf: GarbageCollector [gc | fin]
//          (ohne)  keine Steuerung des Garbage Collectors
//           gc     erzwungene Garbage Collection
//           fin    erzwungene Garbage Collection und Finalisierung

using System;
using System.Threading;

namespace Destruct1
{

	// Testende Klasse 
	class GarbageCollect
    {
		public static StatusHolder sh = new StatusHolder(0);
        [STAThread]
        static void Main(string[] args)
        {
            MakeSomeObjectsWithDestructor();
			if (args.Length > 0 && args[0].ToUpper() == "GC")
			{
				GC.Collect();
				Console.WriteLine("GC");
			}
			if (args.Length > 0 && args[0].ToUpper() == "FIN")
			{
				Console.WriteLine("Fin");
				GC.Collect();
				GC.WaitForPendingFinalizers();
			}
			sh.AddStatus("Main()");
			// Ausfhrung der Destruktoren vor der Konsolenausgabe erzwingen
            GC.Collect();
			GC.WaitForPendingFinalizers(); // jetzt wird "~" ausgegeben
			// Ablauf ausgeben 
            Console.WriteLine(sh.Result()); 
            Console.ReadLine();
        }

        static void MakeSomeObjectsWithDestructor()
        {
            WithDestructor t1 = new WithDestructor(sh);
            WithDestructor t2 = new WithDestructor(sh);
            WithDestructor t3 = new WithDestructor(sh);
            WithDestructor t4 = new WithDestructor(sh);
            WithDestructor t5 = new WithDestructor(sh);
            sh.AddStatus("MakeSomeObjectsWithDestructor()");
        }
    }

	// Objekte dieser Klasse dokumentieren mit jedem Aufruf der Methode AddStatus() 
	// die aktuelle Thread-ID und einen Zhlerstand
    public class StatusHolder
    {
		private int Counter;  
        private string result = "";
		[System.Runtime.InteropServices.DllImport("kernel32.dll")]
		public static extern int GetCurrentThreadId();

		public StatusHolder(int i)  // Konstruktor
        {
			Counter = i;
			result = ("Methode\t\t\t\tThread-ID\tCounter\n" + new String('=',60)+"\n");
        }

		public void AddStatus(string method) // Dokumentation mit Zhlerstand unverndert
		{
			AddStatus(method, Counter);
		}

		public void AddStatus(string method, int counter) // Dokumentation
		{
			string s = method.PadRight(32, ' ') + GetCurrentThreadId().ToString()+"\t\t"+ counter +"\n";
			lock(this)
			{
				Counter = counter; 
				result += s ;
			}
		}
		public string Result()
		{
			return result;
		}
    }


    class WithDestructor
    {
		static int GeneratorCounter;
        int Id;
        StatusHolder sh;
        public WithDestructor(StatusHolder Sh)
        {
			Id = ++GeneratorCounter;
            sh = Sh;  // externes Objekt festhalten
        }
		~WithDestructor()
        {
			sh.AddStatus("~WithDestructor()", Id);
			Console.WriteLine("~");   // Ausgabe kostet etwas Zeit
        }
    }
}