//#define ActivateCalcTime
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace ThdPool
{
  public class Form1 : System.Windows.Forms.Form
  {
	private System.Windows.Forms.Button b5NewThreads;
	private System.Windows.Forms.ListBox listBox1;
	private System.Windows.Forms.Label lActiveThds;
	private System.Windows.Forms.Label label1;
	private System.Windows.Forms.Label label2;
	private System.Windows.Forms.Label lQueuedThds;
	private System.Windows.Forms.Timer timer1;
	private System.ComponentModel.IContainer components;

	public Form1()
	{
	  InitializeComponent();
	}
	protected override void Dispose( bool disposing )
	{
	  if( disposing )
	  {
		if (components != null)
		{
		  components.Dispose();
		}
	  }
	  base.Dispose( disposing );
	}

		#region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
      this.components = new System.ComponentModel.Container();
      this.b5NewThreads = new System.Windows.Forms.Button();
      this.listBox1 = new System.Windows.Forms.ListBox();
      this.lActiveThds = new System.Windows.Forms.Label();
      this.label1 = new System.Windows.Forms.Label();
      this.label2 = new System.Windows.Forms.Label();
      this.lQueuedThds = new System.Windows.Forms.Label();
      this.timer1 = new System.Windows.Forms.Timer(this.components);
      this.SuspendLayout();
      // 
      // b5NewThreads
      // 
      this.b5NewThreads.Location = new System.Drawing.Point(24, 8);
      this.b5NewThreads.Name = "b5NewThreads";
      this.b5NewThreads.Size = new System.Drawing.Size(176, 40);
      this.b5NewThreads.TabIndex = 0;
      this.b5NewThreads.Text = "Add 5 new Items to Threadpool";
      this.b5NewThreads.Click += new System.EventHandler(this.b5NewThreads_Click);
      // 
      // listBox1
      // 
      this.listBox1.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
        | System.Windows.Forms.AnchorStyles.Right);
      this.listBox1.Location = new System.Drawing.Point(24, 64);
      this.listBox1.Name = "listBox1";
      this.listBox1.Size = new System.Drawing.Size(336, 472);
      this.listBox1.TabIndex = 1;
      // 
      // lActiveThds
      // 
      this.lActiveThds.Location = new System.Drawing.Point(304, 32);
      this.lActiveThds.Name = "lActiveThds";
      this.lActiveThds.Size = new System.Drawing.Size(80, 23);
      this.lActiveThds.TabIndex = 2;
      this.lActiveThds.Text = "lActiveThds";
      // 
      // label1
      // 
      this.label1.Location = new System.Drawing.Point(208, 32);
      this.label1.Name = "label1";
      this.label1.Size = new System.Drawing.Size(96, 23);
      this.label1.TabIndex = 3;
      this.label1.Text = "Active Threads:";
      // 
      // label2
      // 
      this.label2.Location = new System.Drawing.Point(208, 8);
      this.label2.Name = "label2";
      this.label2.Size = new System.Drawing.Size(96, 16);
      this.label2.TabIndex = 5;
      this.label2.Text = "Queued Threads:";
      // 
      // lQueuedThds
      // 
      this.lQueuedThds.Location = new System.Drawing.Point(304, 8);
      this.lQueuedThds.Name = "lQueuedThds";
      this.lQueuedThds.Size = new System.Drawing.Size(80, 16);
      this.lQueuedThds.TabIndex = 4;
      this.lQueuedThds.Text = "lQueuedThds";
      // 
      // timer1
      // 
      this.timer1.Enabled = true;
      this.timer1.Interval = 200;
      this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(384, 549);
      this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                  this.label2,
                                                                  this.lQueuedThds,
                                                                  this.label1,
                                                                  this.lActiveThds,
                                                                  this.listBox1,
                                                                  this.b5NewThreads});
      this.Name = "Form1";
      this.Text = "Threadpool";
      this.ResumeLayout(false);

    }
		#endregion

	[STAThread]
	static void Main()
	{
	  Application.Run(new Form1());
	}

	// Variablen
	private ArrayList ActiveThds = new ArrayList();
	private ArrayList LogList = new ArrayList();
	private int NextThdID;
	private int TotalThds;
  private DateTime STime;    // Startzeitpunkt

	private void b5NewThreads_Click(object sender, System.EventArgs e)
	{
#if ActivateCalcTime

	  if (ActiveThds.Count == 0)
		CalcTime("idle");
#endif
	  TotalThds += 5;
	STime = DateTime.Now;
	  for(int x = 0; x < 5; x++)
	  {
		ThreadPool.QueueUserWorkItem(new WaitCallback(ThreadProc), NextThdID++);
	  }
#if ActivateCalcTime
	  if (TotalThds == 5)
	  { // Zeit frs Anlaufen der Threads
		Thread.Sleep(5000);
		CalcTime("with bg");
	  }
#endif
	}

	// Threadprozedur, wird als Workitem verwendet
	void ThreadProc(Object stateInfo)
	{
	  int InternalID = (int)stateInfo;
	  string logentry;
	  ActiveThds.Add(stateInfo);
	  for(int x = 0; x < 3; x++)
	  {
		logentry = String.Format("{0} Thread-No {1} 'loop{2}'", GT(), InternalID, x+1);
		lock(LogList)
		{
		  LogList.Add(logentry);
		}
#if ActivateCalcTime
	  TimeSpan ThreeSec = new TimeSpan(0, 0, 3);
	  DateTime StartTime = DateTime.Now;
	  while(DateTime.Now - StartTime < ThreeSec)
	  ; // leer
#else
		Thread.Sleep(3000);
#endif

	  }
	  logentry = String.Format("{0} Thread-No:{1} 'done'", GT(), InternalID);
	  lock(LogList)
	  {
		LogList.Add(logentry);
	  }
	  ActiveThds.Remove(stateInfo);
	  TotalThds--;
	}

	private string GT()
	{
	  TimeSpan ts = DateTime.Now-STime;
	  string secs = ts.Seconds + "." + ts.Milliseconds.ToString("000");
	  return String.Format("Secs:{0,6} Thread-ID:{1,4}", secs, AppDomain.GetCurrentThreadId());
	}

	// Polling fr Statusmeldungen der Threads
	// Aktualisiert Listenfeld. Setzt Zhlung zurck, wenn keine Items mehr aktiv sind
	private void timer1_Tick(object sender, System.EventArgs e)
	{
	  lock(LogList)  // Statusmeldungen der Threads in Liste bernehmen
	  {
		for (int x = 0; x < LogList.Count; x++)
		  listBox1.Items.Add(LogList[x]);
		LogList.Clear();
	  }
	  lActiveThds.Text = ActiveThds.Count.ToString();
	  lQueuedThds.Text = (TotalThds-ActiveThds.Count).ToString();

	  if (ActiveThds.Count == 0)   // alle fertig? Zhler zurcksetzen
	  {
		listBox1.Items.Clear();
		this.NextThdID = 0;
		STime = DateTime.Now;
	  }
	}
	private void CalcTime(string Msg)
	{
	  int Count = 0;
	  // Hochzhlen bis Sekundenwechsel
	  TimeSpan OneSec = new TimeSpan(0, 0, 1);
	  DateTime STime = DateTime.Now;
	  while (DateTime.Now - STime < OneSec)
		Count++;
	  listBox1.Items.Add(Msg+": "+Count.ToString());
	}
  }
}
