// Prozessbergreifender Mutex und Warten auf den Besitzbergang 
// im Vordergrund. Mehrere Instanzen des Programms starten!
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace MutexDemo
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox textBox1;
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(16, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(112, 32);
			this.button1.TabIndex = 0;
			this.button1.Text = "Acquire Mutex";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(16, 56);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(168, 128);
			this.textBox1.TabIndex = 1;
			this.textBox1.Text = "textBox1";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(224, 197);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.button1);
			this.Name = "Form1";
			this.Text = "MutexDemo";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		// Mutex nach dem Create der Form anlegen
		private Mutex mut;
		private void Form1_Load(object sender, System.EventArgs e)
		{
			bool CreatedNew; 
			mut = new Mutex(false, "MutexDemo", out CreatedNew);
			if (CreatedNew)
				textBox1.Text = "Mutex created\r\n";
			else
				textBox1.Text = "Mutex exists\r\n";

		}

    // sorgt dafr, dass die Warteschleife auf den Mutex
		// beendet wird, wenn der Benutzer das Schliefeld benutzt
		bool CloseRequest = false;
		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			CloseRequest = true;
		}

		// Besitzanforderung bzw. Abgabe des Mutex
		private void button1_Click(object sender, System.EventArgs e)
		{
			if (button1.Text == "Acquire Mutex")
			{
				textBox1.Text += "Trying to acquire ...\r\n";
				while (!mut.WaitOne(50, true))
				{
					Application.DoEvents();
					if (CloseRequest)
						return;
				}
				button1.Text = "Release Mutex";
				textBox1.Text += "Acquired!\r\n";
			}
			else
			{
				mut.ReleaseMutex();
				textBox1.Text += "Released\r\n" ;
				button1.Text = "Acquire Mutex";
			}
		}
	}
}
