/* WaitDemoForm.CS - Demo von WaitOne, WaitAny, WaitAll
 * (1) Auswahl der "Warteart", (2) Start eines Threads
 * (3) Setzen eines oder beider Events ber die Checkboxes
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace WaitDemo
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();
			textBox1.Text = "";
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.rbWaitAll = new System.Windows.Forms.RadioButton();
			this.rbWaitAny = new System.Windows.Forms.RadioButton();
			this.rbWaitOne = new System.Windows.Forms.RadioButton();
			this.Signal = new System.Windows.Forms.GroupBox();
			this.cbEvent2 = new System.Windows.Forms.CheckBox();
			this.cbEvent1 = new System.Windows.Forms.CheckBox();
			this.bStartWait = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.Signal.SuspendLayout();
			this.SuspendLayout();
			// 
			// textBox1
			// 
			this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBox1.Location = new System.Drawing.Point(16, 136);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(264, 112);
			this.textBox1.TabIndex = 0;
			this.textBox1.Text = "textBox1";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.rbWaitAll);
			this.groupBox1.Controls.Add(this.rbWaitAny);
			this.groupBox1.Controls.Add(this.rbWaitOne);
			this.groupBox1.Location = new System.Drawing.Point(16, 16);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(120, 104);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "(1) - Select Wait";
			// 
			// rbWaitAll
			// 
			this.rbWaitAll.Location = new System.Drawing.Point(8, 72);
			this.rbWaitAll.Name = "rbWaitAll";
			this.rbWaitAll.TabIndex = 2;
			this.rbWaitAll.Text = "WaitAll";
			// 
			// rbWaitAny
			// 
			this.rbWaitAny.Location = new System.Drawing.Point(8, 48);
			this.rbWaitAny.Name = "rbWaitAny";
			this.rbWaitAny.TabIndex = 1;
			this.rbWaitAny.Text = "WaitAny";
			// 
			// rbWaitOne
			// 
			this.rbWaitOne.Checked = true;
			this.rbWaitOne.Location = new System.Drawing.Point(8, 24);
			this.rbWaitOne.Name = "rbWaitOne";
			this.rbWaitOne.TabIndex = 0;
			this.rbWaitOne.TabStop = true;
			this.rbWaitOne.Text = "WaitOne";
			// 
			// Signal
			// 
			this.Signal.Controls.Add(this.cbEvent2);
			this.Signal.Controls.Add(this.cbEvent1);
			this.Signal.Location = new System.Drawing.Point(160, 48);
			this.Signal.Name = "Signal";
			this.Signal.Size = new System.Drawing.Size(120, 72);
			this.Signal.TabIndex = 2;
			this.Signal.TabStop = false;
			this.Signal.Text = "(3) Set Event(s)";
			// 
			// cbEvent2
			// 
			this.cbEvent2.Location = new System.Drawing.Point(8, 40);
			this.cbEvent2.Name = "cbEvent2";
			this.cbEvent2.TabIndex = 1;
			this.cbEvent2.Text = "Event 2";
			this.cbEvent2.CheckedChanged += new System.EventHandler(this.cbEvent2_CheckedChanged);
			// 
			// cbEvent1
			// 
			this.cbEvent1.Location = new System.Drawing.Point(8, 16);
			this.cbEvent1.Name = "cbEvent1";
			this.cbEvent1.TabIndex = 0;
			this.cbEvent1.Text = "Event 1";
			this.cbEvent1.CheckedChanged += new System.EventHandler(this.cbEvent1_CheckedChanged);
			// 
			// bStartWait
			// 
			this.bStartWait.Location = new System.Drawing.Point(160, 16);
			this.bStartWait.Name = "bStartWait";
			this.bStartWait.Size = new System.Drawing.Size(120, 23);
			this.bStartWait.TabIndex = 3;
			this.bStartWait.Text = "(2) Start Thread";
			this.bStartWait.Click += new System.EventHandler(this.bStartWait_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(296, 269);
			this.Controls.Add(this.bStartWait);
			this.Controls.Add(this.Signal);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.textBox1);
			this.Name = "Form1";
			this.Text = "WaitDemo";
			this.groupBox1.ResumeLayout(false);
			this.Signal.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton rbWaitOne;
		private System.Windows.Forms.RadioButton rbWaitAny;
		private System.Windows.Forms.RadioButton rbWaitAll;
		private System.Windows.Forms.CheckBox cbEvent1;
		private System.Windows.Forms.GroupBox Signal;
		private System.Windows.Forms.CheckBox cbEvent2;
		private System.Windows.Forms.Button bStartWait;

		AutoResetEvent Event1 = new AutoResetEvent(false);
		AutoResetEvent Event2 = new AutoResetEvent(false);

		// (1) - Art des Wartens aussuchen
		private void rbWaitOne_CheckedChanged(object sender, System.EventArgs e)
		{
			cbEvent2.Enabled = (sender != rbWaitOne);
			cbEvent1.Checked = false; 
			cbEvent2.Checked = false; 

		}

    // (2) Start eines Hintergrund-Threads
		private void bStartWait_Click(object sender, System.EventArgs e)
		{
			ThreadPool.QueueUserWorkItem(new WaitCallback(BGThread));
		}

		// Der Hintergrundthread daselbst
		private void BGThread(object state)
		{
			  bStartWait.Enabled = false;

				if (rbWaitOne.Checked)           // WaitOne
				{ // warten auf Event1
					textBox1.Text += "Wait for Event 1\r\n";
					Event1.WaitOne();
					textBox1.Text += "Event1 signalled\r\n";
				}

				if (rbWaitAny.Checked)         
				{ // warten auf einen der beiden Events
					textBox1.Text += "Wait for Event 1 OR 2\r\n";
					int WaitRes = WaitHandle.WaitAny(new WaitHandle[] {Event1, Event2} );
          textBox1.Text += String.Format("Event{0} signalled\r\n", WaitRes+1);
				}

				if (rbWaitAll.Checked)          
				{ // warten auf beide Events
					textBox1.Text += "Wait for Event 1 AND 2\r\n";
					WaitHandle.WaitAll(new WaitHandle[] {Event1, Event2} );
					textBox1.Text += String.Format("Event1 AND 2 signalled\r\n");
				}
			  
			  Thread.Sleep(300);
			  bStartWait.Enabled = true;
			  cbEvent1.Checked = false;
			  cbEvent2.Checked = false;
		 	}

    // (3) Event(s) setzen 
		private void cbEvent1_CheckedChanged(object sender, System.EventArgs e)
		{
		    if (cbEvent1.Checked) Event1.Set();
							else Event1.Reset();
		}

		private void cbEvent2_CheckedChanged(object sender, System.EventArgs e)
		{
				if (cbEvent2.Checked) Event2.Set();
				else Event2.Reset();
		}
	}
}