// TestAsyncClass.cs - 

using System;
using System.ComponentModel;
using System.Windows.Forms;


namespace AsyncClass
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Button button1;
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.Button button2;
    private System.Windows.Forms.RadioButton radioButton2;
    private System.Windows.Forms.RadioButton radioThdPool;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
      this.button1 = new System.Windows.Forms.Button();
      this.textBox1 = new System.Windows.Forms.TextBox();
      this.button2 = new System.Windows.Forms.Button();
      this.radioThdPool = new System.Windows.Forms.RadioButton();
      this.radioButton2 = new System.Windows.Forms.RadioButton();
      this.SuspendLayout();
      // 
      // button1
      // 
      this.button1.Location = new System.Drawing.Point(16, 16);
      this.button1.Name = "button1";
      this.button1.Size = new System.Drawing.Size(136, 32);
      this.button1.TabIndex = 0;
      this.button1.Text = "BeginWork";
      this.button1.Click += new System.EventHandler(this.button1_Click);
      // 
      // textBox1
      // 
      this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
        | System.Windows.Forms.AnchorStyles.Left) 
        | System.Windows.Forms.AnchorStyles.Right)));
      this.textBox1.Location = new System.Drawing.Point(8, 64);
      this.textBox1.Multiline = true;
      this.textBox1.Name = "textBox1";
      this.textBox1.Size = new System.Drawing.Size(464, 232);
      this.textBox1.TabIndex = 1;
      this.textBox1.Text = "";
      // 
      // button2
      // 
      this.button2.Location = new System.Drawing.Point(192, 16);
      this.button2.Name = "button2";
      this.button2.Size = new System.Drawing.Size(88, 32);
      this.button2.TabIndex = 2;
      this.button2.Text = "Clear Textbox";
      this.button2.Click += new System.EventHandler(this.button2_Click);
      // 
      // radioThdPool
      // 
      this.radioThdPool.Checked = true;
      this.radioThdPool.Location = new System.Drawing.Point(304, 8);
      this.radioThdPool.Name = "radioThdPool";
      this.radioThdPool.Size = new System.Drawing.Size(160, 24);
      this.radioThdPool.TabIndex = 3;
      this.radioThdPool.TabStop = true;
      this.radioThdPool.Text = "ThreadPool/BeginInvoke";
      // 
      // radioButton2
      // 
      this.radioButton2.Location = new System.Drawing.Point(304, 32);
      this.radioButton2.Name = "radioButton2";
      this.radioButton2.Size = new System.Drawing.Size(160, 24);
      this.radioButton2.TabIndex = 4;
      this.radioButton2.Text = "ohne ThreadPool";
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(480, 306);
      this.Controls.Add(this.radioButton2);
      this.Controls.Add(this.radioThdPool);
      this.Controls.Add(this.button2);
      this.Controls.Add(this.textBox1);
      this.Controls.Add(this.button1);
      this.Name = "Form1";
      this.Text = "AsyncClassDemo";
      this.ResumeLayout(false);

    }
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    int counter = 1; 
    AsyncWorkNoPool awnp = new AsyncWorkNoPool(); 
    AsyncWork aw = new AsyncWork(); 
    private void button1_Click(object sender, System.EventArgs e)
    {
      if (radioThdPool.Checked)
        TestAsyncWork(aw);  
      else
        TestAsyncWorkNoPool(awnp);  
    }

    private void TestAsyncWork(AsyncWork ac)
    {
      output("button1_Click: Thread-ID " + AppDomain.GetCurrentThreadId().ToString()); 
      string job = "job" + counter++.ToString(); 
      // Asynchroner Aufruf
      IAsyncResult ares = ac.BeginWork(new AsyncCallback(WorkCB), 
        job, "user parameter for " + job); 
      output(" BeginWork called, Waiting for result of " + job +"\r\n"); 
      // UI-Reaktivitt aufrechterhalten
      while(!ares.IsCompleted)
      {
        Application.DoEvents();  
        output("."); 
        System.Threading.Thread.Sleep(100); 
      }
      string res = ac.EndWork(ares); 
      output("button1_Click: EndWork returned: " + res + "\r\n"); 
    }

    private void TestAsyncWorkNoPool(AsyncWorkNoPool ac)
    {
      output("button1_Click: Thread-ID " + AppDomain.GetCurrentThreadId().ToString()); 
      string job = "job" + counter++.ToString(); 
      // Asynchroner Aufruf
      IAsyncResult ares = ac.BeginWork(new AsyncCallback(WorkCB), 
        job, "user parameter for " + job); 
      output(" BeginWork called, Waiting for result of " + job +"\r\n"); 
      // UI-Reaktivitt aufrechterhalten
      while(!ares.IsCompleted)
      {
        Application.DoEvents();  
        output("."); 
        System.Threading.Thread.Sleep(100); 
      }
      string res = ac.EndWork(ares); 
      output("button1_Click: EndWork returned: " + res + "\r\n"); 
    }

    private void output(string s)
    {
      lock(this)  // wegen 
      {
        textBox1.Text += s; 
      }
    }

    // reentrante Rckrufmethode
    private void WorkCB(IAsyncResult ares)
    {
      // Argument fr Rckruf ermitteln
      string arg = ares.AsyncState.ToString(); 
      output("WorkCB: Thread-ID " + AppDomain.GetCurrentThreadId().ToString() 
          + " Param: " + arg + "\r\n"); 
    }

    private void button2_Click(object sender, System.EventArgs e)
    {
      textBox1.Text = ""; 
      counter = 1; 
    }
	}

  // Implementation vie Delegate.BeginInvoke und Threadpool
  class AsyncWork 
  {
    private delegate string WorkDelegate(string job);  
    private WorkDelegate wd;  
    public IAsyncResult BeginWork(AsyncCallback cb, string job, object userParam)
    {
      if (wd == null)
        wd = new WorkDelegate(Work); 
      return wd.BeginInvoke(job, cb, userParam); 
    }
    private string Work(string job) 
    {
      DateTime start = DateTime.Now; 
      // Zwischen 1,5 und 4 Sekunden schlafen
      System.Threading.Thread.Sleep(500 + new System.Random().Next(500)); 
      return "Work: Thread-ID " + AppDomain.GetCurrentThreadId().ToString() + " Param: " + job; 
    }
    public string EndWork(IAsyncResult ares)
    {
      return wd.EndInvoke(ares); 
    }
  }

  class AsyncWorkNoPool 
  {
    public IAsyncResult BeginWork(AsyncCallback cb, string param, object userParam)
    {
      // Thread starten, endet mit Client Rckruf
      return (new AsyncThread(new WorkDelegate(_work), param, cb, userParam)); 
    }
    public string EndWork(IAsyncResult ares)
    {
      AsyncThread athd = (AsyncThread) ares; 
      athd.AsyncWaitHandle.WaitOne(); 
      athd.complSync = true; 
      return (string) athd.AsyncResult; 
    }
    private object _work(object param)
    {
      DateTime start = DateTime.Now; 
      // Zwischen 1,5 und 4 Sekunden schlafen
      System.Threading.Thread.Sleep(500 + new System.Random().Next(500)); 
      return "Work: Thread-ID " + AppDomain.GetCurrentThreadId().ToString() + " Param: " + param; 
    }
    public string Work(string param)
    {
      return (string) _work(param); 
    }
  }
}
