/* mt.c von Harald Bgeholz / c't */

#include "mt.h"
#include <msp430x14x.h>
#include <msp430def.h>         

/* ---- private Funktionen ----------------------------------------- */
static void schedule(void);
static void schedule_isr(void); /* ###interrupt routine!### */


/* ---- private globale Variablen ---------------------------------- */
static MT_TCB main_tcb;
static MT_TCB *current_thread;
static word SP;

/* ----------------------------------------------------------------- */

static void fix_compiler_bug(void)
{ /* tut nichts, dient nur der Umgehung eines Compiler-Bugs */
}

#pragma monitor MT_init
void MT_init(byte timeslice)
{
  main_tcb.timeslice = timeslice;
  main_tcb.ticksleft = timeslice;
  main_tcb.next = &main_tcb;
  current_thread = &main_tcb;

  /* Timer A in Betrieb nehmen fr Aufruf des Schedulers */
  TACTL = TASSEL1 + TACLR;        /* SMCLK, Zhler lschen */
  CCTL0 = CCIE;                   /* CCR0 interrupt enable */
  CCR0 = 40000;                   /* 5 ms */
  TACTL |= MC0;                   /* Up-Mode */
} /* MT_init() */


#pragma monitor MT_start_thread
void MT_start_thread(MT_TCB *tcb, void (*function)(void), 
                     word timeslice, 
                     word *stack, word stackwords)
{
  word SR;

  stack[stackwords-1] = (word)&MT_killself;
  stack[stackwords-2] = (word)function;
  asm ("mov sr, %SR\n");
  stack[stackwords-3] = SR | GIE; /* Interrupts einschalten */
  tcb->sp = (word)(stack + stackwords - 12 - 3);
  
  /* Stackaufbau des neuen Threads:
     
     Addresse von MT_killself()
     Addresse der auszufhrenden Funktion
     Statusregister mit aktivierten Interrupts
     r4  (nicht initialisiert)
     r5  (nicht initialisiert)
     r6  (nicht initialisiert)
     r7  (nicht initialisiert)
     r8  (nicht initialisiert)
     r9  (nicht initialisiert)
     r10 (nicht initialisiert)
     r11 (nicht initialisiert)
     r12 (nicht initialisiert)
     r13 (nicht initialisiert)
     r14 (nicht initialisiert)
SP-> r15 (nicht initialisiert) */

  tcb->timeslice = timeslice;
  tcb->ticksleft = timeslice;
  
  tcb->next = current_thread->next;
  current_thread->next = tcb;
} /* MT_start_thread() */


#pragma monitor MT_killself
void MT_killself(void)
{
  MT_TCB *p;

  if (current_thread == &main_tcb)
    { /* FIXME: Haupt-Thread darf sich nicht umbringen. */
      for (;;)
        MT_reschedule();
    }
      
  current_thread->sp = 0; /* zeigt an, dass Thread beendet */
  for (p=current_thread; p->next != current_thread; p=p->next)
    ; /* Vorgnger in Thread-Liste finden */
  p->next = current_thread->next;
  current_thread->next = NULL;
  current_thread = p->next;
  fix_compiler_bug();
  SP = current_thread->sp;

  TACTL |= TACLR; /* Timerzhler auf null */
  TACCTL0 &= ~CCIFG; /* Interruptflag lschen */

  asm("jmp REENTRY\n"); /* hsslich: Sprung mitten in schedule_isr() */
} /* MT_killself() */


#pragma monitor MT_reschedule
void MT_reschedule(void)
{
  TACTL |= TACLR; /* Timerzhler auf null */
  TACCTL0 &= ~CCIFG; /* Interruptflag lschen */
  current_thread->ticksleft = 1; /* dies ist der letzte Timer-Tick */

  /* simuliere Timer-Interrupt, damit nchster Thread dran kommt */
  asm( "push #RETURN\n"
       "push sr\n"
       "jmp _schedule_isr\n"
       "RETURN:\n" );
} /* MT_reschedule() */


#pragma ctask schedule
static void schedule(void)
{
  if (--current_thread->ticksleft == 0)
    { /* Kontextwechsel */
      current_thread->ticksleft = current_thread->timeslice;
      current_thread->sp = SP;
      current_thread = current_thread->next;
      fix_compiler_bug();
      SP = current_thread->sp;
    }
} /* schedule() */


#pragma interrupt_handler schedule_isr:TIMERA0_VECTOR
static void schedule_isr(void) /* ###interrupt routine!### */
{ /* in diese Funktion auf keinen Fall C-Code einfgen! */
  asm( "push r4\n"
       "push r5\n"
       "push r6\n"
       "push r7\n"
       "push r8\n"
       "push r9\n"
       "push r10\n"
       "push r11\n"
       "push r12\n"
       "push r13\n"
       "push r14\n"
       "push r15\n"
       "mov sp, %SP\n"
       "call #_schedule\n"
       "REENTRY: mov %SP, sp\n"
       "pop r15\n"
       "pop r14\n"
       "pop r13\n"
       "pop r12\n"
       "pop r11\n"
       "pop r10\n" 
       "pop r9\n"
       "pop r8\n"
       "pop r7\n"
       "pop r6\n"
       "pop r5\n"
       "pop r4\n" );
  /*    reti vom Compiler erzeugt */
} /* schedule() ###interrupt routine!### */

