/* testmt.c von Harald Bgeholz / c't */

#include "cdef.h"               /* allgemeine Typendefinitionen */
#include <msp430x14x.h>         /* MSP430-Definitionen */
#include <msp430def.h>

#include "mt.h"

#define MY_STACKWORDS (MT_MIN_STACKWORDS + 20)

/* ---- Funktions-Prototypen --------------------------------------- */
void vClockInit(void);
void vPortInit(void);
void thread1(void);
void restart2(void);
void thread2(void);
void thread3(void);
void main(void);




word stack1[MY_STACKWORDS];
MT_TCB tcb1;
word stack2[MY_STACKWORDS];
MT_TCB tcb2;
word stack3[MY_STACKWORDS];
MT_TCB tcb3;

/***************************************************************************
*    Funktion:  Hardware-Initialisierung
*    Autor:     Jens Altenburg 
****************************************************************************/
/* Oszillator 8MHz  */
void vClockInit(void)
{
  word w;
  WDTCTL = WDTPW + WDTHOLD;       /* Watchdog abschalten */
#if 1 /* fr Testzwecke */
    P5DIR |= 0x10;                  /* 8MHz-CLK an pin 48 */
    P5SEL |= 0x10;
    P5DIR |= 0x20;                  /* SMCLK an pin 49 */
    P5SEL |= 0x20;
#endif
    BCSCTL1 &= ~XT2OFF;             /* Oszillator an */
    do  
      { /* testen, ob 8-MHz-Oszillator luft */
        IFG1 &= ~OFIFG;
        for(w = 0xff; w > 0; w--);
      }
    while((IFG1 & OFIFG) != 0);
    BCSCTL2 = 0x88;
    //     BCSCTL2 |= SELM1 + SELS + DIVS0;  
}

/* I/O Ports */
void vPortInit(void)
{
  P1OUT   = 0x00;                 /* all output, no interrupt */
  P1DIR   = 0x7F;
  P1IES   = 0x00;
  P1IE    = 0x00;
  P1SEL   = 0x00;
  P2OUT   = 0x00;                 /* all output LED on pin 0...2       */
  P2DIR   = 0xFF;                 /*       ----    | /|                */
  P2IES   = 0x00;                 /*  o---|    |---|< |---o Vcc (3.3V) */
  P2IE    = 0x00;                 /*       ----    | \| LED            */
  P2SEL   = 0x00;                 /*  Pin 0...2                        */
  
  P3OUT   = 0x00;                 /* UART0, P3.4 output */
  P3DIR   = 0x10;
  P3SEL   = 0x30;
  
  P4OUT   = 0xFE;                 /* CFG - Port */
  P4DIR   = 0x7f;
  P4SEL   = 0x00;
#if 0
  P5OUT   = 0x00;                 /* not used */
  P5DIR   = 0x00;
  P5SEL   = 0x00;
#endif
  P6OUT   = 0x00;                 /* not used */
  P6DIR   = 0x00;
  P6SEL   = 0x03;                 /* A/D-converter, not used */
}


#pragma ctask thread1
void thread1(void)
{
  dword dw;

  for (;;)
    {
      for (dw=100000; dw--; )
        ;
      P2OUT ^= 2; /* P2.1 umschalten */
      restart2();
    }
} /* thread1() */


#pragma monitor restart2
void restart2(void)
{
  if (tcb2.sp == 0)
    MT_start_thread(&tcb2, &thread2, 1, stack2, MY_STACKWORDS);
} /* restart2() */


#pragma ctask thread2
void thread2(void)
{
  dword dw;
  word i, j, prime;

  for (i=2; i<20; ++i)
    {
      prime = 1;
      for (j=2; j*j <= i; ++j)
        if (i % j == 0)
          {
            prime = 0;
            break;
          }
      if (prime)
        {
          for (j=0; j<i; ++j)
            {
              P2OUT |= 4; /* P2.2 an */
              for (dw=2000; dw--; )
                ;
              P2OUT ^= 4; /* P2.2 aus */
              for (dw=8000; dw--; )
                ;
            }
          for (dw=60000; dw--; )
            ;
        }
    }
} /* thread2() */


#pragma ctask thread3
void thread3(void)
{
  for (;;)
    {
      P2OUT ^= 0x80;
      MT_reschedule();
    }
}


void main(void)
{
  dword dw;

  vClockInit();
  vPortInit();

  MT_init(1);
  MT_start_thread(&tcb1, &thread1, 1, stack1, MY_STACKWORDS);
  MT_start_thread(&tcb3, &thread3, 1, stack3, MY_STACKWORDS);

  asm("eint");

  for (;;)
    {
      for (dw=20000; dw--; )
        ;
      P2OUT ^= 1; /* P2.0 umschalten */
    }
}
