
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using ACTIVELISTENPROJECTLib; 


namespace test
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.Button bSpeak;
    private AxACTIVELISTENPROJECTLib.AxDirectSR axDirectSR1;
    private System.Windows.Forms.Button bGeneralListen;
    private System.Windows.Forms.ProgressBar progressBar1;
    private System.Windows.Forms.CheckBox checkBox1;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Button bGeneralSpeak;
    private System.Windows.Forms.TextBox tListen;
    private AxACTIVEVOICEPROJECTLib.AxDirectSS axDirectSS1;
    private System.Windows.Forms.ListBox listBox1;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.TextBox tRecognized;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();

      // TTS
      for (int i = 0; i< axDirectSS1.CountEngines; i++)
      {
        string entry = 
          axDirectSS1.ModeName(i+1) + "; " +
          axDirectSS1.Speaker(i+1) + "; " +
          axDirectSS1.Dialect(i+1) + "; " + 
          axDirectSS1.ProductName(i+1);
        listBox1.Items.Add(entry); 
      }
      if (listBox1.Items.Count>0)
        listBox1.SelectedIndex = 0; 
      // STT
      InitLexicon(); 
      axDirectSR1.Activate(); 
      // Download von STT-Engine, Control Panel (W2K) und deutscher TTS-Sprachengine
      // http://www.microsoft.com/msagent/downloads/user.asp#sr
      // Referenz der Schnittstellen 
      // http://www.text-reader.com/ttshelp/DirectSRMethods.html
      // http://www.text-reader.com/ttshelp/DirectTTSProps.html
      // Comerzielle Spracherkennung: http://www.speechstudio.com/commercial/speech.htm#RECO

		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
      System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
      this.textBox1 = new System.Windows.Forms.TextBox();
      this.bSpeak = new System.Windows.Forms.Button();
      this.bGeneralSpeak = new System.Windows.Forms.Button();
      this.bGeneralListen = new System.Windows.Forms.Button();
      this.axDirectSR1 = new AxACTIVELISTENPROJECTLib.AxDirectSR();
      this.progressBar1 = new System.Windows.Forms.ProgressBar();
      this.checkBox1 = new System.Windows.Forms.CheckBox();
      this.tListen = new System.Windows.Forms.TextBox();
      this.label1 = new System.Windows.Forms.Label();
      this.axDirectSS1 = new AxACTIVEVOICEPROJECTLib.AxDirectSS();
      this.listBox1 = new System.Windows.Forms.ListBox();
      this.label2 = new System.Windows.Forms.Label();
      this.label3 = new System.Windows.Forms.Label();
      this.tRecognized = new System.Windows.Forms.TextBox();
      ((System.ComponentModel.ISupportInitialize)(this.axDirectSR1)).BeginInit();
      ((System.ComponentModel.ISupportInitialize)(this.axDirectSS1)).BeginInit();
      this.SuspendLayout();
      // 
      // textBox1
      // 
      this.textBox1.Location = new System.Drawing.Point(288, 32);
      this.textBox1.Multiline = true;
      this.textBox1.Name = "textBox1";
      this.textBox1.Size = new System.Drawing.Size(136, 72);
      this.textBox1.TabIndex = 2;
      this.textBox1.Text = "Sprechtext eingeben";
      // 
      // bSpeak
      // 
      this.bSpeak.Location = new System.Drawing.Point(288, 144);
      this.bSpeak.Name = "bSpeak";
      this.bSpeak.Size = new System.Drawing.Size(136, 24);
      this.bSpeak.TabIndex = 3;
      this.bSpeak.Text = "Sprechen";
      this.bSpeak.Click += new System.EventHandler(this.bSpeak_Click);
      // 
      // bGeneralSpeak
      // 
      this.bGeneralSpeak.Location = new System.Drawing.Point(288, 112);
      this.bGeneralSpeak.Name = "bGeneralSpeak";
      this.bGeneralSpeak.Size = new System.Drawing.Size(136, 24);
      this.bGeneralSpeak.TabIndex = 5;
      this.bGeneralSpeak.Text = "Einstellungen";
      this.bGeneralSpeak.Click += new System.EventHandler(this.bGeneralSpeak_Click);
      // 
      // bGeneralListen
      // 
      this.bGeneralListen.Location = new System.Drawing.Point(288, 248);
      this.bGeneralListen.Name = "bGeneralListen";
      this.bGeneralListen.Size = new System.Drawing.Size(136, 24);
      this.bGeneralListen.TabIndex = 7;
      this.bGeneralListen.Text = "Einstellungen";
      this.bGeneralListen.Click += new System.EventHandler(this.bGeneralListen_Click);
      // 
      // axDirectSR1
      // 
      this.axDirectSR1.Enabled = true;
      this.axDirectSR1.Location = new System.Drawing.Point(448, 232);
      this.axDirectSR1.Name = "axDirectSR1";
      this.axDirectSR1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axDirectSR1.OcxState")));
      this.axDirectSR1.Size = new System.Drawing.Size(214, 214);
      this.axDirectSR1.TabIndex = 8;
      this.axDirectSR1.PhraseFinish += new AxACTIVELISTENPROJECTLib._DirectSREvents_PhraseFinishEventHandler(this.axDirectSR1_PhraseFinish);
      this.axDirectSR1.VUMeter += new AxACTIVELISTENPROJECTLib._DirectSREvents_VUMeterEventHandler(this.axDirectSR1_VUMeter);
      // 
      // progressBar1
      // 
      this.progressBar1.Location = new System.Drawing.Point(448, 448);
      this.progressBar1.Maximum = 16;
      this.progressBar1.Minimum = 4;
      this.progressBar1.Name = "progressBar1";
      this.progressBar1.Size = new System.Drawing.Size(208, 23);
      this.progressBar1.TabIndex = 10;
      this.progressBar1.Value = 4;
      // 
      // checkBox1
      // 
      this.checkBox1.Appearance = System.Windows.Forms.Appearance.Button;
      this.checkBox1.Checked = true;
      this.checkBox1.CheckState = System.Windows.Forms.CheckState.Checked;
      this.checkBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
      this.checkBox1.Location = new System.Drawing.Point(288, 280);
      this.checkBox1.Name = "checkBox1";
      this.checkBox1.Size = new System.Drawing.Size(136, 24);
      this.checkBox1.TabIndex = 11;
      this.checkBox1.Text = "Spracherkennung aus";
      this.checkBox1.CheckedChanged += new System.EventHandler(this.checkBox1_CheckedChanged);
      // 
      // tListen
      // 
      this.tListen.Location = new System.Drawing.Point(8, 248);
      this.tListen.Multiline = true;
      this.tListen.Name = "tListen";
      this.tListen.ScrollBars = System.Windows.Forms.ScrollBars.Both;
      this.tListen.Size = new System.Drawing.Size(264, 224);
      this.tListen.TabIndex = 12;
      this.tListen.Text = "As time goes by";
      this.tListen.TextChanged += new System.EventHandler(this.tListen_TextChanged);
      this.tListen.Leave += new System.EventHandler(this.tListen_Leave);
      this.tListen.Enter += new System.EventHandler(this.tListen_Enter);
      // 
      // label1
      // 
      this.label1.Location = new System.Drawing.Point(8, 224);
      this.label1.Name = "label1";
      this.label1.Size = new System.Drawing.Size(272, 16);
      this.label1.TabIndex = 14;
      this.label1.Text = "Lexikon (engl. Kommandos zeilenweise eingeben)";
      // 
      // axDirectSS1
      // 
      this.axDirectSS1.Enabled = true;
      this.axDirectSS1.Location = new System.Drawing.Point(448, 16);
      this.axDirectSS1.Name = "axDirectSS1";
      this.axDirectSS1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axDirectSS1.OcxState")));
      this.axDirectSS1.Size = new System.Drawing.Size(214, 214);
      this.axDirectSS1.TabIndex = 18;
      // 
      // listBox1
      // 
      this.listBox1.HorizontalScrollbar = true;
      this.listBox1.Location = new System.Drawing.Point(8, 32);
      this.listBox1.Name = "listBox1";
      this.listBox1.Size = new System.Drawing.Size(264, 147);
      this.listBox1.TabIndex = 20;
      this.listBox1.SelectedIndexChanged += new System.EventHandler(this.listBox1_SelectedIndexChanged);
      // 
      // label2
      // 
      this.label2.Location = new System.Drawing.Point(8, 16);
      this.label2.Name = "label2";
      this.label2.Size = new System.Drawing.Size(100, 16);
      this.label2.TabIndex = 21;
      this.label2.Text = "Engines";
      // 
      // label3
      // 
      this.label3.Location = new System.Drawing.Point(288, 16);
      this.label3.Name = "label3";
      this.label3.Size = new System.Drawing.Size(100, 16);
      this.label3.TabIndex = 22;
      this.label3.Text = "Sprechtext";
      // 
      // tRecognized
      // 
      this.tRecognized.Location = new System.Drawing.Point(288, 320);
      this.tRecognized.Multiline = true;
      this.tRecognized.Name = "tRecognized";
      this.tRecognized.ReadOnly = true;
      this.tRecognized.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
      this.tRecognized.Size = new System.Drawing.Size(136, 152);
      this.tRecognized.TabIndex = 23;
      this.tRecognized.Text = "erkannte Kommandos";
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(664, 482);
      this.Controls.Add(this.tRecognized);
      this.Controls.Add(this.label3);
      this.Controls.Add(this.label2);
      this.Controls.Add(this.listBox1);
      this.Controls.Add(this.axDirectSS1);
      this.Controls.Add(this.label1);
      this.Controls.Add(this.tListen);
      this.Controls.Add(this.checkBox1);
      this.Controls.Add(this.progressBar1);
      this.Controls.Add(this.axDirectSR1);
      this.Controls.Add(this.bGeneralListen);
      this.Controls.Add(this.bGeneralSpeak);
      this.Controls.Add(this.bSpeak);
      this.Controls.Add(this.textBox1);
      this.Name = "Form1";
      this.Text = "Test Speech Controls";
      ((System.ComponentModel.ISupportInitialize)(this.axDirectSR1)).EndInit();
      ((System.ComponentModel.ISupportInitialize)(this.axDirectSS1)).EndInit();
      this.ResumeLayout(false);

    }
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    private void bGeneralSpeak_Click(object sender, System.EventArgs e)
    {
      axDirectSS1.GeneralDlg(new Form().Handle.ToInt32(),"General");
    }

    private void bSpeak_Click(object sender, System.EventArgs e)
    {
      axDirectSS1.Speak(textBox1.Text); 
    }

    private void InitLexicon()
    {
      string [] commands; 
      string grammar ="langid = 1031\n\rtype=cfg\r\n[<Start>]\r\n";
      commands = tListen.Text.Split('\n'); 
      string newCommand; 
      foreach(string c in commands)
      {
        newCommand = c; 
        if (c.EndsWith("\r"))
          newCommand = c.Substring(0,c.Length-1); 
        grammar += "<start>=" + newCommand + "\r\n"; 
      }
      axDirectSR1.GrammarFromString(grammar); 
    }


    private void bGeneralListen_Click(object sender, System.EventArgs e)
    {
      if(checkBox1.Checked)
      {
        checkBox1.Checked = false; 
        axDirectSR1.GeneralDlg(new Form().Handle.ToInt32(),"Lexicon");
        checkBox1.Checked = true; 
      }
      else
        axDirectSR1.GeneralDlg(new Form().Handle.ToInt32(),"Lexicon");
    }

    private void axDirectSR1_PhraseFinish(object sender, AxACTIVELISTENPROJECTLib._DirectSREvents_PhraseFinishEvent e)
    {
      if (e.phrase != "")
      {
        axDirectSS1.Speak(e.phrase); 
        tRecognized.Text += "\r\n"+e.phrase; 
      }
    }

    private void axDirectSR1_VUMeter(object sender, AxACTIVELISTENPROJECTLib._DirectSREvents_VUMeterEvent e)
    {
      progressBar1.Value = (int)Math.Log(e.level, 2); 
    }

    private void checkBox1_CheckedChanged(object sender, System.EventArgs e)
    {
      if(checkBox1.Checked)
      {
        axDirectSR1.Activate(); 
        checkBox1.Text = "Spracherkennung aus"; 
      }
      else
      {
        axDirectSR1.Deactivate(); 
        checkBox1.Text = "Spracherkennung ein"; 
      }
    }

    private void tListen_Enter(object sender, System.EventArgs e)
    {
      if(checkBox1.Checked)
      {
        checkBox1.Checked = false; 
      }
    }

    bool dirty = false; 
    private void tListen_TextChanged(object sender, System.EventArgs e)
    {
      dirty = true; 
    }

    private void tListen_Leave(object sender, System.EventArgs e)
    {
      if (dirty)
      {
        InitLexicon(); 
      }
      dirty = false; 
    }
    private void listBox1_SelectedIndexChanged(object sender, System.EventArgs e)
    {
			int current = axDirectSS1.CurrentMode; 
			try
			{
				axDirectSS1.CurrentMode = listBox1.SelectedIndex +1; 
			}
			catch
			{
				listBox1.SelectedIndex = current -1; 
			}
    }
  }
}
