using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Diagnostics; 

namespace CSharpNETComponent
{
  /// <summary>
  /// Zusammenfassung fr Form2.
  /// </summary>
  public class Form2 : System.Windows.Forms.Form
  {
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.Button bSameAssembly;
		private System.Windows.Forms.Button bOutProcHttp;
		private System.Windows.Forms.Button bInProc;
		private System.Windows.Forms.Button bOutProcCAO;
		private System.Windows.Forms.Button bOutProcTcp;
    /// <summary>
    /// Erforderliche Designervariable.
    /// </summary>
    private System.ComponentModel.Container components = null;

    public Form2()
    {
      InitializeComponent();
    }
    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
        if (components != null) 
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

    #region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.bOutProcTcp = new System.Windows.Forms.Button();
			this.bInProc = new System.Windows.Forms.Button();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.bSameAssembly = new System.Windows.Forms.Button();
			this.bOutProcHttp = new System.Windows.Forms.Button();
			this.bOutProcCAO = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 56);
			this.label1.TabIndex = 0;
			this.label1.Text = "Laufzeitvergleiche fr Aufrufe minimalistischer Methoden. Bestimmend sollte das M" +
				"arshalling der Parameter sein. ";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 88);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(184, 80);
			this.label2.TabIndex = 1;
			this.label2.Text = "Bei out-of-process-Servern wird der Zeitbedarf fr 1 Million Aufrufe vom Programm" +
				" hochgerechnet - sonst wrde es recht lange dauern";
			// 
			// bOutProcTcp
			// 
			this.bOutProcTcp.Location = new System.Drawing.Point(24, 280);
			this.bOutProcTcp.Name = "bOutProcTcp";
			this.bOutProcTcp.Size = new System.Drawing.Size(168, 40);
			this.bOutProcTcp.TabIndex = 11;
			this.bOutProcTcp.Text = "SAO OutProc TCP-Remoting (startet Server Prozess)";
			this.bOutProcTcp.Click += new System.EventHandler(this.bOutProcTcp_Click);
			// 
			// bInProc
			// 
			this.bInProc.Location = new System.Drawing.Point(24, 232);
			this.bInProc.Name = "bInProc";
			this.bInProc.Size = new System.Drawing.Size(168, 32);
			this.bInProc.TabIndex = 10;
			this.bInProc.Text = "InProc spte Bindung (DLL, GAC)";
			this.bInProc.Click += new System.EventHandler(this.bInProc_Click);
			// 
			// textBox1
			// 
			this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBox1.BackColor = System.Drawing.SystemColors.Info;
			this.textBox1.Location = new System.Drawing.Point(200, 16);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ReadOnly = true;
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(216, 424);
			this.textBox1.TabIndex = 9;
			this.textBox1.Text = "";
			// 
			// bSameAssembly
			// 
			this.bSameAssembly.Location = new System.Drawing.Point(24, 176);
			this.bSameAssembly.Name = "bSameAssembly";
			this.bSameAssembly.Size = new System.Drawing.Size(168, 40);
			this.bSameAssembly.TabIndex = 0;
			this.bSameAssembly.Text = "InProc frhe Bindung (selbe Assembly)";
			this.bSameAssembly.Click += new System.EventHandler(this.bSameAssembly_Click);
			// 
			// bOutProcHttp
			// 
			this.bOutProcHttp.Location = new System.Drawing.Point(24, 336);
			this.bOutProcHttp.Name = "bOutProcHttp";
			this.bOutProcHttp.Size = new System.Drawing.Size(168, 40);
			this.bOutProcHttp.TabIndex = 12;
			this.bOutProcHttp.Text = "SAO OutProc HTTP-Remoting (startet Server Prozess)";
			this.bOutProcHttp.Click += new System.EventHandler(this.bOutProcHttp_Click);
			// 
			// bOutProcCAO
			// 
			this.bOutProcCAO.Location = new System.Drawing.Point(24, 392);
			this.bOutProcCAO.Name = "bOutProcCAO";
			this.bOutProcCAO.Size = new System.Drawing.Size(168, 40);
			this.bOutProcCAO.TabIndex = 13;
			this.bOutProcCAO.Text = "CAO OutProc TCP-Remoting (startet Server Prozess)";
			this.bOutProcCAO.Click += new System.EventHandler(this.bOutProcCAO_Click);
			// 
			// Form2
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 445);
			this.Controls.Add(this.bOutProcCAO);
			this.Controls.Add(this.bOutProcHttp);
			this.Controls.Add(this.bSameAssembly);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.bInProc);
			this.Controls.Add(this.bOutProcTcp);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Name = "Form2";
			this.Text = "C# calls C#";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form2_Closing);
			this.ResumeLayout(false);

		}
    #endregion

    [STAThread]
    static void Main() 
    {
      Application.Run(new Form2());
    }


    string TestProcID(int pid)
    {
      if (pid == Process.GetCurrentProcess().Id)
        return "\r\nin-process";
      else 
        return "\r\n out-of-process";
    }


    string [] msgs = new string[] {"Empty loop", "NoParam", 
                                    "IntParam", "StrParam", "StrParam2", "IntProp", "StrProp"};

    private void bSameAssembly_Click(object sender, System.EventArgs e)
    {
			SwitchButtons(); 
			textBox1.Text += "\r\n*** .NET, early binding ***"; 
      DateTime dtStart = DateTime.Now;
      
      SameAssblyCSharpNETServ CsObj = new SameAssblyCSharpNETServ(); 

      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 100000; i++)
      {
        CsObj = new SameAssblyCSharpNETServ(); 
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 

      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 1000000; k++)
          switch(i)
          {
            case 0: break;
            case 1: CsObj.NoParam(); break;
            case 2: CsObj.IntParam(4); break;
            case 3: CsObj.StrParam("Some string"); break;
            case 4: CsObj.StrParam("Some string with twice as much characters"); break;
            case 5: int dummy = CsObj.IntVal; break;
            case 6: string d = CsObj.StrVal; break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + ts.TotalMilliseconds.ToString("F"); 
        textBox1.Refresh(); 
      }
			SwitchButtons(); 
		}

		// Inproc-Aufruf mit spter Bindung (Typdefinition via Interfacetyp)
    private void bInProc_Click(object sender, System.EventArgs e)
    {
			SwitchButtons(); 
      textBox1.Text += "\r\n*** .NET, late binding ***"; 
      DateTime dtStart = DateTime.Now;
			System.Reflection.Assembly ably = System.Reflection.Assembly.Load("CSharpNETObj"); 
			ICSharpNETServ CsDllObj  =  (ICSharpNETServ) ably.CreateInstance("CSharpNETComponent.CSharpNETServ"); 
      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsDllObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 100000; i++)
      {
				CsDllObj  =  (ICSharpNETServ) ably.CreateInstance("CSharpNETComponent.CSharpNETServ"); 
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 

      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 1000000; k++)
          switch(i)
          {
            case 0: break;
            case 1: CsDllObj.NoParam(); break;
            case 2: CsDllObj.IntParam(4); break;
            case 3: CsDllObj.StrParam("Some string"); break;
            case 4: CsDllObj.StrParam("Some string with twice as much characters"); break;
            case 5: int dummy = CsDllObj.IntVal; break;
            case 6: string d = CsDllObj.StrVal; break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + ts.TotalMilliseconds.ToString("F"); 
        textBox1.Refresh(); 
      }
			SwitchButtons(); 
    }

    private void bOutProcTcp_Click(object sender, System.EventArgs e)
    {
			SwitchButtons(); 
      textBox1.Text += "\r\n*** .NET TCP-Remoting SAO ***"; 
			DateTime dtStart = DateTime.Now;
			StartRemoteServer(); 
      CSharpNETServOutTCP CsExeObj = new CSharpNETServOutTCP(); 
      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsExeObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 1000; i++)
      {
        CsExeObj = new CSharpNETServOutTCP(); 
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (100*ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 
      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 1000; k++)
          switch(i)
          {
            case 0: break;
            case 1: CsExeObj.NoParam(); break;
            case 2: CsExeObj.IntParam(4); break;
            case 3: CsExeObj.StrParam("Some string"); break;
            case 4: CsExeObj.StrParam("Some string with twice as much characters"); break;
            case 5: int dummy = CsExeObj.IntVal; break;
            case 6: string d = CsExeObj.StrVal; break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + (1000*ts.TotalMilliseconds).ToString("F"); 
        textBox1.Refresh(); 
      }
			StopRemoteServer(); 
			SwitchButtons(); 
    }

		void SwitchButtons()
		{
			bool state = !bOutProcTcp.Enabled; 
			bOutProcTcp.Enabled = state; 
			bInProc.Enabled = state; 
			bSameAssembly.Enabled = state; 
			bOutProcHttp.Enabled=state; 
			bOutProcCAO.Enabled=state; 
		}

    Process OutProc = new Process(); 
		bool TypeRegistered = false;  // weil RegisterWellknownClientType nicht rckgng zu machen
		private void StartRemoteServer()
		{
#if DEBUG
			OutProc.StartInfo.FileName = "..\\..\\..\\CSharpRemotingServer\\bin\\Debug\\CSharpRemoteServ.exe";
#else
      OutProc.StartInfo.FileName = "..\\..\\..\\CSharpRemotingServer\\bin\\Release\\CSharpRemoteServ.exe";
#endif

			OutProc.Start(); 
			if (!TypeRegistered)
			{
				RemotingConfiguration.RegisterWellKnownClientType(
					typeof(CSharpNETServOutTCP),"tcp://localhost:8001/CSharpRemoteServ/MyCSharpNETServ"); 
				RemotingConfiguration.RegisterWellKnownClientType(
					typeof(CSharpNETServOutHTTP),"http://localhost:8080/CSharpRemoteServ/MyCSharpNETServ"); 
				RemotingConfiguration.RegisterActivatedClientType(typeof(CSharpNETServOutCAO),"tcp://localhost:8001");  
				TypeRegistered = true; 
			}
		} 
		private void StopRemoteServer()
    {
      if(OutProc.StartInfo.FileName != "")
				if (!OutProc.HasExited)
				{
					OutProc.CloseMainWindow(); 
				}
    }
		private void Form2_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			StopRemoteServer(); 
		}

		private void bOutProcHttp_Click(object sender, System.EventArgs e)
		{
			SwitchButtons(); 
			textBox1.Text += "\r\n*** .NET HTTP-Remoting SAO ***"; 
			DateTime dtStart = DateTime.Now;
			StartRemoteServer(); 

			CSharpNETServOutHTTP CsExeObj = new CSharpNETServOutHTTP(); 

			TimeSpan ts = DateTime.Now - dtStart; 
			textBox1.Text += TestProcID(CsExeObj.ProcessID); 
			textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
			textBox1.Refresh(); 

			dtStart = DateTime.Now; 
			for (int i = 0; i < 1000; i++)
			{
				CsExeObj = new CSharpNETServOutHTTP(); 
			}
			ts = DateTime.Now - dtStart; 
			textBox1.Text += "\r\nCreate (100K): " + (100*ts.TotalMilliseconds).ToString("F"); 
			textBox1.Refresh(); 
			for(int i = 0; i < 7; i++)
			{
				dtStart = DateTime.Now; 
				for (int k = 0; k < 1000; k++)
					switch(i)
					{
						case 0: break;
						case 1: CsExeObj.NoParam(); break;
						case 2: CsExeObj.IntParam(4); break;
						case 3: CsExeObj.StrParam("Some string"); break;
						case 4: CsExeObj.StrParam("Some string with twice as much characters"); break;
						case 5: int dummy = CsExeObj.IntVal; break;
						case 6: string d = CsExeObj.StrVal; break;
					}
				ts = DateTime.Now - dtStart; 
				textBox1.Text += "\r\n"+msgs[i]+": " + (1000*ts.TotalMilliseconds).ToString("F"); 
				textBox1.Refresh(); 
			}
			StopRemoteServer(); 
			SwitchButtons(); 
		}

		private void bOutProcCAO_Click(object sender, System.EventArgs e)
		{
			SwitchButtons(); 
			textBox1.Text += "\r\n*** .NET TCP-Remoting CAO ***"; 
			DateTime dtStart = DateTime.Now;
			StartRemoteServer(); 
			CSharpNETServOutCAO CsExeObj = new CSharpNETServOutCAO(); 
			TimeSpan ts = DateTime.Now - dtStart; 
			textBox1.Text += TestProcID(CsExeObj.ProcessID); 
			textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
			textBox1.Refresh(); 

			dtStart = DateTime.Now; 
			for (int i = 0; i < 1000; i++)
			{
				CsExeObj = new CSharpNETServOutCAO(); 
			}
			ts = DateTime.Now - dtStart; 
			textBox1.Text += "\r\nCreate (100K): " + (100*ts.TotalMilliseconds).ToString("F"); 
			textBox1.Refresh(); 
			for(int i = 0; i < 7; i++)
			{
				dtStart = DateTime.Now; 
				for (int k = 0; k < 1000; k++)
					switch(i)
					{
						case 0: break;
						case 1: CsExeObj.NoParam(); break;
						case 2: CsExeObj.IntParam(4); break;
						case 3: CsExeObj.StrParam("Some string"); break;
						case 4: CsExeObj.StrParam("Some string with twice as much characters"); break;
						case 5: int dummy = CsExeObj.IntVal; break;
						case 6: string d = CsExeObj.StrVal; break;
					}
				ts = DateTime.Now - dtStart; 
				textBox1.Text += "\r\n"+msgs[i]+": " + (1000*ts.TotalMilliseconds).ToString("F"); 
				textBox1.Refresh(); 
			}
			StopRemoteServer(); 
			SwitchButtons(); 
		}
   }

  public class SameAssblyCSharpNETServ : ICSharpNETServ
  {
    private int m_IntVal, Result;
    private string m_StrVal; 
    public void IntParam(int Param1)
    {
      m_IntVal = Param1; 
      Result = 0; 
    }
    public void NoParam() 
    {
      Result = 0; 
    }
    public int IntVal
    { 
      get 
      {
        Result = 0; 
        return m_IntVal; 
      }
    } 
    public string StrVal 
    { 
      get 
      {
        Result = 0; 
        return m_StrVal; 
      }
    } 

    public void StrParam(string Param1)
    {
      m_StrVal = Param1; 
      Result = 0; 
    }

    public int ProcessID
    {
      get
      {
        return Process.GetCurrentProcess().Id;
      }
    }
  }

}
