VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmDubletten 
   Caption         =   "frmDubletten"
   ClientHeight    =   6345
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   9240
   OleObjectBlob   =   "frmDubletten.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmDubletten"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2004, Ralf Nebelo

Dim objAktOrdner As MAPIFolder

'*****************************************************************
'Ereignisprozeduren
'*****************************************************************

Private Sub UserForm_Initialize()
    'Verweis auf aktuell geffneten Ordner holen
    Set objAktOrdner = ActiveExplorer.CurrentFolder
    'Wenn Ordner keine Kontakte enthlt, dann...
    If objAktOrdner.DefaultItemType <> olContactItem Then
        '... Fehlermeldung ausgeben
        MsgBox "Bitte ffnen Sie einen Ordner mit Kontaktelementen.", vbInformation, OL_Dubletten.APPNAME
        'Dialog beenden
        End
    End If
    
    'Fenstertiteltext festlegen
    Me.Caption = OL_Dubletten.APPNAME & " -  2004, Ralf Nebelo"
    
    'Listenfeld konfigurieren
    With lstAnzeige
        'Liste mit Optionsfeldern anzeigen
        .ListStyle = fmListStyleOption
        'Mehrfachauswahl erlauben
        .MultiSelect = fmMultiSelectMulti
        '6 Spalten einrichten
        .ColumnCount = 6
        'Spaltenbreiten festlegen; letzte Spalte unsichtbar
        .ColumnWidths = "60;40;60;90;90;0"
    End With
    
    'Kontrollkstchen chkNachname konfigurieren
    With chkNachname
        'Einschalten
        .Value = True
        'Deaktivieren
        .Enabled = False
    End With
    
    'Status der brigen Kontrollkstchen aus Registry lesen
    chkVorname.Value = CBool(GetSetting(OL_Dubletten.APPNAME, "Einstellungen", Key:="Vorname", Default:="Wahr"))
    chkWohnort.Value = CBool(GetSetting(OL_Dubletten.APPNAME, "Einstellungen", Key:="Wohnort", Default:="Falsch"))
    chkFirma.Value = CBool(GetSetting(OL_Dubletten.APPNAME, "Einstellungen", Key:="Firma", Default:="Falsch"))
    chkEMail.Value = CBool(GetSetting(OL_Dubletten.APPNAME, "Einstellungen", Key:="EMail", Default:="Falsch"))
End Sub

Private Sub cmdSuchen_Click()
    Dim objSortItems As Items
    Dim intI As Integer
    Dim objItem As ContactItem
    Dim intJ As Integer
    Dim objVglItem As ContactItem
    Dim objUserProp As UserProperty
    Dim blnIstDublette As Boolean
    Dim blnAngezeigt As Boolean

    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Listenfeld konfigurieren
    With lstAnzeige
        'Alle Elemente lschen
        .Clear
        
        'Kontakte aus bjAktOrdner in Item-Array kopieren
        Set objSortItems = objAktOrdner.Items
        'Item-Array aufsteigend nach 'LastName'-Eigenschaft sortieren
        objSortItems.Sort "[LastName]", False
        
        'Alle Array-Elemente durchlaufen
        For intI = 1 To objSortItems.Count
            'Verweis auf aktuellen Kontakt holen
            Set objItem = objSortItems(intI)
            'Kontakt wird nicht angezeigt
            blnAngezeigt = False

            'Benutzerdefinierte Eigenschaft "Dublette" finden
            Set objUserProp = objItem.UserProperties.Find("Dublette")
            'Wenn benutzerdefinierte Eigenschaft nicht existiert
            'und Kontakt damit noch nicht als Dublette erkannt ist,
            'dann...
            If objUserProp Is Nothing Then
                'Alle Array-Elemente nach aktuellem Kontakt durchlaufen
                For intJ = intI + 1 To objSortItems.Count
                    'Verweis auf Vergleichskontakt holen
                    Set objVglItem = objSortItems(intJ)
                    'Vergleichskontakt ist wahrscheinlich keine Dublette
                    blnIstDublette = False
                    
                    'Wenn die Nachnamen von Kontakt und Vergleichskontakt
                    'bereinstimmen, dann...
                    If LCase(objItem.LastName) = LCase(objVglItem.LastName) Then
                        '... ist Vergleichskontakt Dublette
                        blnIstDublette = True
                    'Wenn die Nachnamen von Kontakt und Vergleichskontakt
                    'nicht bereinstimmen, dann...
                    Else
                        'Innere Schleife verlassen
                        Exit For
                    End If
                    
                    'Wenn Kontrollkstchen chkVorname eingeschaltet
                    'und die Vornamen nicht bereinstimmen, dann...
                    If chkVorname.Value = True And LCase(objItem.FirstName) <> LCase(objVglItem.FirstName) Then
                        '... ist Vergleichskontakt doch keine Dublette
                        blnIstDublette = False
                    End If
                        
                    'Wenn Kontrollkstchen chkWohnort eingeschaltet
                    'und die Wohnorte nicht bereinstimmen, dann...
                    If chkWohnort.Value = True And LCase(objItem.MailingAddressCity) <> LCase(objVglItem.MailingAddressCity) Then
                        '... ist Vergleichskontakt doch keine Dublette
                        blnIstDublette = False
                    End If
                    
                    'Wenn Kontrollkstchen chkFirma eingeschaltet
                    'und die Firmen nicht bereinstimmen, dann...
                    If chkFirma.Value = True And LCase(objItem.CompanyName) <> LCase(objVglItem.CompanyName) Then
                        '... ist Vergleichskontakt doch keine Dublette
                        blnIstDublette = False
                    End If
                    
                    'Wenn Kontrollkstchen chkEMail eingeschaltet
                    'und die E-Mail-Adressen nicht bereinstimmen, dann...
                    If chkEMail.Value = True And LCase(objItem.Email1Address) <> LCase(objVglItem.Email1Address) Then
                        '... ist Vergleichskontakt doch keine Dublette
                        blnIstDublette = False
                    End If
                    
                    'Wenn Vergleichskontakt als Dublette erkannt ist und...
                    If blnIstDublette = True Then
                        '... wenn der Kontakt bislang nicht angezeigt wird, dann...
                        If blnAngezeigt = False Then
                            '... neue Listenfeldspalte mit Nachname des Kontakts anlegen
                            .AddItem objItem.LastName
                            'Vorname des Kontakts in zweite Spalte bernehmen
                            .List(.ListCount - 1, 1) = objItem.FirstName
                            'Wohnort des Kontakts in dritte Spalte bernehmen
                            .List(.ListCount - 1, 2) = objItem.MailingAddressCity
                            'Firma des Kontakts in vierte Spalte bernehmen
                            .List(.ListCount - 1, 3) = objItem.CompanyName
                            'E-Mail-Adresse des Kontakts in fnfte Spalte bernehmen
                            .List(.ListCount - 1, 4) = objItem.Email1Address
                            'Entry-ID des Kontakts in unsichtbare Spalte bernehmen
                            .List(.ListCount - 1, 5) = objItem.EntryID
                            blnAngezeigt = True
                        End If
                        
                        'Neue Listenfeldspalte mit Nachname des Vergleichskontakts anlegen
                        .AddItem objVglItem.LastName
                        'Vorname des Vergleichskontakts in zweite Spalte bernehmen
                        .List(.ListCount - 1, 1) = objVglItem.FirstName
                        'Wohnort des Vergleichskontakts in dritte Spalte bernehmen
                        .List(.ListCount - 1, 2) = objVglItem.MailingAddressCity
                        'Firma des Vergleichskontakts in vierte Spalte bernehmen
                        .List(.ListCount - 1, 3) = objVglItem.CompanyName
                        'E-Mail-Adresse des Vergleichskontakts in fnfte Spalte bernehmen
                        .List(.ListCount - 1, 4) = objVglItem.Email1Address
                        'Entry-ID in unsichtbare Spalte bernehmen
                        .List(.ListCount - 1, 5) = objVglItem.EntryID
                        'Listenfeldeintrag selektieren
                        .Selected(.ListCount - 1) = True

                        'Vergleichskontakt durch Anlegen einer benutzerdefinierten
                        'Eigenschaft "Dublette" als Dublette kennzeichnen und speichern
                        With objVglItem
                            .UserProperties.Add("Dublette", olText).Value = "True"
                            .Save
                        End With
                    End If
                Next
            End If
        Next
        
        'Letztes Element markieren
        .ListIndex = .ListCount - 1
    End With
    'Benutzerdefinierte Eigenschaft "Dublette" aus allen Elementen lschen
    Call UserPropLschen("Dublette")
    
    'Status der Kontrollkstchen in Registry sichern
    SaveSetting OL_Dubletten.APPNAME, "Einstellungen", "Vorname", chkVorname.Value
    SaveSetting OL_Dubletten.APPNAME, "Einstellungen", "Wohnort", chkWohnort.Value
    SaveSetting OL_Dubletten.APPNAME, "Einstellungen", "Firma", chkFirma.Value
    SaveSetting OL_Dubletten.APPNAME, "Einstellungen", "EMail", chkEMail.Value
    
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub lstAnzeige_Change()
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub cmdAction_Click()
    Dim intI As Integer
    Dim strEntryID As String
    Dim objItem As ContactItem

    'Wenn User Lschbesttigung gibt, dann...
    If MsgBox("Sind Sie sicher, dass Sie die markierten Kontakte endgltig lschen mchten?", vbYesNoCancel + vbDefaultButton2, OL_Dubletten.APPNAME) = vbYes Then
        With lstAnzeige
            '... alle Listenfeldelemente rckwrts durchlaufen
            For intI = .ListCount To 1 Step -1
                'Wenn Element selektiert, dann...
                If .Selected(intI - 1) = True Then
                    '... Entry-ID aus unsichtbarer Listenfeldspalte lesen
                    strEntryID = .List(intI - 1, 5)
                    'Verweis auf Outlook-Element ber Entry-ID holen
                    Set objItem = GetNamespace("MAPI").GetItemFromID(strEntryID)
                    'Wenn Outlook-Element existiert, dann...
                    If Not objItem Is Nothing Then
                        '... Outlook-Element lschen
                        objItem.Delete
                    End If
                    
                    'Listenfeldelement lschen
                    .RemoveItem intI - 1
                End If
            Next
        End With
            
        'Prozedur fr Schaltflchenstatus aufrufen
        Call ButtonStatus
    End If
End Sub

Private Sub cmdCancel_Click()
    'Userform entladen
    Unload Me
End Sub

'*****************************************************************
'Allgemeine Prozeduren
'*****************************************************************

Private Sub UserPropLschen(strPropName As String)
    Dim objItem As ContactItem
    Dim objUserProp As UserProperty
    
    'Alle Elemente des aktuellen Ordners durchlaufen
    For Each objItem In objAktOrdner.Items
        'Benutzerdefinierte Eigenschaft suchen
        Set objUserProp = objItem.UserProperties.Find(strPropName)
        'Wenn benutzerdefinierte Eigenschaft existiert, dann...
        If Not objUserProp Is Nothing Then
            'Benutzerdefinierte Eigenschaft lschen
            objUserProp.Delete
            'Element speichern
            objItem.Save
        End If
    Next
End Sub

Private Sub ButtonStatus()
    Dim intI As Integer
    Dim blnMarkiert As Boolean
    
    'Annahme: Nichts markiert
    blnMarkiert = False
    With lstAnzeige
        'Alle Listenelement durchlaufen
        For intI = 1 To .ListCount
            'Wenn Element selektiert ist, dann...
            If .Selected(intI - 1) = True Then
                '... Markierung vorhanden
                blnMarkiert = True
                'Schleife verlassen
                Exit For
            End If
        Next
    End With
    
    'Ergebnis zurckgeben
    cmdAction.Enabled = blnMarkiert
End Sub


