#!/usr/bin/perl
#
# Syntax: dirhir <root-dir> <Level> <size> <master-dir>
#
# fast version of dirhir.pl, cheats by copying directories
# created by 
#
# dirhir.pl r0 0 8
#
# <master-dir> needs full path
#
# Example:
# ./dirhirf.pl r5 5 8 /var/www/r0
# 

use Cwd;
use Cwd 'chdir';

$dirmode = 0777;
$level = 0;
my $indir;


sub mklevel {
# Paramter: level = depth of level
# does recursiv calls to itself with (level-1)

  my $level = $_[0];
  my $i;
  my $aktdir = cwd();

  if ($level > 0) {
    # Directories erzeugen
    for ($i = 0; $i < 10; $i++) {
      my $newdir = "$aktdir/$i";
      mkdir $newdir, $dirmode or die "Can't mkdir $newdir: $!\n";
      chdir $newdir or die "Can't chdir $newdir: $!\n";
      mklevel($level-1);
      chdir "..";
    }
  } else {
    # create files
    system "cp $indir/* ."
  }
}


#
# main
#
if ( $#ARGV < 2 ) {
  print "For description see source code\n"
  die "Usage: $0 <root-dir> <levels> <size> <master-dir>\n";
}

$root = $ARGV[0];
$levels = $ARGV[1];
$size = 1024 * $ARGV[2];
$indir = $ARGV[3];

mkdir "./$root", $dirmode or print "$root exists, using it\n";
chdir "./$root" or die "Can't chdir $root: $!\n";
srand();     # initialise random numbers
mklevel($levels);
