/*	Projekt SetZoneId
	SpeedProject
	Copyright  1995 - 2004. Alle Rechte vorbehalten.

	Datei:		SetZoneId.cpp
	Autor:		Sven Ritter
	Datum:		11.08.2004 - 15:20
	
	
	UEBERBLICK
	==========
	Quelltextdatei fuer die Implementation vom Hauptmodul.
*/


#include "StdAfx.h"


// ****************************************************************************
// ******                 Implementation zu PrintParameters              ******
// ****************************************************************************
void PrintParameters()
{
	_tprintf(_T("Aufruf: SetZoneId.exe <Dateiname> [ZoneId]\r\n\r\n"));
	_tprintf(_T("ZoneId:\r\n  0 - Entfernen\r\n  1 - URLZONE_INTRANET\r\n  2 - URLZONE_TRUSTED\r\n  3 - URLZONE_INTERNET\r\n  4 - URLZONE_UNTRUSTED\r\n\r\n"));
}


// ****************************************************************************
// ******                      Implementation zu _tmain                  ******
// ****************************************************************************
int _tmain(int argc, _TCHAR* argv[])
{
	// Argumente muessen passen
	if (argc < 2 || argc > 3)
	{
		// Benoetigte Parameter anzeigen
		PrintParameters();

		// Und wech...
		return -1;
	}

	// Per Default nur die Zone anzeigen
	BOOL fSetZoneId = FALSE; DWORD dwZone = 0; HRESULT hResult = S_OK;

	// Zone soll gesetzt werden
	if (3 == argc)
	{
		// Uebergebene Zone pruefen
		dwZone = _ttoi(argv[2]);
		if (dwZone < URLZONE_PREDEFINED_MIN || dwZone > URLZONE_PREDEFINED_MAX)
		{
			// Benoetigte Parameter anzeigen
			PrintParameters();

			// Und wech...
			return -1;
		}

		// ID wird gesetzt
		fSetZoneId = TRUE;
	}

	// Dateinamen nach Unicode konvertieren
	wchar_t wszFileName[MAX_PATH]; ZeroMemory(wszFileName, sizeof(wszFileName));
	MultiByteToWideChar(CP_ACP, 0, argv[1], lstrlen(argv[1]), wszFileName, countof(wszFileName));

	// COM initialisieren
	CoInitialize(NULL);
	
	// Im Block, da die intelligenten Pointer vor CoUnitialize freigegeben werden muessen
	{
		// Schnittstellen
		IZoneIdentifierPtr pZoneIdentifier; IPersistFilePtr pPersistFile = NULL;

		// PersistentZoneIdentifier-Klasse instantiieren
		hResult = CoCreateInstance(CLSID_PersistentZoneIdentifier, NULL, CLSCTX_INPROC_SERVER, IID_IZoneIdentifier, (void**) &pZoneIdentifier);
		if (SUCCEEDED(hResult))
		{
			hResult = pZoneIdentifier->QueryInterface(IID_IPersistFile, (void**) &pPersistFile);
			if (SUCCEEDED(hResult))
			{
				// ID wird gesetzt
				if (fSetZoneId)
				{
					// ZoneId loeschen
					//	-> Setzen als 0 geht in die Hose
					if (0 == dwZone)
					{
						hResult = pZoneIdentifier->Remove();
					}

					// ZoneId setzen
					else
					{
						hResult = pZoneIdentifier->SetId(dwZone);
					}

					// Zone setzen
					if (SUCCEEDED(hResult) && SUCCEEDED(pPersistFile->Save(wszFileName, TRUE)))
					{
						pPersistFile->SaveCompleted(wszFileName);
						_tprintf(_T("ZoneId erfolgreich gesetzt.\r\n"), dwZone);
					}

					// Setzen ging schief
					else
					{
						_tprintf(_T("Fehler beim Setzen der ZoneId.\r\n"), dwZone);
					}
				}

				// ID wird nur angezeigt
				else
				{
					// Datei laden
					hResult = pPersistFile->Load(wszFileName, STGM_READ);

					// Zone abfragen
					if (SUCCEEDED(hResult) && SUCCEEDED(pZoneIdentifier->GetId(&dwZone)))
					{
						_tprintf(_T("ZoneId: %ld\r\n"), dwZone);
					}

					// Laden ging schief -> Datei besitzt keine ZoneId
					else
					{
						_tprintf(_T("Die Datei besitzt keine ZoneId.\r\n"), dwZone);
					}
				}
			}

			// Fehler bei der Abfrage von IPersistFile
			else
			{
				_tprintf(_T("Fehler bei der Abfrage von IPersistFile.\r\n"));
			}
		}

		// Fehler bei der Instantiierung
		else
		{
			_tprintf(_T("Fehler bei der Instantiierung von CLSID_PersistentZoneIdentifier.\r\n"));
		}
	}

	// COM freigeben
	CoUninitialize();

	// Und wech...
	return 0;
}

